/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.feruchemy.common.registries;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import leaf.cosmere.api.EnumUtils;
import leaf.cosmere.api.Metals;
import leaf.cosmere.common.registration.impl.ManifestationDeferredRegister;
import leaf.cosmere.common.registration.impl.ManifestationRegistryObject;
import leaf.cosmere.feruchemy.common.manifestation.FeruchemyAluminum;
import leaf.cosmere.feruchemy.common.manifestation.FeruchemyAtium;
import leaf.cosmere.feruchemy.common.manifestation.FeruchemyBendalloy;
import leaf.cosmere.feruchemy.common.manifestation.FeruchemyBronze;
import leaf.cosmere.feruchemy.common.manifestation.FeruchemyCopper;
import leaf.cosmere.feruchemy.common.manifestation.FeruchemyGold;
import leaf.cosmere.feruchemy.common.manifestation.FeruchemyManifestation;
import leaf.cosmere.feruchemy.common.manifestation.FeruchemyNicrosil;

public class FeruchemyManifestations {
    public static final ManifestationDeferredRegister MANIFESTATIONS = new ManifestationDeferredRegister("feruchemy");
    public static final Map<Metals.MetalType, ManifestationRegistryObject<FeruchemyManifestation>> FERUCHEMY_POWERS = Arrays.stream(EnumUtils.METAL_TYPES).filter(Metals.MetalType::hasAssociatedManifestation).collect(Collectors.toMap(Function.identity(), metalType -> MANIFESTATIONS.register(metalType.m_6082_(), () -> FeruchemyManifestations.makeFeruchemyManifestation(metalType))));

    private static FeruchemyManifestation makeFeruchemyManifestation(Metals.MetalType metalType) {
        switch (metalType) {
            case COPPER: {
                return new FeruchemyCopper(metalType);
            }
            case BRONZE: {
                return new FeruchemyBronze(metalType);
            }
            case ALUMINUM: {
                return new FeruchemyAluminum(metalType);
            }
            case NICROSIL: {
                return new FeruchemyNicrosil(metalType);
            }
            case GOLD: {
                return new FeruchemyGold(metalType);
            }
            case BENDALLOY: {
                return new FeruchemyBendalloy(metalType);
            }
            case ATIUM: {
                return new FeruchemyAtium(metalType);
            }
        }
        return new FeruchemyManifestation(metalType);
    }
}

