/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.feruchemy.client.utils;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import leaf.cosmere.api.CosmereAPI;
import leaf.cosmere.api.Metals;
import leaf.cosmere.common.items.ChargeableMetalCurioItem;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public class FeruchemyChargeThread
implements Runnable {
    private static final Lock lock = new ReentrantLock();
    private static FeruchemyChargeThread INSTANCE;
    private static final HashMap<Metals.MetalType, Double> feruchemyChargeMap;
    static Thread t;
    static boolean isStopping;

    public static FeruchemyChargeThread getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new FeruchemyChargeThread();
        }
        return INSTANCE;
    }

    public HashMap<Metals.MetalType, Double> getCharges() {
        try {
            HashMap<Metals.MetalType, Double> retVal = new HashMap<Metals.MetalType, Double>();
            if (lock.tryLock()) {
                retVal.putAll(feruchemyChargeMap);
                lock.unlock();
            }
            return retVal;
        }
        catch (Exception e) {
            e.printStackTrace();
            lock.unlock();
            return new HashMap<Metals.MetalType, Double>();
        }
    }

    public void start() {
        if (t == null || isStopping) {
            CosmereAPI.logger.info("Feruchemy thread started");
            t = new Thread((Runnable)this, "feruchemy_enumerator_thread");
            isStopping = false;
            t.start();
        }
    }

    public void stop() {
        if (t != null && !isStopping) {
            isStopping = true;
        }
    }

    @Override
    public void run() {
        Minecraft mc = Minecraft.m_91087_();
        HashMap<Metals.MetalType, Double> metalmindCharges = new HashMap<Metals.MetalType, Double>();
        while (!isStopping) {
            try {
                if (mc.f_91073_ == null || mc.f_91074_ == null || !mc.f_91073_.f_46443_) break;
                if (mc.f_91074_.f_19797_ % 2 != 0) {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                metalmindCharges.clear();
                for (ItemStack stack : mc.f_91074_.m_150109_().f_35974_) {
                    Item item = stack.m_41720_();
                    if (!(item instanceof ChargeableMetalCurioItem)) continue;
                    ChargeableMetalCurioItem item2 = (ChargeableMetalCurioItem)item;
                    Double chargeToAdd = item2.getCharge(stack);
                    if (metalmindCharges.containsKey(item2.getMetalType())) {
                        metalmindCharges.put(item2.getMetalType(), (Double)metalmindCharges.get(item2.getMetalType()) + chargeToAdd);
                        continue;
                    }
                    metalmindCharges.put(item2.getMetalType(), chargeToAdd);
                }
                CuriosApi.getCuriosInventory((LivingEntity)mc.f_91074_).ifPresent(handler -> {
                    Map curios = handler.getCurios();
                    for (ICurioStacksHandler stacksHandler : curios.values()) {
                        IDynamicStackHandler stacks = stacksHandler.getStacks();
                        for (int i = 0; i < stacks.getSlots(); ++i) {
                            ItemStack stackInSlot = stacks.getStackInSlot(i);
                            Item patt3787$temp = stackInSlot.m_41720_();
                            if (!(patt3787$temp instanceof ChargeableMetalCurioItem)) continue;
                            ChargeableMetalCurioItem item = (ChargeableMetalCurioItem)patt3787$temp;
                            Double chargeToAdd = item.getCharge(stackInSlot);
                            if (metalmindCharges.containsKey(item.getMetalType())) {
                                metalmindCharges.put(item.getMetalType(), (Double)metalmindCharges.get(item.getMetalType()) + chargeToAdd);
                                continue;
                            }
                            metalmindCharges.put(item.getMetalType(), chargeToAdd);
                        }
                    }
                });
                CuriosApi.getCuriosInventory((LivingEntity)mc.f_91074_).map(mapper -> true);
                try {
                    if (!lock.tryLock()) continue;
                    feruchemyChargeMap.clear();
                    feruchemyChargeMap.putAll(metalmindCharges);
                    lock.unlock();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    lock.unlock();
                }
            }
            catch (Exception e) {
                CosmereAPI.logger.warn(Arrays.toString(e.getStackTrace()));
            }
        }
        this.stop();
    }

    static {
        feruchemyChargeMap = new HashMap();
        isStopping = false;
    }
}

