/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.feruchemy.common.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import java.util.UUID;
import leaf.cosmere.api.Constants;
import leaf.cosmere.api.Metals;
import leaf.cosmere.api.helpers.StackNBTHelper;
import leaf.cosmere.common.charge.IChargeable;
import leaf.cosmere.common.items.ChargeableMetalCurioItem;
import leaf.cosmere.feruchemy.common.registries.FeruchemyLootFunctions;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class InvestMetalmindLootFunction
extends LootItemConditionalFunction {
    protected InvestMetalmindLootFunction(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    public LootItemFunctionType m_7162_() {
        return (LootItemFunctionType)FeruchemyLootFunctions.INVEST_METALMIND.get();
    }

    protected ItemStack m_7372_(ItemStack stack, LootContext lootContext) {
        if (!(stack.m_41720_() instanceof IChargeable)) {
            return stack;
        }
        ChargeableMetalCurioItem item = (ChargeableMetalCurioItem)stack.m_41720_();
        Metals.MetalType metalType = item.getMetalType();
        if (!metalType.hasFeruchemicalEffect() || metalType == Metals.MetalType.NICROSIL) {
            return stack;
        }
        int maxCharge = item.getMaxCharge(stack);
        int strengthBeforeLuck = 2 + lootContext.m_230907_().m_188503_(8);
        float strengthLevel = Mth.m_14036_((float)((float)strengthBeforeLuck + lootContext.m_78945_()), (float)1.0f, (float)10.0f);
        item.setCharge(stack, (int)Mth.m_14179_((float)(strengthLevel / 10.0f), (float)1.0f, (float)maxCharge));
        StackNBTHelper.setUuid((ItemStack)stack, (String)"attuned_player", (UUID)Constants.NBT.UNKEYED_UUID);
        StackNBTHelper.setString((ItemStack)stack, (String)"attuned_player_name", (String)"Unkeyed");
        return stack;
    }

    public static class Serializer
    extends LootItemConditionalFunction.Serializer<InvestMetalmindLootFunction> {
        public InvestMetalmindLootFunction deserialize(JsonObject jsonObject, JsonDeserializationContext deserializationContext, LootItemCondition[] lootConditions) {
            return new InvestMetalmindLootFunction(lootConditions);
        }
    }
}

