/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.feruchemy.common.manifestation;

import leaf.cosmere.api.Metals;
import leaf.cosmere.api.cosmereEffect.CosmereEffect;
import leaf.cosmere.api.cosmereEffect.CosmereEffectInstance;
import leaf.cosmere.api.helpers.EffectsHelper;
import leaf.cosmere.api.spiritweb.ISpiritweb;
import leaf.cosmere.feruchemy.common.config.FeruchemyConfigs;
import leaf.cosmere.feruchemy.common.manifestation.FeruchemyManifestation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;

public class FeruchemyGold
extends FeruchemyManifestation {
    private static final int MIN_TAP_FOR_EXTRA_HEALTH = 5;

    public FeruchemyGold(Metals.MetalType metalType) {
        super(metalType);
    }

    @Override
    public int getCost(ISpiritweb data) {
        int cost = super.getCost(data);
        return this.isTapping(data) ? cost * (Integer)FeruchemyConfigs.SERVER.GOLD_TAP_COST_MULTIPLIER.get() : cost;
    }

    @Override
    public boolean tick(ISpiritweb data) {
        if (!this.isHealActiveTick(data)) {
            return false;
        }
        boolean spend = this.isTapping(data) || this.getActiveTick(data) % 100 == 0;
        if (this.canAfford(data, !spend)) {
            this.applyEffectTick(data);
            return this.isTapping(data);
        }
        return false;
    }

    @Override
    public void applyEffectTick(ISpiritweb data) {
        int mode = this.getMode(data);
        CosmereEffect effect = this.getEffect(mode);
        CosmereEffectInstance currentEffect = EffectsHelper.getNewEffect((CosmereEffect)effect, (Entity)data.getLiving(), (double)Math.abs(mode));
        if (mode <= 0) {
            int bonusHealth = Math.max(0, -mode - 5 + 1);
            currentEffect.setDynamicAttribute(Attributes.f_22276_, (double)bonusHealth / (double)(-mode), AttributeModifier.Operation.ADDITION);
        }
        data.addEffect(currentEffect);
        data.getLiving().m_21153_(data.getLiving().m_21223_());
    }

    public boolean isHealActiveTick(ISpiritweb data) {
        int healTick = Math.max(1, FeruchemyGold.getHealActiveTick(-this.getMode(data)));
        return data.getLiving().f_19797_ % healTick == 0;
    }

    public static int getHealActiveTick(int strength) {
        return (int)Math.floor(200.0 * Math.pow(strength, -1.5));
    }
}

