/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.feruchemy.common.manifestation;

import leaf.cosmere.api.Constants;
import leaf.cosmere.api.CosmereAPI;
import leaf.cosmere.api.Metals;
import leaf.cosmere.api.cosmereEffect.CosmereEffect;
import leaf.cosmere.api.cosmereEffect.CosmereEffectInstance;
import leaf.cosmere.api.helpers.CompoundNBTHelper;
import leaf.cosmere.api.helpers.EntityHelper;
import leaf.cosmere.api.manifestation.Manifestation;
import leaf.cosmere.api.spiritweb.ISpiritweb;
import leaf.cosmere.common.charge.MetalmindChargeHelper;
import leaf.cosmere.common.registry.AttributesRegistry;
import leaf.cosmere.feruchemy.common.manifestation.FeruchemyManifestation;
import leaf.cosmere.feruchemy.common.registries.FeruchemyManifestations;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;

public class FeruchemyNicrosil
extends FeruchemyManifestation {
    public FeruchemyNicrosil(Metals.MetalType metalType) {
        super(metalType);
    }

    @Override
    public int modeMin(ISpiritweb data) {
        return -1;
    }

    @Override
    public int modeMax(ISpiritweb data) {
        return 1;
    }

    @Override
    public boolean tick(ISpiritweb data) {
        int adjustAmount;
        LivingEntity livingEntity = data.getLiving();
        if (!this.isActiveTick(data)) {
            return false;
        }
        int mode = this.getMode(data);
        CosmereEffect effect = this.getEffect(mode);
        if (mode < 0) {
            adjustAmount = mode <= -3 ? -(mode * mode) : mode;
        } else if (mode > 0) {
            adjustAmount = mode;
        } else {
            return false;
        }
        ItemStack itemStack = MetalmindChargeHelper.adjustMetalmindChargeExact((ISpiritweb)data, (Metals.MetalType)this.metalType, (int)adjustAmount, (boolean)true, (boolean)true);
        if (!itemStack.m_41619_()) {
            if (mode > 0) {
                this.checkStoreNicrosil(data, itemStack);
                return false;
            }
            this.checkTapNicrosil(data, itemStack);
            return true;
        }
        data.setMode((Manifestation)this, 0);
        return false;
    }

    private void checkStoreNicrosil(ISpiritweb data, ItemStack metalmind) {
        boolean isStoringIdentity;
        CompoundTag nbt = metalmind.m_41698_("StoredInvestiture");
        int identity = (int)EntityHelper.getAttributeValue((LivingEntity)data.getLiving(), (Attribute)AttributesRegistry.IDENTITY.getAttribute());
        boolean bl = isStoringIdentity = identity < 1;
        if (!nbt.m_128441_("identity") && isStoringIdentity) {
            nbt.m_128362_("identity", Constants.NBT.UNKEYED_UUID);
        } else if (!nbt.m_128441_("identity") || nbt.m_128342_("identity").compareTo(Constants.NBT.UNKEYED_UUID) == 0) {
            nbt.m_128362_("identity", data.getLiving().m_20148_());
        }
        CosmereEffectInstance effectInstance = CosmereEffectInstance.getOrCreateEffect((CosmereEffect)this.getStoringEffect(), (ISpiritweb)data, (LivingEntity)data.getLiving(), (double)1.0);
        for (Manifestation manifestation : CosmereAPI.manifestationRegistry()) {
            boolean invalidMetalToDisable;
            double totalStrength = manifestation.getStrength(data, false);
            String registryName = manifestation.getRegistryName().toString();
            if (totalStrength > 0.0) {
                nbt.m_128347_(registryName, totalStrength);
            } else if (nbt.m_128441_(registryName)) {
                nbt.m_128473_(registryName);
            }
            Attribute attributeRegistryObject = manifestation.getAttribute();
            boolean bl2 = invalidMetalToDisable = manifestation == FeruchemyManifestations.FERUCHEMY_POWERS.get(Metals.MetalType.NICROSIL).get() || manifestation == FeruchemyManifestations.FERUCHEMY_POWERS.get(Metals.MetalType.ALUMINUM).get();
            if (attributeRegistryObject == null || invalidMetalToDisable) continue;
            effectInstance.setDynamicAttribute(manifestation.getAttribute(), -1000.0, AttributeModifier.Operation.ADDITION);
        }
        data.addEffect(effectInstance);
    }

    private void checkTapNicrosil(ISpiritweb data, ItemStack metalmind) {
        CompoundTag nbt = metalmind.m_41698_("StoredInvestiture");
        CosmereEffectInstance effectInstance = CosmereEffectInstance.getOrCreateEffect((CosmereEffect)this.getTappingEffect(), (ISpiritweb)data, (LivingEntity)data.getLiving(), (double)1.0);
        for (Manifestation manifestation : CosmereAPI.manifestationRegistry()) {
            String manifestationName = manifestation.getRegistryName().toString();
            Attribute attribute = manifestation.getAttribute();
            if (CompoundNBTHelper.verifyExistance((CompoundTag)nbt, (String)manifestationName)) {
                double strength = CompoundNBTHelper.getDouble((CompoundTag)nbt, (String)manifestationName, (double)0.0);
                effectInstance.setDynamicAttribute(attribute, strength, AttributeModifier.Operation.ADDITION);
                continue;
            }
            if (attribute == null) continue;
            effectInstance.removeDynamicAttribute(attribute);
        }
        data.addEffect(effectInstance);
    }
}

