/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.feruchemy.mixin;

import java.util.HashMap;
import java.util.Map;
import leaf.cosmere.api.Metals;
import leaf.cosmere.api.cosmereEffect.CosmereEffect;
import leaf.cosmere.common.cap.entity.SpiritwebCapability;
import leaf.cosmere.feruchemy.common.manifestation.FeruchemyAtium;
import leaf.cosmere.feruchemy.common.registries.FeruchemyEffects;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public class EntityMixin {
    @Inject(at={@At(value="RETURN")}, method={"canEnterPose"}, cancellable=true)
    public void handleCanEnterPose(Pose pose, CallbackInfoReturnable<Boolean> cir) {
        LivingEntity livingEntity;
        float scale;
        Entity entity = (Entity)this;
        if (entity instanceof LivingEntity && ((double)(scale = FeruchemyAtium.getScale(livingEntity = (LivingEntity)entity)) > 0.01 || (double)scale < -0.01)) {
            EntityDimensions entityDimensions = livingEntity.m_6972_(pose);
            entityDimensions = entityDimensions.m_20388_(scale);
            double f = entityDimensions.f_20377_ / 2.0f;
            Vec3 vector3d = new Vec3(livingEntity.m_20185_() - f, livingEntity.m_20186_(), livingEntity.m_20189_() - f);
            Vec3 vector3d1 = new Vec3(livingEntity.m_20185_() + f, livingEntity.m_20186_() + (double)entityDimensions.f_20378_, livingEntity.m_20189_() + f);
            AABB box = new AABB(vector3d, vector3d1);
            cir.setReturnValue((Object)livingEntity.m_9236_().m_45756_((Entity)livingEntity, box.m_82406_(1.0E-7)));
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"isSteppingCarefully"}, cancellable=true)
    public void handleIsSteppingCarefully(CallbackInfoReturnable<Boolean> cir) {
        if (((Boolean)cir.getReturnValue()).booleanValue()) {
            return;
        }
        Entity entity = (Entity)this;
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            SpiritwebCapability.get((LivingEntity)livingEntity).ifPresent(data -> {
                CosmereEffect iron = (CosmereEffect)FeruchemyEffects.STORING_EFFECTS.get(Metals.MetalType.IRON).get();
                if (data.totalStrengthOfEffect(iron) > 2) {
                    cir.setReturnValue((Object)true);
                }
            });
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"collide"}, cancellable=true)
    private void collideWithFluid(CallbackInfoReturnable<Vec3> cir) {
        LivingEntity livingEntity;
        Vec3 originalDisplacement = (Vec3)cir.getReturnValue();
        Entity entity = (Entity)this;
        if (!(entity instanceof LivingEntity) || (livingEntity = (LivingEntity)entity).m_6047_()) {
            return;
        }
        if (livingEntity.m_20142_() && livingEntity.m_21133_(Attributes.f_22279_) > (double)0.3f && originalDisplacement.f_82480_ <= 0.0 && !EntityMixin.isTouchingFluid(livingEntity, livingEntity.m_20191_().m_82406_(0.001))) {
            Map<Vec3, Double> points = EntityMixin.findFluidDistances(livingEntity, originalDisplacement);
            Double highestDistance = null;
            for (Map.Entry<Vec3, Double> point : points.entrySet()) {
                if (highestDistance != null && (point.getValue() == null || !(point.getValue() > highestDistance))) continue;
                highestDistance = point.getValue();
            }
            if (highestDistance != null) {
                Vec3 finalDisplacement = new Vec3(originalDisplacement.f_82479_, highestDistance.doubleValue(), originalDisplacement.f_82481_);
                AABB finalBox = livingEntity.m_20191_().m_82383_(finalDisplacement).m_82406_(0.001);
                if (!EntityMixin.isTouchingFluid(livingEntity, finalBox)) {
                    livingEntity.f_19789_ = 0.0f;
                    livingEntity.m_6853_(true);
                    cir.setReturnValue((Object)finalDisplacement);
                }
            }
        }
    }

    @Unique
    private static Map<Vec3, Double> findFluidDistances(LivingEntity entity, Vec3 originalDisplacement) {
        AABB box = entity.m_20191_().m_82383_(originalDisplacement);
        HashMap<Vec3, Double> points = new HashMap<Vec3, Double>();
        points.put(new Vec3(box.f_82288_, box.f_82289_, box.f_82290_), null);
        points.put(new Vec3(box.f_82288_, box.f_82289_, box.f_82293_), null);
        points.put(new Vec3(box.f_82291_, box.f_82289_, box.f_82290_), null);
        points.put(new Vec3(box.f_82291_, box.f_82289_, box.f_82293_), null);
        double fluidStepHeight = entity.m_20096_() ? Math.max(1.0, (double)entity.getStepHeight()) : 0.0;
        block0: for (Map.Entry entry : points.entrySet()) {
            int i = 0;
            while (true) {
                double limitingVelocity;
                BlockPos landingPos = BlockPos.m_274561_((double)((Vec3)entry.getKey()).f_82479_, (double)(((Vec3)entry.getKey()).f_82480_ + (double)i + fluidStepHeight), (double)((Vec3)entry.getKey()).f_82481_);
                FluidState landingState = entity.m_20193_().m_6425_(landingPos);
                double distanceToFluidSurface = (double)((float)landingPos.m_123342_() + landingState.m_76182_()) - entity.m_20186_();
                if (distanceToFluidSurface < (limitingVelocity = originalDisplacement.f_82480_) || distanceToFluidSurface > fluidStepHeight) continue block0;
                if (!landingState.m_76178_()) {
                    entry.setValue(distanceToFluidSurface);
                    continue block0;
                }
                --i;
            }
        }
        return points;
    }

    @Unique
    private static boolean isTouchingFluid(LivingEntity entity, AABB box) {
        int minX = Mth.m_14107_((double)box.f_82288_);
        int maxX = Mth.m_14165_((double)box.f_82291_);
        int minY = Mth.m_14107_((double)box.f_82289_);
        int maxY = Mth.m_14165_((double)box.f_82292_);
        int minZ = Mth.m_14107_((double)box.f_82290_);
        int maxZ = Mth.m_14165_((double)box.f_82293_);
        Level world = entity.m_20193_();
        if (world.m_46812_(minX, minY, minZ, maxX, maxY, maxZ)) {
            BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
            for (int i = minX; i < maxX; ++i) {
                for (int j = minY; j < maxY; ++j) {
                    for (int k = minZ; k < maxZ; ++k) {
                        double surfaceY;
                        mutable.m_122178_(i, j, k);
                        FluidState fluidState = world.m_6425_((BlockPos)mutable);
                        if (fluidState.m_76178_() || !((surfaceY = (double)(fluidState.m_76155_((BlockGetter)world, (BlockPos)mutable) + (float)j)) >= box.f_82289_)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }
}

