/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.feruchemy.client;

import leaf.cosmere.api.helpers.EntityHelper;
import leaf.cosmere.common.registry.AttributesRegistry;
import leaf.cosmere.feruchemy.client.utils.FeruchemyChargeThread;
import leaf.cosmere.feruchemy.common.manifestation.FeruchemyAtium;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderNameTagEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="feruchemy", value={Dist.CLIENT})
public class FeruchemyClientEvents {
    @SubscribeEvent
    public static void onRenderNameplateEvent(RenderNameTagEvent event) {
        float atiumScale;
        Entity entity;
        if (event.isCanceled() || !((entity = event.getEntity()) instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        int connection = (int)EntityHelper.getAttributeValue((LivingEntity)livingEntity, (Attribute)AttributesRegistry.CONNECTION.getAttribute());
        if (connection <= -2) {
            event.setResult(Event.Result.DENY);
        }
        if ((atiumScale = FeruchemyAtium.getScale(livingEntity)) < 1.0f) {
            double scale = atiumScale;
            event.getPoseStack().m_85837_(0.0, scale, 0.0);
        }
    }

    @SubscribeEvent
    public static void onRenderPlayerPre(RenderPlayerEvent.Pre event) {
        try {
            float scale = FeruchemyAtium.getScale((LivingEntity)event.getEntity());
            if ((double)scale > 1.01 || (double)scale < 0.99) {
                event.getPoseStack().m_85836_();
                event.getPoseStack().m_85841_(scale, scale, scale);
                if (event.getEntity().m_6047_() && scale < 0.2f) {
                    event.getPoseStack().m_85837_(0.0, 1.0, 0.0);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public static void onRenderPlayerPost(RenderPlayerEvent.Post event) {
        try {
            float scale = FeruchemyAtium.getScale((LivingEntity)event.getEntity());
            if ((double)scale > 1.01 || (double)scale < 0.99) {
                event.getPoseStack().m_85849_();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public static void onLivingRenderPre(RenderLivingEvent.Pre event) {
        if (event.getEntity() instanceof Player) {
            return;
        }
        try {
            float scale = FeruchemyAtium.getScale(event.getEntity());
            if ((double)scale > 1.01 || (double)scale < 0.99) {
                event.getPoseStack().m_85836_();
                event.getPoseStack().m_85841_(scale, scale, scale);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public static void onLivingRenderPost(RenderLivingEvent.Post event) {
        if (event.getEntity() instanceof Player) {
            return;
        }
        try {
            float scale = FeruchemyAtium.getScale(event.getEntity());
            if ((double)scale > 1.01 || (double)scale < 0.99) {
                event.getPoseStack().m_85849_();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public static void onEntityJoinLevelEvent(EntityJoinLevelEvent event) {
        if (event.getEntity().m_9236_().f_46443_ && event.getEntity() instanceof Player) {
            FeruchemyChargeThread.getInstance().start();
        }
    }
}

