/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.feruchemy.client;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import leaf.cosmere.api.Activator;
import leaf.cosmere.api.EnumUtils;
import leaf.cosmere.api.Metals;
import leaf.cosmere.api.manifestation.Manifestation;
import leaf.cosmere.client.Keybindings;
import leaf.cosmere.feruchemy.common.manifestation.FeruchemyManifestation;
import leaf.cosmere.feruchemy.common.registries.FeruchemyManifestations;
import net.minecraft.client.KeyMapping;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="feruchemy", bus=Mod.EventBusSubscriber.Bus.MOD)
public class FeruchemyKeybindings {
    public static final Map<Metals.MetalType, KeyMapping> FERUCHEMY_POWER = Arrays.stream(EnumUtils.METAL_TYPES).filter(Metals.MetalType::hasAssociatedManifestation).collect(Collectors.toMap(Function.identity(), metalType -> new KeyMapping("key.cosmere.feruchemy." + metalType.m_6082_(), -1, "keys.cosmere.activators")));

    @SubscribeEvent
    public static void register(RegisterKeyMappingsEvent event) {
        for (Metals.MetalType metalType : FERUCHEMY_POWER.keySet()) {
            KeyMapping key = FERUCHEMY_POWER.get(metalType);
            FeruchemyManifestation manifest = (FeruchemyManifestation)FeruchemyManifestations.FERUCHEMY_POWERS.get(metalType).getManifestation();
            event.register(key);
            Activator entry = new Activator(key, (Manifestation)manifest);
            entry.setCategory("feruchemy");
            Keybindings.activators.add(entry);
        }
    }
}

