/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.feruchemy.client.render.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.awt.Color;
import javax.annotation.Nonnull;
import leaf.cosmere.api.IHasMetalType;
import leaf.cosmere.common.Cosmere;
import leaf.cosmere.feruchemy.common.registries.FeruchemyItems;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import top.theillusivec4.curios.api.SlotContext;

public class BraceletModel
extends HumanoidModel<LivingEntity> {
    private static final ResourceLocation TEXTURE = Cosmere.rl((String)"textures/block/metal_block.png");
    private static final String leftArmID = "left_arm";
    private static final String rightArmID = "right_arm";
    private static final String braceletID = "bracelet";
    private final ModelPart root;
    private final ModelPart rightShoulderSide;
    private final ModelPart rightArmUpper;
    private final ModelPart rightArmMiddle;
    private final ModelPart rightArmLower;
    private final ModelPart leftShoulderSide;
    private final ModelPart leftArmUpper;
    private final ModelPart leftArmMiddle;
    private final ModelPart leftArmLower;

    public BraceletModel(ModelPart part) {
        super(part, RenderType::m_110458_);
        this.root = part;
        ModelPart find = part.m_171324_(rightArmID);
        this.rightShoulderSide = find.m_171324_("shoulder_side");
        this.rightArmUpper = find.m_171324_("upper");
        this.rightArmMiddle = find.m_171324_("middle");
        this.rightArmLower = find.m_171324_("lower");
        find = part.m_171324_(leftArmID);
        this.leftShoulderSide = find.m_171324_("shoulder_side");
        this.leftArmUpper = find.m_171324_("upper");
        this.leftArmMiddle = find.m_171324_("middle");
        this.leftArmLower = find.m_171324_("lower");
    }

    public static LayerDefinition createLayer() {
        CubeDeformation cube = new CubeDeformation(0.4f);
        MeshDefinition mesh = HumanoidModel.m_170681_((CubeDeformation)cube, (float)0.0f);
        PartDefinition part = mesh.m_171576_();
        PartDefinition rightArm = part.m_171599_(rightArmID, CubeListBuilder.m_171558_(), PartPose.f_171404_);
        rightArm.m_171599_("shoulder_side", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.9f, 1.0f, -2.0f, 3.0f, 0.5f, 4.0f, cube), PartPose.f_171404_);
        rightArm.m_171599_("upper", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.9f, 3.0f, -2.0f, 3.0f, 0.5f, 4.0f, cube), PartPose.f_171404_);
        rightArm.m_171599_("middle", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.9f, 5.0f, -2.0f, 3.0f, 0.5f, 4.0f, cube), PartPose.f_171404_);
        rightArm.m_171599_("lower", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.9f, 7.0f, -2.0f, 3.0f, 0.5f, 4.0f, cube), PartPose.f_171404_);
        PartDefinition leftArm = part.m_171599_(leftArmID, CubeListBuilder.m_171558_().m_171480_(), PartPose.f_171404_);
        leftArm.m_171599_("shoulder_side", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-0.1f, 1.0f, -2.0f, 3.0f, 0.5f, 4.0f, cube), PartPose.f_171404_);
        leftArm.m_171599_("upper", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-0.1f, 3.0f, -2.0f, 3.0f, 0.5f, 4.0f, cube), PartPose.f_171404_);
        leftArm.m_171599_("middle", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-0.1f, 5.0f, -2.0f, 3.0f, 0.5f, 4.0f, cube), PartPose.f_171404_);
        leftArm.m_171599_("lower", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-0.1f, 7.0f, -2.0f, 3.0f, 0.5f, 4.0f, cube), PartPose.f_171404_);
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)16, (int)16);
    }

    @Nonnull
    protected Iterable<ModelPart> m_5607_() {
        return ImmutableList.of();
    }

    @Nonnull
    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.f_102811_, (Object)this.f_102812_);
    }

    public void render(ItemStack stack, SlotContext slotContext, PoseStack matrixStack, MultiBufferSource buffer, int light) {
        boolean leftHandSide = slotContext.index() % 2 == 0;
        ModelPart modelPartToRender = null;
        if (slotContext.identifier().equals(braceletID)) {
            switch (slotContext.index()) {
                case 0: {
                    ModelPart modelPart = this.leftShoulderSide;
                    break;
                }
                case 1: {
                    ModelPart modelPart = this.rightShoulderSide;
                    break;
                }
                case 2: {
                    ModelPart modelPart = this.leftArmUpper;
                    break;
                }
                case 3: {
                    ModelPart modelPart = this.rightArmUpper;
                    break;
                }
                case 4: {
                    ModelPart modelPart = this.leftArmMiddle;
                    break;
                }
                case 5: {
                    ModelPart modelPart = this.rightArmMiddle;
                    break;
                }
                case 6: {
                    ModelPart modelPart = this.leftArmLower;
                    break;
                }
                case 7: {
                    ModelPart modelPart = this.rightArmLower;
                    break;
                }
                default: {
                    ModelPart modelPart = modelPartToRender = null;
                }
            }
        }
        if (modelPartToRender == null) {
            return;
        }
        modelPartToRender.m_104315_(this.root.m_171324_(leftHandSide ? leftArmID : rightArmID));
        IHasMetalType item = (IHasMetalType)stack.m_41720_();
        Color color = item.getMetalType().getColor();
        VertexConsumer vertexBuilder = ItemRenderer.m_115211_((MultiBufferSource)buffer, (RenderType)this.m_103119_(TEXTURE), (boolean)false, (stack.m_41720_() == FeruchemyItems.BANDS_OF_MOURNING.get() ? 1 : 0) != 0);
        modelPartToRender.m_104306_(matrixStack, vertexBuilder, light, OverlayTexture.f_118083_, (float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 1.0f);
    }
}

