/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.feruchemy.common;

import leaf.cosmere.api.CosmereAPI;
import leaf.cosmere.api.IModModule;
import leaf.cosmere.api.ISpiritwebSubmodule;
import leaf.cosmere.api.Version;
import leaf.cosmere.common.Cosmere;
import leaf.cosmere.common.config.CosmereModConfig;
import leaf.cosmere.feruchemy.common.capabilities.FeruchemySpiritwebSubmodule;
import leaf.cosmere.feruchemy.common.config.FeruchemyConfigs;
import leaf.cosmere.feruchemy.common.registries.FeruchemyAttributes;
import leaf.cosmere.feruchemy.common.registries.FeruchemyCreativeTabs;
import leaf.cosmere.feruchemy.common.registries.FeruchemyEffects;
import leaf.cosmere.feruchemy.common.registries.FeruchemyItems;
import leaf.cosmere.feruchemy.common.registries.FeruchemyLootFunctions;
import leaf.cosmere.feruchemy.common.registries.FeruchemyManifestations;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="feruchemy")
public class Feruchemy
implements IModModule {
    public static final String MODID = "feruchemy";
    public static Feruchemy instance;
    public final Version versionNumber;

    public Feruchemy() {
        instance = this;
        Cosmere.addModule((IModModule)instance);
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        FeruchemyConfigs.registerConfigs(ModLoadingContext.get());
        modBus.addListener(this::commonSetup);
        modBus.addListener(this::onConfigLoad);
        modBus.addListener(this::onConfigReload);
        FeruchemyItems.ITEMS.register(modBus);
        FeruchemyAttributes.ATTRIBUTES.register(modBus);
        FeruchemyManifestations.MANIFESTATIONS.register(modBus);
        FeruchemyLootFunctions.LOOT_FUNCTIONS.register(modBus);
        FeruchemyEffects.EFFECTS.register(modBus);
        FeruchemyCreativeTabs.CREATIVE_TABS.register(modBus);
        this.versionNumber = new Version(ModLoadingContext.get().getActiveContainer());
    }

    public static ResourceLocation rl(String path) {
        return new ResourceLocation(MODID, path);
    }

    public void commonSetup(FMLCommonSetupEvent event) {
        CosmereAPI.logger.info("Cosmere: Feruchemy module Version {} initializing...", (Object)this.versionNumber);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public Version getVersion() {
        return this.versionNumber;
    }

    public String getName() {
        return "Feruchemy";
    }

    public ISpiritwebSubmodule makeSubmodule() {
        return new FeruchemySpiritwebSubmodule();
    }

    private void onConfigLoad(ModConfigEvent configEvent) {
        ModConfig config = configEvent.getConfig();
        if (config.getModId().equals(MODID) && config instanceof CosmereModConfig) {
            CosmereModConfig cosmereModConfig = (CosmereModConfig)config;
            cosmereModConfig.clearCache();
        }
    }

    private void onConfigReload(ModConfigEvent.Reloading configEvent) {
        ModConfig config = configEvent.getConfig();
        if (config.getModId().equals(MODID) && config instanceof CosmereModConfig) {
            CosmereModConfig cosmereModConfig = (CosmereModConfig)config;
            cosmereModConfig.clearCache();
        }
    }
}

