/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.feruchemy.common.capabilities;

import java.util.HashMap;
import java.util.List;
import leaf.cosmere.api.ISpiritwebSubmodule;
import leaf.cosmere.api.Metals;
import leaf.cosmere.api.helpers.PlayerHelper;
import leaf.cosmere.api.manifestation.Manifestation;
import leaf.cosmere.api.math.MathHelper;
import leaf.cosmere.api.spiritweb.ISpiritweb;
import leaf.cosmere.feruchemy.client.utils.FeruchemyChargeThread;
import leaf.cosmere.feruchemy.common.config.FeruchemyConfigs;
import leaf.cosmere.feruchemy.common.items.RingMetalmindItem;
import leaf.cosmere.feruchemy.common.manifestation.FeruchemyManifestation;
import leaf.cosmere.feruchemy.common.registries.FeruchemyItems;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class FeruchemySpiritwebSubmodule
implements ISpiritwebSubmodule {
    private static final HashMap<Metals.MetalType, Double> metalmindChargesMap = new HashMap();

    public void GiveStartingItem(Player player) {
        int startingMetalmindCount = (Integer)FeruchemyConfigs.SERVER.FULL_FERUCHEMIST_STARTING_METALMIND_COUNT.get();
        double maxAmount = (Double)FeruchemyConfigs.SERVER.STARTING_METALMIND_RANDOMISED_MAX_FILL_AMOUNT.get();
        for (int i = 0; i < startingMetalmindCount; ++i) {
            float fillAmount = (float)(maxAmount * Math.random());
            int id = MathHelper.randomInt((int)0, (int)15);
            Metals.MetalType.valueOf((int)id).ifPresent(metalType -> FeruchemySpiritwebSubmodule.GiveStartingItem(player, metalType, fillAmount));
        }
    }

    public void GiveStartingItem(Player player, Manifestation manifestation) {
        if (manifestation instanceof FeruchemyManifestation) {
            FeruchemyManifestation feruchemyManifestation = (FeruchemyManifestation)manifestation;
            double maxAmount = (Double)FeruchemyConfigs.SERVER.STARTING_METALMIND_RANDOMISED_MAX_FILL_AMOUNT.get();
            float fillAmount = (float)(maxAmount * Math.random());
            FeruchemySpiritwebSubmodule.GiveStartingItem(player, feruchemyManifestation.getMetalType(), fillAmount);
        }
    }

    public void drainInvestiture(ISpiritweb data, double strength) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void collectMenuInfo(List<String> m_infoText) {
        if (Minecraft.m_91087_().f_91074_ != null && Minecraft.m_91087_().f_91074_.f_19797_ % 2 == 1) {
            metalmindChargesMap.clear();
            metalmindChargesMap.putAll(FeruchemyChargeThread.getInstance().getCharges());
        }
        if (!metalmindChargesMap.isEmpty()) {
            for (Metals.MetalType metalType : metalmindChargesMap.keySet()) {
                String text = "F. " + metalType.m_6082_() + ": " + metalmindChargesMap.getOrDefault(metalType, 0.0).intValue();
                m_infoText.add(text);
            }
        }
        super.collectMenuInfo(m_infoText);
    }

    private static void GiveStartingItem(Player player, Metals.MetalType metalType, float fillAmount) {
        RingMetalmindItem metalmindItem = (RingMetalmindItem)((Object)FeruchemyItems.METAL_RINGS.get(metalType).get());
        ItemStack itemStack = new ItemStack((ItemLike)metalmindItem);
        metalmindItem.setCharge(itemStack, (int)((float)metalmindItem.getMaxCharge(itemStack) * fillAmount));
        PlayerHelper.addItem((Player)player, (ItemStack)itemStack);
    }
}

