/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.feruchemy.common.compat.jei;

import leaf.cosmere.api.Constants;
import leaf.cosmere.api.EnumUtils;
import leaf.cosmere.api.Metals;
import leaf.cosmere.api.text.TextHelper;
import leaf.cosmere.feruchemy.common.registries.FeruchemyItems;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;

@JeiPlugin
public class FeruchemyJEICompat
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return Constants.Resources.JEI_FERUCHEMY;
    }

    public void registerRecipes(IRecipeRegistration reg) {
        for (Metals.MetalType metalType : EnumUtils.METAL_TYPES) {
            if (!metalType.hasFeruchemicalEffect()) continue;
            this.addItemInfoPage(reg, FeruchemyItems.METAL_NECKLACES.get(metalType).m_5456_());
            this.addItemInfoPage(reg, FeruchemyItems.METAL_RINGS.get(metalType).m_5456_());
            this.addItemInfoPage(reg, FeruchemyItems.METAL_BRACELETS.get(metalType).m_5456_());
        }
    }

    private void addItemInfoPage(IRecipeRegistration reg, Item item) {
        reg.addIngredientInfo((Object)item.m_7968_(), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{TextHelper.createTranslatedText((String)String.format("item.%s.%s.tooltip", this.getPluginUid().m_135827_(), item), (Object[])new Object[0])});
    }
}

