/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.feruchemy.common.manifestation;

import java.util.List;
import java.util.Optional;
import leaf.cosmere.api.Metals;
import leaf.cosmere.api.manifestation.Manifestation;
import leaf.cosmere.api.spiritweb.ISpiritweb;
import leaf.cosmere.common.cap.entity.SpiritwebCapability;
import leaf.cosmere.feruchemy.common.manifestation.FeruchemyManifestation;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.SleepingLocationCheckEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;

public class FeruchemyBronze
extends FeruchemyManifestation {
    public FeruchemyBronze(Metals.MetalType metalType) {
        super(metalType);
        MinecraftForge.EVENT_BUS.addListener(this::sleepCheck);
    }

    @Override
    public int modeMin(ISpiritweb data) {
        return -1;
    }

    @Override
    public int modeMax(ISpiritweb data) {
        return 1;
    }

    @Override
    public void applyEffectTick(ISpiritweb data) {
        super.applyEffectTick(data);
        switch (this.getMode(data)) {
            case -1: {
                this.resetSleepTimers(data);
                break;
            }
            case 1: {
                this.trySleep(data);
                break;
            }
        }
    }

    private void resetSleepTimers(ISpiritweb data) {
        ServerPlayer player = (ServerPlayer)data.getLiving();
        player.m_7166_(Stats.f_12988_.m_12902_((Object)Stats.f_12992_));
    }

    private void trySleep(ISpiritweb data) {
        ServerPlayer player = (ServerPlayer)data.getLiving();
        if (player.m_5803_()) {
            return;
        }
        boolean canSleep = this.canSleep((Player)player);
        if (!canSleep) {
            data.setMode((Manifestation)this, 0);
            return;
        }
        player.m_7166_(Stats.f_12988_.m_12902_((Object)Stats.f_12992_));
        if (player.m_20159_()) {
            player.m_8127_();
        }
        try {
            player.m_20124_(Pose.SLEEPING);
        }
        catch (Exception exception) {
            // empty catch block
        }
        player.m_21250_(player.m_20183_());
        player.m_20256_(Vec3.f_82478_);
        player.f_19812_ = true;
        try {
            ObfuscationReflectionHelper.setPrivateValue(Player.class, (Object)player, (Object)0, (String)"f_36110_");
        }
        catch (ObfuscationReflectionHelper.UnableToFindFieldException e) {
            try {
                ObfuscationReflectionHelper.setPrivateValue(Player.class, (Object)player, (Object)0, (String)"sleepCounter");
            }
            catch (ObfuscationReflectionHelper.UnableToFindFieldException unableToFindFieldException) {
                // empty catch block
            }
        }
        Level level = player.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8878_();
        }
        player.m_36220_(Stats.f_12969_);
        CriteriaTriggers.f_10583_.m_222618_(player);
    }

    private boolean canSleep(Player player) {
        Player.BedSleepingProblem ret = ForgeEventFactory.onPlayerSleepInBed((Player)player, Optional.empty());
        if (ret != null) {
            return false;
        }
        if (player.m_5803_() || !player.m_6084_()) {
            return false;
        }
        if (!player.m_9236_().m_6042_().f_63858_()) {
            return false;
        }
        if (player.m_9236_().m_46461_()) {
            return false;
        }
        if (!ForgeEventFactory.fireSleepingTimeCheck((Player)player, Optional.empty())) {
            return false;
        }
        if (!player.m_7500_()) {
            Vec3 vector3d = player.m_20182_();
            List list = player.m_9236_().m_6443_(Monster.class, new AABB(vector3d.m_7096_() - 8.0, vector3d.m_7098_() - 5.0, vector3d.m_7094_() - 8.0, vector3d.m_7096_() + 8.0, vector3d.m_7098_() + 5.0, vector3d.m_7094_() + 8.0), entity -> entity.m_6935_(player));
            return list.isEmpty();
        }
        return true;
    }

    public void sleepCheck(SleepingLocationCheckEvent event) {
        if (event.getEntity() instanceof Player) {
            SpiritwebCapability.get((LivingEntity)event.getEntity()).ifPresent(iSpiritweb -> {
                if (this.isActive((ISpiritweb)iSpiritweb)) {
                    event.setResult(Event.Result.ALLOW);
                }
            });
        }
    }
}

