/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.feruchemy.common.registries;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import leaf.cosmere.api.EnumUtils;
import leaf.cosmere.api.Metals;
import leaf.cosmere.api.cosmereEffect.CosmereEffect;
import leaf.cosmere.common.registration.impl.CosmereEffectDeferredRegister;
import leaf.cosmere.common.registration.impl.CosmereEffectRegistryObject;
import leaf.cosmere.feruchemy.common.effects.FeruchemyEffectBase;
import leaf.cosmere.feruchemy.common.effects.store.AluminumStoreEffect;
import leaf.cosmere.feruchemy.common.effects.store.AtiumStoreEffect;
import leaf.cosmere.feruchemy.common.effects.store.BendalloyStoreEffect;
import leaf.cosmere.feruchemy.common.effects.store.BrassStoreEffect;
import leaf.cosmere.feruchemy.common.effects.store.CadmiumStoreEffect;
import leaf.cosmere.feruchemy.common.effects.store.ChromiumStoreEffect;
import leaf.cosmere.feruchemy.common.effects.store.DuraluminStoreEffect;
import leaf.cosmere.feruchemy.common.effects.store.ElectrumStoreEffect;
import leaf.cosmere.feruchemy.common.effects.store.GoldStoreEffect;
import leaf.cosmere.feruchemy.common.effects.store.IronStoreEffect;
import leaf.cosmere.feruchemy.common.effects.store.PewterStoreEffect;
import leaf.cosmere.feruchemy.common.effects.store.SteelStoreEffect;
import leaf.cosmere.feruchemy.common.effects.store.ZincStoreEffect;
import leaf.cosmere.feruchemy.common.effects.tap.AluminumTapEffect;
import leaf.cosmere.feruchemy.common.effects.tap.AtiumTapEffect;
import leaf.cosmere.feruchemy.common.effects.tap.BendalloyTapEffect;
import leaf.cosmere.feruchemy.common.effects.tap.BrassTapEffect;
import leaf.cosmere.feruchemy.common.effects.tap.CadmiumTapEffect;
import leaf.cosmere.feruchemy.common.effects.tap.ChromiumTapEffect;
import leaf.cosmere.feruchemy.common.effects.tap.DuraluminTapEffect;
import leaf.cosmere.feruchemy.common.effects.tap.ElectrumTapEffect;
import leaf.cosmere.feruchemy.common.effects.tap.GoldTapEffect;
import leaf.cosmere.feruchemy.common.effects.tap.IronTapEffect;
import leaf.cosmere.feruchemy.common.effects.tap.PewterTapEffect;
import leaf.cosmere.feruchemy.common.effects.tap.SteelTapEffect;
import leaf.cosmere.feruchemy.common.effects.tap.ZincTapEffect;

public class FeruchemyEffects {
    public static final CosmereEffectDeferredRegister EFFECTS = new CosmereEffectDeferredRegister("feruchemy");
    public static final Map<Metals.MetalType, CosmereEffectRegistryObject<CosmereEffect>> TAPPING_EFFECTS = Arrays.stream(EnumUtils.METAL_TYPES).filter(Metals.MetalType::hasFeruchemicalEffect).collect(Collectors.toMap(Function.identity(), type -> EFFECTS.register("tapping_" + type.m_6082_(), () -> FeruchemyEffects.makeTappingEffect(type))));
    public static final Map<Metals.MetalType, CosmereEffectRegistryObject<CosmereEffect>> STORING_EFFECTS = Arrays.stream(EnumUtils.METAL_TYPES).filter(Metals.MetalType::hasFeruchemicalEffect).collect(Collectors.toMap(Function.identity(), type -> EFFECTS.register("storing_" + type.m_6082_(), () -> FeruchemyEffects.makeStoringEffect(type))));

    private static CosmereEffect makeStoringEffect(Metals.MetalType metalType) {
        switch (metalType) {
            case IRON: {
                return new IronStoreEffect(metalType);
            }
            case STEEL: {
                return new SteelStoreEffect(metalType);
            }
            case PEWTER: {
                return new PewterStoreEffect(metalType);
            }
            case ZINC: {
                return new ZincStoreEffect(metalType);
            }
            case BRASS: {
                return new BrassStoreEffect(metalType);
            }
            case ALUMINUM: {
                return new AluminumStoreEffect(metalType);
            }
            case DURALUMIN: {
                return new DuraluminStoreEffect(metalType);
            }
            case CHROMIUM: {
                return new ChromiumStoreEffect(metalType);
            }
            case GOLD: {
                return new GoldStoreEffect(metalType);
            }
            case ELECTRUM: {
                return new ElectrumStoreEffect(metalType);
            }
            case CADMIUM: {
                return new CadmiumStoreEffect(metalType);
            }
            case BENDALLOY: {
                return new BendalloyStoreEffect(metalType);
            }
            case ATIUM: {
                return new AtiumStoreEffect(metalType);
            }
        }
        return new FeruchemyEffectBase(metalType);
    }

    private static CosmereEffect makeTappingEffect(Metals.MetalType metalType) {
        switch (metalType) {
            case IRON: {
                return new IronTapEffect(metalType);
            }
            case STEEL: {
                return new SteelTapEffect(metalType);
            }
            case PEWTER: {
                return new PewterTapEffect(metalType);
            }
            case ZINC: {
                return new ZincTapEffect(metalType);
            }
            case BRASS: {
                return new BrassTapEffect(metalType);
            }
            case ALUMINUM: {
                return new AluminumTapEffect(metalType);
            }
            case DURALUMIN: {
                return new DuraluminTapEffect(metalType);
            }
            case CHROMIUM: {
                return new ChromiumTapEffect(metalType);
            }
            case GOLD: {
                return new GoldTapEffect(metalType);
            }
            case ELECTRUM: {
                return new ElectrumTapEffect(metalType);
            }
            case CADMIUM: {
                return new CadmiumTapEffect(metalType);
            }
            case BENDALLOY: {
                return new BendalloyTapEffect(metalType);
            }
            case ATIUM: {
                return new AtiumTapEffect(metalType);
            }
        }
        return new FeruchemyEffectBase(metalType);
    }
}

