/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.feruchemy.common.effects.store;

import leaf.cosmere.api.Metals;
import leaf.cosmere.api.helpers.EntityHelper;
import leaf.cosmere.common.registry.AttributesRegistry;
import leaf.cosmere.feruchemy.common.effects.FeruchemyEffectBase;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class BrassStoreEffect
extends FeruchemyEffectBase {
    public BrassStoreEffect(Metals.MetalType type) {
        super(type);
        this.addAttributeModifier((Attribute)AttributesRegistry.WARMTH.get(), -1.0, AttributeModifier.Operation.ADDITION);
    }

    public static void onLivingHurtEvent(LivingHurtEvent event) {
        if (!event.getSource().m_276093_(DamageTypes.f_268468_) || event.isCanceled()) {
            return;
        }
        int total = (int)EntityHelper.getAttributeValue((LivingEntity)event.getEntity(), (Attribute)AttributesRegistry.WARMTH.getAttribute());
        if (total < 0) {
            float amount;
            int warmth = Math.abs(total);
            switch (warmth) {
                case 1: {
                    amount = event.getAmount() / 2.0f;
                    break;
                }
                case 2: {
                    amount = event.getAmount() / 4.0f;
                    break;
                }
                default: {
                    event.setCanceled(true);
                    return;
                }
            }
            event.setAmount(amount);
        }
    }

    public static void onLivingAttackEvent(LivingAttackEvent event) {
        if (!event.getSource().m_276093_(DamageTypes.f_268468_) || event.isCanceled()) {
            return;
        }
        int total = (int)EntityHelper.getAttributeValue((LivingEntity)event.getEntity(), (Attribute)AttributesRegistry.WARMTH.getAttribute());
        if (total < 0) {
            int warmth = Math.abs(total);
            switch (warmth) {
                case 0: 
                case 1: 
                case 2: {
                    break;
                }
                default: {
                    if (event.getEntity().m_6060_()) {
                        event.getEntity().m_20095_();
                    }
                    event.setCanceled(true);
                }
            }
        }
    }
}

