/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.feruchemy.common.eventHandlers;

import leaf.cosmere.api.Metals;
import leaf.cosmere.api.helpers.EntityHelper;
import leaf.cosmere.common.items.MetalNuggetItem;
import leaf.cosmere.common.registry.AttributesRegistry;
import leaf.cosmere.feruchemy.common.effects.store.BrassStoreEffect;
import leaf.cosmere.feruchemy.common.effects.tap.GoldTapEffect;
import leaf.cosmere.feruchemy.common.manifestation.FeruchemyAtium;
import leaf.cosmere.feruchemy.common.utils.MiscHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="feruchemy", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class FeruchemyEntityEventHandler {
    @SubscribeEvent
    public static void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        Item item;
        LivingEntity target;
        block8: {
            block7: {
                Entity entity = event.getTarget();
                if (!(entity instanceof LivingEntity)) break block7;
                target = (LivingEntity)entity;
                if (!event.getEntity().m_9236_().f_46443_) break block8;
            }
            return;
        }
        ItemStack stack = event.getEntity().m_21205_();
        if (!stack.m_41619_() && (item = stack.m_41720_()) instanceof MetalNuggetItem) {
            MetalNuggetItem beadItem = (MetalNuggetItem)item;
            Metals.MetalType metalType = beadItem.getMetalType();
            switch (metalType) {
                case LERASATIUM: {
                    MiscHelper.consumeNugget(target, metalType);
                    stack.m_41774_(1);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onFinishUsingItem(LivingEntityUseItemEvent.Finish event) {
        MetalNuggetItem item;
        if (event.isCanceled()) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        Item item2 = event.getItem().m_41720_();
        if (item2 instanceof MetalNuggetItem && (item = (MetalNuggetItem)item2).getMetalType() == Metals.MetalType.LERASATIUM) {
            MiscHelper.consumeNugget(livingEntity, Metals.MetalType.LERASATIUM);
        }
    }

    @SubscribeEvent
    public static void changeSize(EntityEvent.Size event) {
        LivingEntity livingEntity;
        float scale;
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity && (scale = FeruchemyAtium.getScale(livingEntity = (LivingEntity)entity)) != 1.0f) {
            event.setNewSize(event.getNewSize().m_20388_(scale));
            event.setNewEyeHeight(event.getNewEyeHeight() * scale);
        }
    }

    @SubscribeEvent
    public static void onLivingAttackEvent(LivingAttackEvent event) {
        BrassStoreEffect.onLivingAttackEvent(event);
    }

    @SubscribeEvent
    public static void onLivingHurtEvent(LivingHurtEvent event) {
        BrassStoreEffect.onLivingHurtEvent(event);
        GoldTapEffect.onLivingHurtEvent(event);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onBreakBlock(BlockEvent.BreakEvent evt) {
        Player player = evt.getPlayer();
        int totalFortuneBonus = (int)EntityHelper.getAttributeValue((LivingEntity)player, (Attribute)AttributesRegistry.COSMERE_FORTUNE.getAttribute());
        if (totalFortuneBonus == 0) {
            return;
        }
        ItemStack stack = player.m_21205_();
        int bonusLevel = stack.getEnchantmentLevel(Enchantments.f_44987_);
        int silklevel = stack.getEnchantmentLevel(Enchantments.f_44985_);
        LevelAccessor level = evt.getLevel();
        evt.setExpToDrop(evt.getState().getExpDrop((LevelReader)level, level.m_213780_(), evt.getPos(), bonusLevel + totalFortuneBonus, silklevel));
    }
}

