/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.feruchemy.common.manifestation;

import leaf.cosmere.api.Metals;
import leaf.cosmere.api.math.XPHelper;
import leaf.cosmere.api.spiritweb.ISpiritweb;
import leaf.cosmere.common.charge.MetalmindChargeHelper;
import leaf.cosmere.feruchemy.common.manifestation.FeruchemyManifestation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class FeruchemyCopper
extends FeruchemyManifestation {
    public FeruchemyCopper(Metals.MetalType metalType) {
        super(metalType);
    }

    @Override
    public int modeMin(ISpiritweb data) {
        return -1;
    }

    @Override
    public int modeMax(ISpiritweb data) {
        return 1;
    }

    @Override
    public boolean tick(ISpiritweb data) {
        Player playerEntity;
        block5: {
            block4: {
                LivingEntity livingEntity = data.getLiving();
                if (!(livingEntity instanceof Player)) break block4;
                playerEntity = (Player)livingEntity;
                if (this.isActiveTick(data)) break block5;
            }
            return false;
        }
        int mode = this.getMode(data);
        if (mode == 0) {
            return false;
        }
        this.performXPAdjustment(data, playerEntity);
        return false;
    }

    private void performXPAdjustment(ISpiritweb data, Player playerEntity) {
        int adjustValue;
        ItemStack itemStack;
        float experiencePoints;
        boolean storing = this.isStoring(data);
        boolean tapping = this.isTapping(data);
        if (storing) {
            experiencePoints = playerEntity.f_36080_ * (float)playerEntity.m_36323_();
            if (experiencePoints < 1.0f) {
                experiencePoints = XPHelper.getXpNeededForNextLevel((int)(playerEntity.f_36078_ - 1));
            }
        } else if (tapping) {
            experiencePoints = XPHelper.getXpNeededForNextLevel((int)playerEntity.f_36078_);
        } else {
            return;
        }
        int xp = Mth.m_14143_((float)experiencePoints);
        if ((storing && xp <= playerEntity.f_36079_ || tapping) && !(itemStack = MetalmindChargeHelper.adjustMetalmindChargeExact((Player)playerEntity, (Metals.MetalType)this.metalType, (int)(adjustValue = storing ? xp : -xp), (boolean)true, (boolean)true)).m_41619_()) {
            XPHelper.giveExperiencePoints((Player)playerEntity, (int)(storing ? -xp : xp));
        }
    }
}

