/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.feruchemy.common.manifestation;

import leaf.cosmere.api.IHasMetalType;
import leaf.cosmere.api.Manifestations;
import leaf.cosmere.api.Metals;
import leaf.cosmere.api.cosmereEffect.CosmereEffect;
import leaf.cosmere.api.cosmereEffect.CosmereEffectInstance;
import leaf.cosmere.api.helpers.EffectsHelper;
import leaf.cosmere.api.manifestation.Manifestation;
import leaf.cosmere.api.spiritweb.ISpiritweb;
import leaf.cosmere.common.charge.MetalmindChargeHelper;
import leaf.cosmere.feruchemy.common.registries.FeruchemyEffects;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class FeruchemyManifestation
extends Manifestation
implements IHasMetalType {
    protected final Metals.MetalType metalType;

    public FeruchemyManifestation(Metals.MetalType metalType) {
        super(Manifestations.ManifestationTypes.FERUCHEMY);
        this.metalType = metalType;
    }

    public int getPowerID() {
        return this.metalType.getID();
    }

    public Metals.MetalType getMetalType() {
        return this.metalType;
    }

    public boolean modeWraps(ISpiritweb data) {
        return false;
    }

    public int modeMax(ISpiritweb data) {
        double strength = this.getStrength(data, false);
        return Mth.m_14107_((double)(strength / 3.0));
    }

    public int modeMin(ISpiritweb data) {
        double strength = this.getStrength(data, false);
        return -Mth.m_14107_((double)strength);
    }

    public void onModeChange(ISpiritweb data, int lastMode) {
        super.onModeChange(data, lastMode);
        if (this.getMode(data) == 0) {
            LivingEntity effectSource = data.getLiving();
            data.removeEffect(EffectsHelper.getEffectUUID((CosmereEffect)this.getStoringEffect(), (Entity)effectSource));
            data.removeEffect(EffectsHelper.getEffectUUID((CosmereEffect)this.getTappingEffect(), (Entity)effectSource));
        }
    }

    protected CosmereEffect getTappingEffect() {
        return (CosmereEffect)FeruchemyEffects.TAPPING_EFFECTS.get(this.metalType).get();
    }

    protected CosmereEffect getStoringEffect() {
        return (CosmereEffect)FeruchemyEffects.STORING_EFFECTS.get(this.metalType).get();
    }

    public boolean isStoring(ISpiritweb data) {
        return this.getMode(data) > 0;
    }

    public boolean isTapping(ISpiritweb data) {
        return this.getMode(data) < 0;
    }

    public boolean canAfford(ISpiritweb data, boolean simulate) {
        int mode;
        int adjustAmount = this.getCost(data);
        ItemStack metalmind = MetalmindChargeHelper.adjustMetalmindChargeExact((ISpiritweb)data, (Metals.MetalType)this.metalType, (int)adjustAmount, (!simulate ? 1 : 0) != 0, (boolean)true);
        if (!metalmind.m_41619_()) {
            return true;
        }
        if (!simulate && (mode = this.getMode(data)) < 0) {
            data.setMode((Manifestation)this, mode + 1);
        }
        return false;
    }

    public int getCost(ISpiritweb data) {
        int mode = data.getMode((Manifestation)this);
        if (mode < 0) {
            return mode >= -this.modeMax(data) ? mode : -Mth.m_14040_((int)Mth.m_14107_((double)Math.pow(Mth.m_14040_((int)mode), 1.5)));
        }
        if (mode > 0) {
            return mode;
        }
        return 0;
    }

    public boolean tick(ISpiritweb data) {
        LivingEntity livingEntity = data.getLiving();
        int mode = this.getMode(data);
        if (!this.isActiveTick(data) || mode == 0) {
            return false;
        }
        if (this.canAfford(data, false)) {
            this.applyEffectTick(data);
            return this.isTapping(data) && mode < -4;
        }
        return false;
    }

    public void applyEffectTick(ISpiritweb data) {
        int mode = this.getMode(data);
        CosmereEffect effect = this.getEffect(mode);
        CosmereEffectInstance currentEffect = EffectsHelper.getNewEffect((CosmereEffect)effect, (Entity)data.getLiving(), (double)Math.abs(mode));
        data.addEffect(currentEffect);
    }

    protected CosmereEffect getEffect(int mode) {
        if (mode == 0) {
            return null;
        }
        if (mode < 0) {
            return this.getTappingEffect();
        }
        return this.getStoringEffect();
    }
}

