/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.googlemod.world.inventory;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.mcreator.googlemod.init.GooglemodModMenus;
import net.mcreator.googlemod.network.GoogleCraftingSlotMessage;
import net.mcreator.googlemod.procedures.GoogleCraftingWhileThisGUIIsOpenTickProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber
public class GoogleCraftingMenu
extends AbstractContainerMenu
implements GooglemodModMenus.MenuAccessor {
    public final Map<String, Object> menuState = new HashMap<String, Object>(){

        @Override
        public Object put(String key, Object value) {
            if (!this.containsKey(key) && this.size() >= 85) {
                return null;
            }
            return super.put(key, value);
        }
    };
    public final Level world;
    public final Player entity;
    public int x;
    public int y;
    public int z;
    private ContainerLevelAccess access = ContainerLevelAccess.NULL;
    private IItemHandler internal;
    private final Map<Integer, Slot> customSlots = new HashMap<Integer, Slot>();
    private boolean bound = false;
    private Supplier<Boolean> boundItemMatcher = null;
    private Entity boundEntity = null;
    private BlockEntity boundBlockEntity = null;

    public GoogleCraftingMenu(int id, Inventory inv, FriendlyByteBuf extraData) {
        super((MenuType)GooglemodModMenus.GOOGLE_CRAFTING.get(), id);
        int si;
        this.entity = inv.player;
        this.world = inv.player.level();
        this.internal = new ItemStackHandler(82);
        BlockPos pos = null;
        if (extraData != null) {
            pos = extraData.readBlockPos();
            this.x = pos.getX();
            this.y = pos.getY();
            this.z = pos.getZ();
            this.access = ContainerLevelAccess.create((Level)this.world, (BlockPos)pos);
        }
        if (pos != null) {
            if (extraData.readableBytes() == 1) {
                byte hand = extraData.readByte();
                itemstack = hand == 0 ? this.entity.getMainHandItem() : this.entity.getOffhandItem();
                this.boundItemMatcher = () -> itemstack == (hand == 0 ? this.entity.getMainHandItem() : this.entity.getOffhandItem());
                IItemHandler cap = (IItemHandler)itemstack.getCapability(Capabilities.ItemHandler.ITEM);
                if (cap != null) {
                    this.internal = cap;
                    this.bound = true;
                }
            } else if (extraData.readableBytes() > 1) {
                IItemHandler cap;
                extraData.readByte();
                this.boundEntity = this.world.getEntity(extraData.readVarInt());
                if (this.boundEntity != null && (cap = (IItemHandler)this.boundEntity.getCapability(Capabilities.ItemHandler.ENTITY)) != null) {
                    this.internal = cap;
                    this.bound = true;
                }
            } else {
                this.boundBlockEntity = this.world.getBlockEntity(pos);
                itemstack = this.boundBlockEntity;
                if (itemstack instanceof BaseContainerBlockEntity) {
                    BaseContainerBlockEntity baseContainerBlockEntity = (BaseContainerBlockEntity)itemstack;
                    this.internal = new InvWrapper((Container)baseContainerBlockEntity);
                    this.bound = true;
                }
            }
        }
        this.customSlots.put(0, this.addSlot((Slot)new SlotItemHandler(this.internal, 0, 6, 12){
            private final int slot = 0;
            private int x;
            private int y;
            {
                this.slot = 0;
                this.x = GoogleCraftingMenu.this.x;
                this.y = GoogleCraftingMenu.this.y;
            }
        }));
        this.customSlots.put(1, this.addSlot((Slot)new SlotItemHandler(this.internal, 1, 24, 12){
            private final int slot = 1;
            private int x;
            private int y;
            {
                this.slot = 1;
                this.x = GoogleCraftingMenu.this.x;
                this.y = GoogleCraftingMenu.this.y;
            }
        }));
        this.customSlots.put(2, this.addSlot((Slot)new SlotItemHandler(this.internal, 2, 42, 12){
            private final int slot = 2;
            private int x;
            private int y;
            {
                this.slot = 2;
                this.x = GoogleCraftingMenu.this.x;
                this.y = GoogleCraftingMenu.this.y;
            }
        }));
        this.customSlots.put(3, this.addSlot((Slot)new SlotItemHandler(this.internal, 3, 60, 12){
            private final int slot = 3;
            private int x;
            private int y;
            {
                this.slot = 3;
                this.x = GoogleCraftingMenu.this.x;
                this.y = GoogleCraftingMenu.this.y;
            }
        }));
        this.customSlots.put(4, this.addSlot((Slot)new SlotItemHandler(this.internal, 4, 78, 12){
            private final int slot = 4;
            private int x;
            private int y;
            {
                this.slot = 4;
                this.x = GoogleCraftingMenu.this.x;
                this.y = GoogleCraftingMenu.this.y;
            }
        }));
        this.customSlots.put(5, this.addSlot((Slot)new SlotItemHandler(this.internal, 5, 96, 12){
            private final int slot = 5;
            private int x;
            private int y;
            {
                this.slot = 5;
                this.x = GoogleCraftingMenu.this.x;
                this.y = GoogleCraftingMenu.this.y;
            }
        }));
        this.customSlots.put(6, this.addSlot((Slot)new SlotItemHandler(this.internal, 6, 114, 12){
            private final int slot = 6;
            private int x;
            private int y;
            {
                this.slot = 6;
                this.x = GoogleCraftingMenu.this.x;
                this.y = GoogleCraftingMenu.this.y;
            }
        }));
        this.customSlots.put(7, this.addSlot((Slot)new SlotItemHandler(this.internal, 7, 132, 12){
            private final int slot = 7;
            private int x;
            private int y;
            {
                this.slot = 7;
                this.x = GoogleCraftingMenu.this.x;
                this.y = GoogleCraftingMenu.this.y;
            }
        }));
        this.customSlots.put(8, this.addSlot((Slot)new SlotItemHandler(this.internal, 8, 150, 12){
            private final int slot = 8;
            private int x;
            private int y;
            {
                this.slot = 8;
                this.x = GoogleCraftingMenu.this.x;
                this.y = GoogleCraftingMenu.this.y;
            }
        }));
        this.customSlots.put(9, this.addSlot((Slot)new SlotItemHandler(this.internal, 9, 6, 30){
            private final int slot = 9;
            private int x;
            private int y;
            {
                this.slot = 9;
                this.x = GoogleCraftingMenu.this.x;
                this.y = GoogleCraftingMenu.this.y;
            }
        }));
        this.customSlots.put(10, this.addSlot((Slot)new SlotItemHandler(this.internal, 10, 24, 30){
            private final int slot = 10;
            private int x;
            private int y;
            {
                this.slot = 10;
                this.x = GoogleCraftingMenu.this.x;
                this.y = GoogleCraftingMenu.this.y;
            }
        }));
        this.customSlots.put(11, this.addSlot((Slot)new SlotItemHandler(this.internal, 11, 42, 30){
            private final int slot = 11;
            private int x;
            private int y;
            {
                this.slot = 11;
                this.x = GoogleCraftingMenu.this.x;
                this.y = GoogleCraftingMenu.this.y;
            }
        }));
        this.customSlots.put(12, this.addSlot((Slot)new SlotItemHandler(this.internal, 12, 60, 30){
            private final int slot = 12;
            private int x;
            private int y;
            {
                this.slot = 12;
                this.x = GoogleCraftingMenu.this.x;
                this.y = GoogleCraftingMenu.this.y;
            }
        }));
        this.customSlots.put(13, this.addSlot((Slot)new SlotItemHandler(this.internal, 13, 78, 30){
            private final int slot = 13;
            private int x;
            private int y;
            {
                this.slot = 13;
                this.x = GoogleCraftingMenu.this.x;
                this.y = GoogleCraftingMenu.this.y;
            }
        }));
        this.customSlots.put(14, this.addSlot((Slot)new SlotItemHandler(this.internal, 14, 96, 30){
            private final int slot = 14;
            private int x;
            private int y;
            {
                this.slot = 14;
                this.x = GoogleCraftingMenu.this.x;
                this.y = GoogleCraftingMenu.this.y;
            }
        }));
        this.customSlots.put(15, this.addSlot((Slot)new SlotItemHandler(this.internal, 15, 114, 30){
            private final int slot = 15;
            private int x;
            private int y;
            {
                this.slot = 15;
                this.x = GoogleCraftingMenu.this.x;
                this.y = GoogleCraftingMenu.this.y;
            }
        }));
        this.customSlots.put(16, this.addSlot((Slot)new SlotItemHandler(this.internal, 16, 132, 30){
            private final int slot = 16;
            private int x;
            private int y;
            {
                this.slot = 16;
                this.x = GoogleCraftingMenu.this.x;
                this.y = GoogleCraftingMenu.this.y;
            }
        }));
        this.customSlots.put(17, this.addSlot((Slot)new SlotItemHandler(this.internal, 17, 150, 30){
            private final int slot = 17;
            private int x;
            private int y;
            {
                this.slot = 17;
                this.x = GoogleCraftingMenu.this.x;
                this.y = GoogleCraftingMenu.this.y;
            }
        }));
        this.customSlots.put(18, this.addSlot((Slot)new SlotItemHandler(this.internal, 18, 6, 48){
            private final int slot = 18;
            private int x;
            private int y;
            {
                this.slot = 18;
                this.x = GoogleCraftingMenu.this.x;
                this.y = GoogleCraftingMenu.this.y;
            }
        }));
        this.customSlots.put(19, this.addSlot((Slot)new SlotItemHandler(this.internal, 19, 24, 48){
            private final int slot = 19;
            private int x;
            private int y;
            {
                this.slot = 19;
                this.x = GoogleCraftingMenu.this.x;
                this.y = GoogleCraftingMenu.this.y;
            }
        }));
        this.customSlots.put(20, this.addSlot((Slot)new SlotItemHandler(this.internal, 20, 42, 48){
            private final int slot = 20;
            private int x;
            private int y;
            {
                this.slot = 20;
                this.x = GoogleCraftingMenu.this.x;
                this.y = GoogleCraftingMenu.this.y;
            }
        }));
        this.customSlots.put(21, this.addSlot((Slot)new SlotItemHandler(this.internal, 21, 60, 48){
            private final int slot = 21;
            private int x;
            private int y;
            {
                this.slot = 21;
                this.x = GoogleCraftingMenu.this.x;
                this.y = GoogleCraftingMenu.this.y;
            }
        }));
        this.customSlots.put(22, this.addSlot((Slot)new SlotItemHandler(this.internal, 22, 78, 48){
            private final int slot = 22;
            private int x;
            private int y;
            {
                this.slot = 22;
                this.x = GoogleCraftingMenu.this.x;
                this.y = GoogleCraftingMenu.this.y;
            }
        }));
        this.customSlots.put(23, this.addSlot((Slot)new SlotItemHandler(this.internal, 23, 96, 48){
            private final int slot = 23;
            private int x;
            private int y;
            {
                this.slot = 23;
                this.x = GoogleCraftingMenu.this.x;
                this.y = GoogleCraftingMenu.this.y;
            }
        }));
        this.customSlots.put(24, this.addSlot((Slot)new SlotItemHandler(this.internal, 24, 114, 48){
            private final int slot = 24;
            private int x;
            private int y;
            {
                this.slot = 24;
                this.x = GoogleCraftingMenu.this.x;
                this.y = GoogleCraftingMenu.this.y;
            }
        }));
        this.customSlots.put(25, this.addSlot((Slot)new SlotItemHandler(this.internal, 25, 132, 48){
            private final int slot = 25;
            private int x;
            private int y;
            {
                this.slot = 25;
                this.x = GoogleCraftingMenu.this.x;
                this.y = GoogleCraftingMenu.this.y;
            }
        }));
        this.customSlots.put(26, this.addSlot((Slot)new SlotItemHandler(this.internal, 26, 150, 48){
            private final int slot = 26;
            private int x;
            private int y;
            {
                this.slot = 26;
                this.x = GoogleCraftingMenu.this.x;
                this.y = GoogleCraftingMenu.this.y;
            }
        }));
        this.customSlots.put(27, this.addSlot((Slot)new SlotItemHandler(this.internal, 27, 6, 66){
            private final int slot = 27;
            private int x;
            private int y;
            {
                this.slot = 27;
                this.x = GoogleCraftingMenu.this.x;
                this.y = GoogleCraftingMenu.this.y;
            }
        }));
        this.customSlots.put(28, this.addSlot((Slot)new SlotItemHandler(this.internal, 28, 24, 66){
            private final int slot = 28;
            private int x;
            private int y;
            {
                this.slot = 28;
                this.x = GoogleCraftingMenu.this.x;
                this.y = GoogleCraftingMenu.this.y;
            }
        }));
        this.customSlots.put(29, this.addSlot((Slot)new SlotItemHandler(this.internal, 29, 42, 66){
            private final int slot = 29;
            private int x;
            private int y;
            {
                this.slot = 29;
                this.x = GoogleCraftingMenu.this.x;
                this.y = GoogleCraftingMenu.this.y;
            }
        }));
        this.customSlots.put(30, this.addSlot((Slot)new SlotItemHandler(this.internal, 30, 60, 66){
            private final int slot = 30;
            private int x;
            private int y;
            {
                this.slot = 30;
                this.x = GoogleCraftingMenu.this.x;
                this.y = GoogleCraftingMenu.this.y;
            }
        }));
        this.customSlots.put(31, this.addSlot((Slot)new SlotItemHandler(this.internal, 31, 78, 66){
            private final int slot = 31;
            private int x;
            private int y;
            {
                this.slot = 31;
                this.x = GoogleCraftingMenu.this.x;
                this.y = GoogleCraftingMenu.this.y;
            }
        }));
        this.customSlots.put(32, this.addSlot((Slot)new SlotItemHandler(this.internal, 32, 96, 66){
            private final int slot = 32;
            private int x;
            private int y;
            {
                this.slot = 32;
                this.x = GoogleCraftingMenu.this.x;
                this.y = GoogleCraftingMenu.this.y;
            }
        }));
        this.customSlots.put(33, this.addSlot((Slot)new SlotItemHandler(this.internal, 33, 114, 66){
            private final int slot = 33;
            private int x;
            private int y;
            {
                this.slot = 33;
                this.x = GoogleCraftingMenu.this.x;
                this.y = GoogleCraftingMenu.this.y;
            }
        }));
        this.customSlots.put(34, this.addSlot((Slot)new SlotItemHandler(this.internal, 34, 132, 66){
            private final int slot = 34;
            private int x;
            private int y;
            {
                this.slot = 34;
                this.x = GoogleCraftingMenu.this.x;
                this.y = GoogleCraftingMenu.this.y;
            }
        }));
        this.customSlots.put(35, this.addSlot((Slot)new SlotItemHandler(this.internal, 35, 150, 66){
            private final int slot = 35;
            private int x;
            private int y;
            {
                this.slot = 35;
                this.x = GoogleCraftingMenu.this.x;
                this.y = GoogleCraftingMenu.this.y;
            }
        }));
        this.customSlots.put(36, this.addSlot((Slot)new SlotItemHandler(this.internal, 36, 6, 84){
            private final int slot = 36;
            private int x;
            private int y;
            {
                this.slot = 36;
                this.x = GoogleCraftingMenu.this.x;
                this.y = GoogleCraftingMenu.this.y;
            }
        }));
        this.customSlots.put(37, this.addSlot((Slot)new SlotItemHandler(this.internal, 37, 24, 84){
            private final int slot = 37;
            private int x;
            private int y;
            {
                this.slot = 37;
                this.x = GoogleCraftingMenu.this.x;
                this.y = GoogleCraftingMenu.this.y;
            }
        }));
        this.customSlots.put(38, this.addSlot((Slot)new SlotItemHandler(this.internal, 38, 42, 84){
            private final int slot = 38;
            private int x;
            private int y;
            {
                this.slot = 38;
                this.x = GoogleCraftingMenu.this.x;
                this.y = GoogleCraftingMenu.this.y;
            }
        }));
        this.customSlots.put(39, this.addSlot((Slot)new SlotItemHandler(this.internal, 39, 60, 84){
            private final int slot = 39;
            private int x;
            private int y;
            {
                this.slot = 39;
                this.x = GoogleCraftingMenu.this.x;
                this.y = GoogleCraftingMenu.this.y;
            }
        }));
        this.customSlots.put(40, this.addSlot((Slot)new SlotItemHandler(this.internal, 40, 78, 84){
            private final int slot = 40;
            private int x;
            private int y;
            {
                this.slot = 40;
                this.x = GoogleCraftingMenu.this.x;
                this.y = GoogleCraftingMenu.this.y;
            }
        }));
        this.customSlots.put(41, this.addSlot((Slot)new SlotItemHandler(this.internal, 41, 96, 84){
            private final int slot = 41;
            private int x;
            private int y;
            {
                this.slot = 41;
                this.x = GoogleCraftingMenu.this.x;
                this.y = GoogleCraftingMenu.this.y;
            }
        }));
        this.customSlots.put(42, this.addSlot((Slot)new SlotItemHandler(this.internal, 42, 114, 84){
            private final int slot = 42;
            private int x;
            private int y;
            {
                this.slot = 42;
                this.x = GoogleCraftingMenu.this.x;
                this.y = GoogleCraftingMenu.this.y;
            }
        }));
        this.customSlots.put(43, this.addSlot((Slot)new SlotItemHandler(this.internal, 43, 132, 84){
            private final int slot = 43;
            private int x;
            private int y;
            {
                this.slot = 43;
                this.x = GoogleCraftingMenu.this.x;
                this.y = GoogleCraftingMenu.this.y;
            }
        }));
        this.customSlots.put(44, this.addSlot((Slot)new SlotItemHandler(this.internal, 44, 150, 84){
            private final int slot = 44;
            private int x;
            private int y;
            {
                this.slot = 44;
                this.x = GoogleCraftingMenu.this.x;
                this.y = GoogleCraftingMenu.this.y;
            }
        }));
        this.customSlots.put(45, this.addSlot((Slot)new SlotItemHandler(this.internal, 45, 6, 102){
            private final int slot = 45;
            private int x;
            private int y;
            {
                this.slot = 45;
                this.x = GoogleCraftingMenu.this.x;
                this.y = GoogleCraftingMenu.this.y;
            }
        }));
        this.customSlots.put(46, this.addSlot((Slot)new SlotItemHandler(this.internal, 46, 24, 102){
            private final int slot = 46;
            private int x;
            private int y;
            {
                this.slot = 46;
                this.x = GoogleCraftingMenu.this.x;
                this.y = GoogleCraftingMenu.this.y;
            }
        }));
        this.customSlots.put(47, this.addSlot((Slot)new SlotItemHandler(this.internal, 47, 42, 102){
            private final int slot = 47;
            private int x;
            private int y;
            {
                this.slot = 47;
                this.x = GoogleCraftingMenu.this.x;
                this.y = GoogleCraftingMenu.this.y;
            }
        }));
        this.customSlots.put(48, this.addSlot((Slot)new SlotItemHandler(this.internal, 48, 60, 102){
            private final int slot = 48;
            private int x;
            private int y;
            {
                this.slot = 48;
                this.x = GoogleCraftingMenu.this.x;
                this.y = GoogleCraftingMenu.this.y;
            }
        }));
        this.customSlots.put(49, this.addSlot((Slot)new SlotItemHandler(this.internal, 49, 78, 102){
            private final int slot = 49;
            private int x;
            private int y;
            {
                this.slot = 49;
                this.x = GoogleCraftingMenu.this.x;
                this.y = GoogleCraftingMenu.this.y;
            }
        }));
        this.customSlots.put(50, this.addSlot((Slot)new SlotItemHandler(this.internal, 50, 96, 102){
            private final int slot = 50;
            private int x;
            private int y;
            {
                this.slot = 50;
                this.x = GoogleCraftingMenu.this.x;
                this.y = GoogleCraftingMenu.this.y;
            }
        }));
        this.customSlots.put(51, this.addSlot((Slot)new SlotItemHandler(this.internal, 51, 114, 102){
            private final int slot = 51;
            private int x;
            private int y;
            {
                this.slot = 51;
                this.x = GoogleCraftingMenu.this.x;
                this.y = GoogleCraftingMenu.this.y;
            }
        }));
        this.customSlots.put(52, this.addSlot((Slot)new SlotItemHandler(this.internal, 52, 132, 102){
            private final int slot = 52;
            private int x;
            private int y;
            {
                this.slot = 52;
                this.x = GoogleCraftingMenu.this.x;
                this.y = GoogleCraftingMenu.this.y;
            }
        }));
        this.customSlots.put(53, this.addSlot((Slot)new SlotItemHandler(this.internal, 53, 150, 102){
            private final int slot = 53;
            private int x;
            private int y;
            {
                this.slot = 53;
                this.x = GoogleCraftingMenu.this.x;
                this.y = GoogleCraftingMenu.this.y;
            }
        }));
        this.customSlots.put(54, this.addSlot((Slot)new SlotItemHandler(this.internal, 54, 6, 120){
            private final int slot = 54;
            private int x;
            private int y;
            {
                this.slot = 54;
                this.x = GoogleCraftingMenu.this.x;
                this.y = GoogleCraftingMenu.this.y;
            }
        }));
        this.customSlots.put(55, this.addSlot((Slot)new SlotItemHandler(this.internal, 55, 24, 120){
            private final int slot = 55;
            private int x;
            private int y;
            {
                this.slot = 55;
                this.x = GoogleCraftingMenu.this.x;
                this.y = GoogleCraftingMenu.this.y;
            }
        }));
        this.customSlots.put(56, this.addSlot((Slot)new SlotItemHandler(this.internal, 56, 42, 120){
            private final int slot = 56;
            private int x;
            private int y;
            {
                this.slot = 56;
                this.x = GoogleCraftingMenu.this.x;
                this.y = GoogleCraftingMenu.this.y;
            }
        }));
        this.customSlots.put(57, this.addSlot((Slot)new SlotItemHandler(this.internal, 57, 60, 120){
            private final int slot = 57;
            private int x;
            private int y;
            {
                this.slot = 57;
                this.x = GoogleCraftingMenu.this.x;
                this.y = GoogleCraftingMenu.this.y;
            }
        }));
        this.customSlots.put(58, this.addSlot((Slot)new SlotItemHandler(this.internal, 58, 78, 120){
            private final int slot = 58;
            private int x;
            private int y;
            {
                this.slot = 58;
                this.x = GoogleCraftingMenu.this.x;
                this.y = GoogleCraftingMenu.this.y;
            }
        }));
        this.customSlots.put(59, this.addSlot((Slot)new SlotItemHandler(this.internal, 59, 96, 120){
            private final int slot = 59;
            private int x;
            private int y;
            {
                this.slot = 59;
                this.x = GoogleCraftingMenu.this.x;
                this.y = GoogleCraftingMenu.this.y;
            }
        }));
        this.customSlots.put(60, this.addSlot((Slot)new SlotItemHandler(this.internal, 60, 114, 120){
            private final int slot = 60;
            private int x;
            private int y;
            {
                this.slot = 60;
                this.x = GoogleCraftingMenu.this.x;
                this.y = GoogleCraftingMenu.this.y;
            }
        }));
        this.customSlots.put(61, this.addSlot((Slot)new SlotItemHandler(this.internal, 61, 132, 120){
            private final int slot = 61;
            private int x;
            private int y;
            {
                this.slot = 61;
                this.x = GoogleCraftingMenu.this.x;
                this.y = GoogleCraftingMenu.this.y;
            }
        }));
        this.customSlots.put(62, this.addSlot((Slot)new SlotItemHandler(this.internal, 62, 150, 120){
            private final int slot = 62;
            private int x;
            private int y;
            {
                this.slot = 62;
                this.x = GoogleCraftingMenu.this.x;
                this.y = GoogleCraftingMenu.this.y;
            }
        }));
        this.customSlots.put(63, this.addSlot((Slot)new SlotItemHandler(this.internal, 63, 6, 138){
            private final int slot = 63;
            private int x;
            private int y;
            {
                this.slot = 63;
                this.x = GoogleCraftingMenu.this.x;
                this.y = GoogleCraftingMenu.this.y;
            }
        }));
        this.customSlots.put(64, this.addSlot((Slot)new SlotItemHandler(this.internal, 64, 24, 138){
            private final int slot = 64;
            private int x;
            private int y;
            {
                this.slot = 64;
                this.x = GoogleCraftingMenu.this.x;
                this.y = GoogleCraftingMenu.this.y;
            }
        }));
        this.customSlots.put(65, this.addSlot((Slot)new SlotItemHandler(this.internal, 65, 42, 138){
            private final int slot = 65;
            private int x;
            private int y;
            {
                this.slot = 65;
                this.x = GoogleCraftingMenu.this.x;
                this.y = GoogleCraftingMenu.this.y;
            }
        }));
        this.customSlots.put(66, this.addSlot((Slot)new SlotItemHandler(this.internal, 66, 60, 138){
            private final int slot = 66;
            private int x;
            private int y;
            {
                this.slot = 66;
                this.x = GoogleCraftingMenu.this.x;
                this.y = GoogleCraftingMenu.this.y;
            }
        }));
        this.customSlots.put(67, this.addSlot((Slot)new SlotItemHandler(this.internal, 67, 78, 138){
            private final int slot = 67;
            private int x;
            private int y;
            {
                this.slot = 67;
                this.x = GoogleCraftingMenu.this.x;
                this.y = GoogleCraftingMenu.this.y;
            }
        }));
        this.customSlots.put(68, this.addSlot((Slot)new SlotItemHandler(this.internal, 68, 96, 138){
            private final int slot = 68;
            private int x;
            private int y;
            {
                this.slot = 68;
                this.x = GoogleCraftingMenu.this.x;
                this.y = GoogleCraftingMenu.this.y;
            }
        }));
        this.customSlots.put(69, this.addSlot((Slot)new SlotItemHandler(this.internal, 69, 114, 138){
            private final int slot = 69;
            private int x;
            private int y;
            {
                this.slot = 69;
                this.x = GoogleCraftingMenu.this.x;
                this.y = GoogleCraftingMenu.this.y;
            }
        }));
        this.customSlots.put(70, this.addSlot((Slot)new SlotItemHandler(this.internal, 70, 132, 138){
            private final int slot = 70;
            private int x;
            private int y;
            {
                this.slot = 70;
                this.x = GoogleCraftingMenu.this.x;
                this.y = GoogleCraftingMenu.this.y;
            }
        }));
        this.customSlots.put(71, this.addSlot((Slot)new SlotItemHandler(this.internal, 71, 150, 138){
            private final int slot = 71;
            private int x;
            private int y;
            {
                this.slot = 71;
                this.x = GoogleCraftingMenu.this.x;
                this.y = GoogleCraftingMenu.this.y;
            }
        }));
        this.customSlots.put(72, this.addSlot((Slot)new SlotItemHandler(this.internal, 72, 6, 156){
            private final int slot = 72;
            private int x;
            private int y;
            {
                this.slot = 72;
                this.x = GoogleCraftingMenu.this.x;
                this.y = GoogleCraftingMenu.this.y;
            }
        }));
        this.customSlots.put(73, this.addSlot((Slot)new SlotItemHandler(this.internal, 73, 24, 156){
            private final int slot = 73;
            private int x;
            private int y;
            {
                this.slot = 73;
                this.x = GoogleCraftingMenu.this.x;
                this.y = GoogleCraftingMenu.this.y;
            }
        }));
        this.customSlots.put(74, this.addSlot((Slot)new SlotItemHandler(this.internal, 74, 42, 156){
            private final int slot = 74;
            private int x;
            private int y;
            {
                this.slot = 74;
                this.x = GoogleCraftingMenu.this.x;
                this.y = GoogleCraftingMenu.this.y;
            }
        }));
        this.customSlots.put(75, this.addSlot((Slot)new SlotItemHandler(this.internal, 75, 60, 156){
            private final int slot = 75;
            private int x;
            private int y;
            {
                this.slot = 75;
                this.x = GoogleCraftingMenu.this.x;
                this.y = GoogleCraftingMenu.this.y;
            }
        }));
        this.customSlots.put(76, this.addSlot((Slot)new SlotItemHandler(this.internal, 76, 78, 156){
            private final int slot = 76;
            private int x;
            private int y;
            {
                this.slot = 76;
                this.x = GoogleCraftingMenu.this.x;
                this.y = GoogleCraftingMenu.this.y;
            }
        }));
        this.customSlots.put(77, this.addSlot((Slot)new SlotItemHandler(this.internal, 77, 96, 156){
            private final int slot = 77;
            private int x;
            private int y;
            {
                this.slot = 77;
                this.x = GoogleCraftingMenu.this.x;
                this.y = GoogleCraftingMenu.this.y;
            }
        }));
        this.customSlots.put(78, this.addSlot((Slot)new SlotItemHandler(this.internal, 78, 114, 156){
            private final int slot = 78;
            private int x;
            private int y;
            {
                this.slot = 78;
                this.x = GoogleCraftingMenu.this.x;
                this.y = GoogleCraftingMenu.this.y;
            }
        }));
        this.customSlots.put(79, this.addSlot((Slot)new SlotItemHandler(this.internal, 79, 132, 156){
            private final int slot = 79;
            private int x;
            private int y;
            {
                this.slot = 79;
                this.x = GoogleCraftingMenu.this.x;
                this.y = GoogleCraftingMenu.this.y;
            }
        }));
        this.customSlots.put(80, this.addSlot((Slot)new SlotItemHandler(this.internal, 80, 150, 156){
            private final int slot = 80;
            private int x;
            private int y;
            {
                this.slot = 80;
                this.x = GoogleCraftingMenu.this.x;
                this.y = GoogleCraftingMenu.this.y;
            }
        }));
        this.customSlots.put(81, this.addSlot((Slot)new SlotItemHandler(this.internal, 81, 222, 84){
            private final int slot = 81;
            private int x;
            private int y;
            {
                this.slot = 81;
                this.x = GoogleCraftingMenu.this.x;
                this.y = GoogleCraftingMenu.this.y;
            }

            public void onTake(Player entity, ItemStack stack) {
                super.onTake(entity, stack);
                GoogleCraftingMenu.this.slotChanged(81, 1, stack.getCount());
            }

            public void onQuickCraft(ItemStack a, ItemStack b) {
                super.onQuickCraft(a, b);
                GoogleCraftingMenu.this.slotChanged(81, 2, b.getCount() - a.getCount());
            }

            public boolean mayPlace(ItemStack stack) {
                return false;
            }
        }));
        for (si = 0; si < 3; ++si) {
            for (int sj = 0; sj < 9; ++sj) {
                this.addSlot(new Slot((Container)inv, sj + (si + 1) * 9, 222 + sj * 18, 120 + si * 18));
            }
        }
        for (si = 0; si < 9; ++si) {
            this.addSlot(new Slot((Container)inv, si, 222 + si * 18, 178));
        }
    }

    public boolean stillValid(Player player) {
        if (this.bound) {
            if (this.boundItemMatcher != null) {
                return this.boundItemMatcher.get();
            }
            if (this.boundBlockEntity != null) {
                return AbstractContainerMenu.stillValid((ContainerLevelAccess)this.access, (Player)player, (Block)this.boundBlockEntity.getBlockState().getBlock());
            }
            if (this.boundEntity != null) {
                return this.boundEntity.isAlive();
            }
        }
        return true;
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (index < 82) {
                if (!this.moveItemStackTo(itemstack1, 82, this.slots.size(), true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(itemstack1, itemstack);
            } else if (!this.moveItemStackTo(itemstack1, 0, 82, false)) {
                if (index < 109 ? !this.moveItemStackTo(itemstack1, 109, this.slots.size(), true) : !this.moveItemStackTo(itemstack1, 82, 109, false)) {
                    return ItemStack.EMPTY;
                }
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(playerIn, itemstack1);
        }
        return itemstack;
    }

    protected boolean moveItemStackTo(ItemStack p_38904_, int p_38905_, int p_38906_, boolean p_38907_) {
        boolean flag = false;
        int i = p_38905_;
        if (p_38907_) {
            i = p_38906_ - 1;
        }
        if (p_38904_.isStackable()) {
            while (!p_38904_.isEmpty() && (p_38907_ ? i >= p_38905_ : i < p_38906_)) {
                ItemStack itemstack;
                Slot slot = (Slot)this.slots.get(i);
                if (slot.mayPlace(itemstack = slot.getItem()) && !itemstack.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)p_38904_, (ItemStack)itemstack)) {
                    int k;
                    int j = itemstack.getCount() + p_38904_.getCount();
                    if (j <= (k = slot.getMaxStackSize(itemstack))) {
                        p_38904_.setCount(0);
                        itemstack.setCount(j);
                        slot.set(itemstack);
                        flag = true;
                    } else if (itemstack.getCount() < k) {
                        p_38904_.shrink(k - itemstack.getCount());
                        itemstack.setCount(k);
                        slot.set(itemstack);
                        flag = true;
                    }
                }
                if (p_38907_) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        if (!p_38904_.isEmpty()) {
            i = p_38907_ ? p_38906_ - 1 : p_38905_;
            while (p_38907_ ? i >= p_38905_ : i < p_38906_) {
                Slot slot1 = (Slot)this.slots.get(i);
                ItemStack itemstack1 = slot1.getItem();
                if (itemstack1.isEmpty() && slot1.mayPlace(p_38904_)) {
                    int l = slot1.getMaxStackSize(p_38904_);
                    slot1.setByPlayer(p_38904_.split(Math.min(p_38904_.getCount(), l)));
                    slot1.setChanged();
                    flag = true;
                    break;
                }
                if (p_38907_) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        return flag;
    }

    public void removed(Player playerIn) {
        block4: {
            super.removed(playerIn);
            if (this.bound || !(playerIn instanceof ServerPlayer)) break block4;
            ServerPlayer serverPlayer = (ServerPlayer)playerIn;
            if (!serverPlayer.isAlive() || serverPlayer.hasDisconnected()) {
                for (int j = 0; j < this.internal.getSlots(); ++j) {
                    playerIn.drop(this.internal.getStackInSlot(j), false);
                    IItemHandler iItemHandler = this.internal;
                    if (!(iItemHandler instanceof IItemHandlerModifiable)) continue;
                    IItemHandlerModifiable ihm = (IItemHandlerModifiable)iItemHandler;
                    ihm.setStackInSlot(j, ItemStack.EMPTY);
                }
            } else {
                for (int i = 0; i < this.internal.getSlots(); ++i) {
                    playerIn.getInventory().placeItemBackInInventory(this.internal.getStackInSlot(i));
                    IItemHandler iItemHandler = this.internal;
                    if (!(iItemHandler instanceof IItemHandlerModifiable)) continue;
                    IItemHandlerModifiable ihm = (IItemHandlerModifiable)iItemHandler;
                    ihm.setStackInSlot(i, ItemStack.EMPTY);
                }
            }
        }
    }

    private void slotChanged(int slotid, int ctype, int meta) {
        if (this.world != null && this.world.isClientSide()) {
            PacketDistributor.sendToServer((CustomPacketPayload)new GoogleCraftingSlotMessage(slotid, this.x, this.y, this.z, ctype, meta), (CustomPacketPayload[])new CustomPacketPayload[0]);
            GoogleCraftingSlotMessage.handleSlotAction(this.entity, slotid, ctype, meta, this.x, this.y, this.z);
        }
    }

    @Override
    public Map<Integer, Slot> getSlots() {
        return Collections.unmodifiableMap(this.customSlots);
    }

    @Override
    public Map<String, Object> getMenuState() {
        return this.menuState;
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        Player entity = event.getEntity();
        AbstractContainerMenu abstractContainerMenu = entity.containerMenu;
        if (abstractContainerMenu instanceof GoogleCraftingMenu) {
            GoogleCraftingMenu menu = (GoogleCraftingMenu)abstractContainerMenu;
            Level world = menu.world;
            double x = menu.x;
            double y = menu.y;
            double z = menu.z;
            GoogleCraftingWhileThisGUIIsOpenTickProcedure.execute((Entity)entity);
        }
    }
}

