/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.playersleep;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.command.TabExecutor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerBedEnterEvent;
import org.bukkit.event.player.PlayerBedLeaveEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class PlayerSleep
extends JavaPlugin
implements Listener,
TabExecutor {
    private boolean enabled;
    private String mode;
    private int value;
    private final Set<Player> sleepingPlayers = new HashSet<Player>();

    public void onEnable() {
        this.saveDefaultConfig();
        this.loadConfigValues();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        Objects.requireNonNull(this.getCommand("playersleep")).setExecutor((CommandExecutor)this);
        Objects.requireNonNull(this.getCommand("playersleep")).setTabCompleter((TabCompleter)this);
        this.getLogger().info("PlayerSleep enabled!");
    }

    private void loadConfigValues() {
        FileConfiguration config = this.getConfig();
        this.enabled = config.getBoolean("enabled", true);
        this.mode = config.getString("mode", "percentage");
        this.value = config.getInt("value", 50);
    }

    @EventHandler
    public void onPlayerBedEnter(PlayerBedEnterEvent event) {
        if (!this.enabled || event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        World world = player.getWorld();
        if (world.getTime() < 12541L || world.getTime() > 23458L) {
            return;
        }
        this.sleepingPlayers.add(player);
        int online = (int)world.getPlayers().stream().filter(p -> !p.isDead()).count();
        int required = this.calculateRequiredPlayers(online);
        Bukkit.broadcastMessage((String)(ChatColor.GOLD + "[Sleep] " + ChatColor.YELLOW + player.getName() + " went to bed (" + this.sleepingPlayers.size() + "/" + required + ")"));
        if (this.sleepingPlayers.size() >= required) {
            Bukkit.broadcastMessage((String)(ChatColor.GREEN + "[Sleep] Enough players are sleeping! Skipping the night..."));
            world.setTime(0L);
            world.setStorm(false);
            world.setThundering(false);
            this.sleepingPlayers.clear();
        }
    }

    @EventHandler
    public void onPlayerBedLeave(PlayerBedLeaveEvent event) {
        this.sleepingPlayers.remove(event.getPlayer());
    }

    private int calculateRequiredPlayers(int online) {
        if (this.mode.equalsIgnoreCase("percentage")) {
            int percent = Math.max(0, Math.min(100, this.value));
            int required = (int)Math.ceil((double)percent / 100.0 * (double)online);
            return Math.max(1, required);
        }
        if (this.mode.equalsIgnoreCase("amount")) {
            return Math.min(this.value, online);
        }
        return online;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!sender.hasPermission("playersleep.command")) {
            sender.sendMessage(ChatColor.RED + "You don't have permission to use this command.");
            return true;
        }
        if (args.length == 0) {
            sender.sendMessage(ChatColor.GOLD + "=== PlayerSleep Commands ===");
            sender.sendMessage(ChatColor.YELLOW + "/playersleep reload " + ChatColor.WHITE + "- Reloads the config");
            sender.sendMessage(ChatColor.YELLOW + "/playersleep set <enabled|mode|value> <newValue> " + ChatColor.WHITE + "- Edit config values");
            return true;
        }
        if (args[0].equalsIgnoreCase("reload")) {
            this.reloadConfig();
            this.loadConfigValues();
            sender.sendMessage(ChatColor.GREEN + "[PlayerSleep] Config reloaded successfully!");
            return true;
        }
        if (args[0].equalsIgnoreCase("set")) {
            if (args.length < 3) {
                sender.sendMessage(ChatColor.RED + "Usage: /playersleep set <enabled|mode|value> <newValue>");
                return true;
            }
            String key = args[1].toLowerCase();
            String newValue = args[2];
            switch (key) {
                case "enabled": {
                    boolean newEnabled = Boolean.parseBoolean(newValue);
                    this.getConfig().set("enabled", (Object)newEnabled);
                    break;
                }
                case "mode": {
                    if (!newValue.equalsIgnoreCase("percentage") && !newValue.equalsIgnoreCase("amount")) {
                        sender.sendMessage(ChatColor.RED + "Mode must be 'percentage' or 'amount'.");
                        return true;
                    }
                    this.getConfig().set("mode", (Object)newValue.toLowerCase());
                    break;
                }
                case "value": {
                    try {
                        int newVal = Integer.parseInt(newValue);
                        this.getConfig().set("value", (Object)newVal);
                        break;
                    }
                    catch (NumberFormatException e) {
                        sender.sendMessage(ChatColor.RED + "Value must be a number.");
                        return true;
                    }
                }
                default: {
                    sender.sendMessage(ChatColor.RED + "Unknown setting: " + key);
                    return true;
                }
            }
            this.saveConfig();
            this.loadConfigValues();
            sender.sendMessage(ChatColor.GREEN + "[PlayerSleep] Updated '" + key + "' to " + newValue);
            return true;
        }
        sender.sendMessage(ChatColor.RED + "Unknown command. Use /playersleep for help.");
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String alias, String[] args) {
        if (!sender.hasPermission("playersleep.command")) {
            return Collections.emptyList();
        }
        if (args.length == 1) {
            return Arrays.asList("reload", "set");
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("set")) {
            return Arrays.asList("enabled", "mode", "value");
        }
        if (args.length == 3 && args[0].equalsIgnoreCase("set")) {
            switch (args[1].toLowerCase()) {
                case "enabled": {
                    return Arrays.asList("true", "false");
                }
                case "mode": {
                    return Arrays.asList("percentage", "amount");
                }
                case "value": {
                    return Arrays.asList("10", "25", "50", "75", "100");
                }
            }
        }
        return Collections.emptyList();
    }
}

