/*
 * Decompiled with CFR 0.152.
 */
package net.salju.curse.events;

import com.google.common.collect.ImmutableSet;
import com.mojang.serialization.MapCodec;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.salju.curse.events.CurseManager;
import net.salju.curse.init.CursedLoot;

public record CurseCondition() implements LootItemCondition
{
    public static final MapCodec<CurseCondition> CODEC = MapCodec.unit(CurseCondition::new);

    public boolean test(LootContext context) {
        Entity target = this.getTarget(context);
        if (target instanceof Player) {
            Player player = (Player)target;
            return CurseManager.isCursed(player);
        }
        return false;
    }

    public Set<ContextKey<?>> getReferencedContextParams() {
        return ImmutableSet.of((Object)LootContextParams.ATTACKING_ENTITY, (Object)LootContextParams.THIS_ENTITY);
    }

    public LootItemConditionType getType() {
        return CursedLoot.CURSED.get();
    }

    @Nullable
    public Entity getTarget(LootContext context) {
        if (context.hasParameter(LootContextParams.ATTACKING_ENTITY) && context.getParameter(LootContextParams.ATTACKING_ENTITY) instanceof Player) {
            return (Entity)context.getParameter(LootContextParams.ATTACKING_ENTITY);
        }
        if (context.hasParameter(LootContextParams.THIS_ENTITY) && context.getParameter(LootContextParams.THIS_ENTITY) instanceof Player) {
            return (Entity)context.getParameter(LootContextParams.THIS_ENTITY);
        }
        return null;
    }
}

