/*
 * Decompiled with CFR 0.152.
 */
package net.salju.curse.events;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import net.neoforged.neoforge.event.entity.living.LivingExperienceDropEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingKnockBackEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.salju.curse.events.CurseManager;
import net.salju.curse.init.CursedConfig;
import net.salju.curse.init.CursedData;
import net.salju.curse.init.CursedTags;
import net.salju.curse.item.component.CursedItem;

@EventBusSubscriber
public class CurseEvents {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onHurt(LivingIncomingDamageEvent event) {
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && CurseManager.isCursed(player = (Player)livingEntity) && event.getAmount() <= (float)((Integer)CursedConfig.MAXDMG.get()).intValue()) {
            event.setAmount(event.getAmount() * ((float)((Integer)CursedConfig.DEATH.get()).intValue() / 100.0f));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onKnockKnock(LivingKnockBackEvent event) {
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && CurseManager.isCursed(player = (Player)livingEntity) && event.getStrength() <= (float)((Integer)CursedConfig.MAXDMG.get()).intValue()) {
            event.setStrength(event.getStrength() * ((float)((Integer)CursedConfig.KNOCK.get()).intValue() / 100.0f));
        }
    }

    @SubscribeEvent
    public static void onLivingDropXp(LivingExperienceDropEvent event) {
        if (event.getAttackingPlayer() != null && CurseManager.isCursed(event.getAttackingPlayer())) {
            event.setDroppedExperience(event.getDroppedExperience() * ((Integer)CursedConfig.EXP.get() / 100));
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        if (CurseManager.isCursed(player)) {
            if (!(player.level().isClientSide() || player.isCreative() || player.isSpectator())) {
                if (player.getRemainingFireTicks() == 1 && ((Boolean)CursedConfig.FIRE.get()).booleanValue()) {
                    player.setRemainingFireTicks(120);
                }
                if (((Boolean)CursedConfig.ANGRY.get()).booleanValue()) {
                    for (Mob angry : player.level().getEntitiesOfClass(Mob.class, player.getBoundingBox().inflate(28.0))) {
                        TamableAnimal pet;
                        IronGolem golem;
                        if (!(angry instanceof NeutralMob) || angry instanceof IronGolem && (golem = (IronGolem)angry).isPlayerCreated() || angry instanceof TamableAnimal && (pet = (TamableAnimal)angry).isTame() || angry.getType().is(CursedTags.ANGRY) || angry.getTarget() != null || !player.hasLineOfSight((Entity)angry) && !((double)player.distanceTo((Entity)angry) <= 4.0)) continue;
                        angry.setTarget((LivingEntity)player);
                    }
                }
            }
            if (player.isSleeping() && player.getSleepTimer() >= 95 && ((Boolean)CursedConfig.SLEEP.get()).booleanValue()) {
                player.stopSleeping();
                player.displayClientMessage((Component)Component.translatable((String)"gui.curse.sleep_message"), true);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerDone(LivingEntityUseItemEvent.Finish event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            CursedItem data = (CursedItem)event.getItem().get(CursedData.CURSED);
            if (data != null) {
                CurseManager.setCursed(player, data.getCursedStatus());
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (!CurseManager.isCursed(event.getEntity())) {
            CompoundTag data;
            if (event.getEntity().getPersistentData().getCompound("PlayerPersisted").isEmpty()) {
                event.getEntity().getPersistentData().put("PlayerPersisted", (Tag)new CompoundTag());
            }
            if (((Boolean)CursedConfig.ALWAYS.get()).booleanValue()) {
                CurseManager.setCursed(event.getEntity(), true);
            } else if (((Boolean)CursedConfig.APPLE.get()).booleanValue() && event.getEntity().getPersistentData().getCompound("PlayerPersisted").isPresent() && !(data = (CompoundTag)event.getEntity().getPersistentData().getCompound("PlayerPersisted").get()).getBooleanOr("cursed_has_joined", false)) {
                ItemStack apple = new ItemStack((ItemLike)Items.GOLDEN_APPLE);
                apple.set(CursedData.CURSED, (Object)new CursedItem(true));
                event.getEntity().addItem(apple);
                data.putBoolean("cursed_has_joined", true);
                event.getEntity().getPersistentData().put("PlayerPersisted", (Tag)data);
            }
        }
    }
}

