/*
 * Decompiled with CFR 0.152.
 */
package net.salju.curse.mixins;

import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.salju.curse.init.CursedConfig;
import net.salju.curse.init.CursedData;
import net.salju.curse.item.component.CursedItem;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Item.class})
public abstract class ItemMixin {
    @Inject(method={"appendHoverText"}, at={@At(value="TAIL")})
    private void applyTooltip(ItemStack stack, Item.TooltipContext context, TooltipDisplay display, Consumer<Component> list, TooltipFlag flag, CallbackInfo ci) {
        CursedItem data = (CursedItem)stack.get(CursedData.CURSED);
        if (data != null) {
            list.accept((Component)Component.translatable((String)("item.curse.tooltip." + data.getCursedStatus())).withStyle(data.getCursedStatus() ? ChatFormatting.DARK_RED : ChatFormatting.GOLD));
            if (data.getCursedStatus()) {
                list.accept((Component)Component.literal((String)""));
                if (flag.hasShiftDown()) {
                    if ((Integer)CursedConfig.DEATH.get() > 100) {
                        list.accept((Component)Component.translatable((String)"item.curse.tooltip.damage", (Object[])new Object[]{Component.literal((String)Integer.toString((Integer)CursedConfig.DEATH.get() - 100)).withStyle(ChatFormatting.GOLD), Component.literal((String)"%").withStyle(ChatFormatting.GOLD)}).withStyle(ChatFormatting.DARK_PURPLE));
                    }
                    if (((Boolean)CursedConfig.ANGRY.get()).booleanValue()) {
                        list.accept((Component)Component.translatable((String)"item.curse.tooltip.neutrals").withStyle(ChatFormatting.DARK_PURPLE));
                    }
                    if (((Boolean)CursedConfig.FIRE.get()).booleanValue()) {
                        list.accept((Component)Component.translatable((String)"item.curse.tooltip.fire").withStyle(ChatFormatting.DARK_PURPLE));
                    }
                    if (((Boolean)CursedConfig.SLEEP.get()).booleanValue()) {
                        list.accept((Component)Component.translatable((String)"item.curse.tooltip.sleep").withStyle(ChatFormatting.DARK_PURPLE));
                    }
                    if ((Integer)CursedConfig.EXP.get() > 100) {
                        list.accept((Component)Component.translatable((String)"item.curse.tooltip.xp", (Object[])new Object[]{Component.literal((String)Integer.toString((Integer)CursedConfig.EXP.get() - 100)).withStyle(ChatFormatting.GOLD), Component.literal((String)"%").withStyle(ChatFormatting.GOLD)}).withStyle(ChatFormatting.DARK_PURPLE));
                    }
                } else {
                    list.accept((Component)Component.translatable((String)"item.curse.tooltip.shift").withStyle(ChatFormatting.DARK_PURPLE));
                }
            }
        }
    }
}

