/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.craftingslots.menu;

import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.StackedItemContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;

public class InventoryCraftingContainer
extends TransientCraftingContainer {
    private final AbstractContainerMenu menu;
    private final Inventory playerInventory;

    public InventoryCraftingContainer(AbstractContainerMenu menu, Inventory playerInventory) {
        super(menu, 3, 3);
        this.menu = menu;
        this.playerInventory = playerInventory;
    }

    public ItemStack removeItemNoUpdate(int i) {
        return this.playerInventory.removeItemNoUpdate(this.getInventorySlot(i));
    }

    public ItemStack getItem(int i) {
        return this.playerInventory.getItem(this.getInventorySlot(i));
    }

    public void setItem(int i, ItemStack itemStack) {
        this.playerInventory.setItem(this.getInventorySlot(i), itemStack);
        this.menu.slotsChanged((Container)this);
    }

    public boolean isEmpty() {
        for (int i = 0; i < 9; ++i) {
            if (this.playerInventory.getItem(this.getInventorySlot(i)).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public List<ItemStack> getItems() {
        NonNullList items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < 9; ++i) {
            items.set(i, (Object)this.getItem(i));
        }
        return items;
    }

    public void fillStackedContents(StackedItemContents stackedContents) {
        for (int i = 0; i < this.getContainerSize(); ++i) {
            ItemStack itemStack = this.getItem(i);
            stackedContents.accountSimpleStack(itemStack);
        }
    }

    public ItemStack removeItem(int i, int count) {
        ItemStack oldStack = this.playerInventory.getItem(this.getInventorySlot(i));
        ItemStack itemStack = oldStack;
        if (!itemStack.isEmpty()) {
            if (itemStack.getCount() <= count) {
                this.playerInventory.setItem(this.getInventorySlot(i), ItemStack.EMPTY);
                this.menu.slotsChanged((Container)this);
                return itemStack;
            }
            itemStack = itemStack.split(count);
            if (oldStack.isEmpty()) {
                this.playerInventory.setItem(this.getInventorySlot(i), ItemStack.EMPTY);
            }
            this.menu.slotsChanged((Container)this);
            return itemStack;
        }
        return ItemStack.EMPTY;
    }

    public int getInventorySlot(int i) {
        if (i < 3) {
            return 6 + i + 9;
        }
        if (i < 6) {
            return 15 + i - 3 + 9;
        }
        if (i < 9) {
            return 24 + i - 6 + 9;
        }
        return 0;
    }
}

