/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.craftingslots.item;

import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.craftingslots.menu.PortableCraftingMenu;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;

public class PortableCraftingItem
extends Item {
    public static final String name = "portable_crafting";

    public PortableCraftingItem(Item.Properties properties) {
        super(properties.stacksTo(1));
    }

    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        this.openPortableCrafting(player);
        return InteractionResult.SUCCESS;
    }

    public InteractionResult useOn(UseOnContext context) {
        if (context.getPlayer() != null) {
            this.openPortableCrafting(context.getPlayer());
        }
        return InteractionResult.SUCCESS;
    }

    private void openPortableCrafting(Player player) {
        if (!player.level().isClientSide()) {
            Balm.getNetworking().openMenu(player, this.getCraftingContainerProvider());
        }
    }

    protected MenuProvider getCraftingContainerProvider() {
        return PortableCraftingMenu.provider;
    }
}

