/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.craftingslots.menu;

import java.util.List;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.recipebook.ServerPlaceRecipe;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedItemContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.AbstractCraftingMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.RecipeBookType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public abstract class CustomCraftingMenu
extends AbstractCraftingMenu {
    private static final int WIDTH = 3;
    private static final int HEIGHT = 3;
    private final Inventory playerInventory;
    private boolean placingRecipe;

    protected CustomCraftingMenu(MenuType<?> type, int id, Inventory playerInventory) {
        super(type, id, 3, 3);
        this.playerInventory = playerInventory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecipeBookMenu.PostPlaceAction handlePlacement(boolean useMaxItems, boolean b, RecipeHolder<?> recipeHolder, ServerLevel level, Inventory inventory) {
        RecipeBookMenu.PostPlaceAction result;
        RecipeHolder<?> craftingRecipeHolder = recipeHolder;
        this.beginPlacingRecipe();
        try {
            List<Slot> list = this.getInputGridSlots();
            result = this.placeRecipe(useMaxItems, b, inventory, list, craftingRecipeHolder);
        }
        finally {
            this.finishPlacingRecipe(level, craftingRecipeHolder);
        }
        return result;
    }

    protected RecipeBookMenu.PostPlaceAction placeRecipe(boolean useMaxItems, boolean flag, Inventory inventory, List<Slot> inputGridSlots, RecipeHolder<CraftingRecipe> craftingRecipeHolder) {
        return ServerPlaceRecipe.placeRecipe((ServerPlaceRecipe.CraftingMenuAccess)new ServerPlaceRecipe.CraftingMenuAccess<CraftingRecipe>(){

            public void fillCraftSlotsStackedContents(StackedItemContents stackedItemContents) {
                CustomCraftingMenu.this.fillCraftSlotsStackedContents(stackedItemContents);
            }

            public void clearCraftingContent() {
                CustomCraftingMenu.this.getResultContainer().clearContent();
                CustomCraftingMenu.this.getCraftingContainer().clearContent();
            }

            public boolean recipeMatches(RecipeHolder<CraftingRecipe> recipeHolder) {
                return ((CraftingRecipe)recipeHolder.value()).matches((RecipeInput)CustomCraftingMenu.this.getCraftingContainer().asCraftInput(), CustomCraftingMenu.this.owner().level());
            }
        }, (int)3, (int)3, inputGridSlots, inputGridSlots, (Inventory)inventory, craftingRecipeHolder, (boolean)useMaxItems, (boolean)flag);
    }

    public abstract Slot getResultSlot();

    public abstract List<Slot> getInputGridSlots();

    protected abstract CraftingContainer getCraftingContainer();

    protected abstract ResultContainer getResultContainer();

    protected void slotChangedCraftingGrid(AbstractContainerMenu menu, ServerLevel level, Player player, CraftingContainer craftingContainer, ResultContainer resultContainer, @Nullable RecipeHolder<CraftingRecipe> recipeHolder) {
        CraftingInput craftInput = craftingContainer.asCraftInput();
        ServerPlayer serverPlayer = (ServerPlayer)player;
        ItemStack itemStack = ItemStack.EMPTY;
        Optional foundRecipe = level.getServer().getRecipeManager().getRecipeFor(RecipeType.CRAFTING, (RecipeInput)craftInput, (Level)level, recipeHolder);
        if (foundRecipe.isPresent()) {
            ItemStack assembledStack;
            RecipeHolder foundRecipeHolder = (RecipeHolder)foundRecipe.get();
            CraftingRecipe craftingRecipe = (CraftingRecipe)foundRecipeHolder.value();
            if (resultContainer.setRecipeUsed(serverPlayer, foundRecipeHolder) && (assembledStack = craftingRecipe.assemble((RecipeInput)craftInput, (HolderLookup.Provider)level.registryAccess())).isItemEnabled(level.enabledFeatures())) {
                itemStack = assembledStack;
            }
        }
        resultContainer.setItem(this.getResultSlot().getContainerSlot(), itemStack);
        menu.setRemoteSlot(this.getResultSlot().index, itemStack);
        serverPlayer.connection.send((Packet)new ClientboundContainerSetSlotPacket(menu.containerId, menu.incrementStateId(), this.getResultSlot().index, itemStack));
    }

    public void slotsChanged(Container container) {
        Level level;
        if (!this.placingRecipe && (level = this.playerInventory.player.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.slotChangedCraftingGrid((AbstractContainerMenu)this, serverLevel, this.playerInventory.player, this.getCraftingContainer(), this.getResultContainer(), null);
        }
    }

    public void beginPlacingRecipe() {
        this.placingRecipe = true;
    }

    public void finishPlacingRecipe(ServerLevel level, RecipeHolder<CraftingRecipe> recipeHolder) {
        this.placingRecipe = false;
        this.slotChangedCraftingGrid((AbstractContainerMenu)this, level, this.playerInventory.player, this.getCraftingContainer(), this.getResultContainer(), recipeHolder);
    }

    public boolean canTakeItemForPickAll(ItemStack itemStack, Slot slot) {
        return slot.container != this.getResultContainer() && super.canTakeItemForPickAll(itemStack, slot);
    }

    public RecipeBookType getRecipeBookType() {
        return RecipeBookType.CRAFTING;
    }

    protected Player owner() {
        return this.playerInventory.player;
    }
}

