/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.craftingslots.network;

import java.util.function.Predicate;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.craftingslots.item.ModItems;
import net.blay09.mods.craftingslots.menu.InventoryCraftingMenu;
import net.blay09.mods.craftingslots.menu.PortableCraftingMenu;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class PortableCraftingMessage
implements CustomPacketPayload {
    public static final PortableCraftingMessage INSTANCE = new PortableCraftingMessage();
    public static final CustomPacketPayload.Type<PortableCraftingMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"craftingslots", (String)"portable_crafting"));
    public static final StreamCodec<RegistryFriendlyByteBuf, PortableCraftingMessage> STREAM_CODEC = StreamCodec.unit((Object)INSTANCE);

    private PortableCraftingMessage() {
    }

    public static void handle(ServerPlayer player, PortableCraftingMessage message) {
        if (player == null) {
            return;
        }
        ItemStack itemStack = PortableCraftingMessage.findPortableCrafting(player.getInventory());
        if (itemStack.getItem() == ModItems.inventoryCraftingTable && !(player.containerMenu instanceof InventoryCraftingMenu)) {
            Balm.getNetworking().openMenu((Player)player, InventoryCraftingMenu.provider);
        } else if (itemStack.getItem() == ModItems.portableCraftingTable && !(player.containerMenu instanceof PortableCraftingMenu)) {
            Balm.getNetworking().openMenu((Player)player, PortableCraftingMenu.provider);
        }
    }

    private static ItemStack findPortableCrafting(Inventory inventory) {
        Predicate<ItemStack> predicate = itemStack -> itemStack.getItem() == ModItems.inventoryCraftingTable || itemStack.getItem() == ModItems.portableCraftingTable;
        ItemStack charm = Balm.getModSupport().trinkets().findEquipped(inventory.player, predicate);
        if (!charm.isEmpty()) {
            return charm;
        }
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            ItemStack itemStack2 = inventory.getItem(i);
            if (!predicate.test(itemStack2)) continue;
            return itemStack2;
        }
        return ItemStack.EMPTY;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

