/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.craftingslots.menu;

import java.util.List;
import net.blay09.mods.balm.api.menu.BalmMenuProvider;
import net.blay09.mods.craftingslots.menu.CustomCraftingMenu;
import net.blay09.mods.craftingslots.menu.InventoryCraftingContainer;
import net.blay09.mods.craftingslots.menu.ModMenus;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Unit;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedItemContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class InventoryCraftingMenu
extends CustomCraftingMenu {
    private static final int RESULT_SLOT = 0;
    private static final int CRAFT_SLOT_START = 1;
    private static final int CRAFT_SLOT_COUNT = 9;
    private static final int CRAFT_SLOT_END = 10;
    public static final MenuProvider provider = new BalmMenuProvider<Unit>(){

        public Unit getScreenOpeningData(ServerPlayer serverPlayer) {
            return Unit.INSTANCE;
        }

        public StreamCodec<RegistryFriendlyByteBuf, Unit> getScreenStreamCodec() {
            return StreamCodec.unit((Object)Unit.INSTANCE);
        }

        public Component getDisplayName() {
            return Component.translatable((String)"container.craftingslots.inventory_crafting");
        }

        public AbstractContainerMenu createMenu(int windowId, Inventory playerInventory, Player playerEntity) {
            return new InventoryCraftingMenu(windowId, playerInventory);
        }
    };
    private final ResultContainer resultContainer = new ResultContainer();
    private final CraftingContainer craftingContainer;

    public InventoryCraftingMenu(int windowId, Inventory playerInventory) {
        super((MenuType)ModMenus.inventoryCrafting.get(), windowId, playerInventory);
        int j;
        int i;
        this.craftingContainer = new InventoryCraftingContainer((AbstractContainerMenu)this, playerInventory);
        this.addSlot((Slot)new ResultSlot(playerInventory.player, this.craftingContainer, (Container)this.resultContainer, 0, 193, 38));
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                this.addSlot(new Slot((Container)this.craftingContainer, j + i * 3, 119 + j * 18, 20 + i * 18));
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 6; ++j) {
                this.addSlot(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 20 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            int x = 8 + i * 18;
            if (i >= 6) {
                x += 3;
            }
            this.addSlot(new Slot((Container)playerInventory, i, x, 78));
        }
        this.slotsChanged((Container)this.craftingContainer);
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public ItemStack quickMoveStack(Player player, int index) {
        boolean CRAFTING_GRID_START = true;
        int CRAFTING_GRID_END = 10;
        boolean CRAFTING_RESULT_SLOT = false;
        ItemStack itemStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack slotStack = slot.getItem();
            itemStack = slotStack.copy();
            if (index == 0) {
                slotStack.getItem().onCraftedBy(slotStack, player);
                if (!this.moveItemStackTo(slotStack, 10, this.slots.size() - 1, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(slotStack, itemStack);
            } else if (index < 10 ? !this.moveItemStackTo(slotStack, 10, this.slots.size(), true) : !this.moveItemStackTo(slotStack, 1, 10, false)) {
                return ItemStack.EMPTY;
            }
            if (slotStack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (slotStack.getCount() == itemStack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, slotStack);
            if (index == 0) {
                player.drop(slotStack, false);
            }
        }
        return itemStack;
    }

    @Override
    public boolean canTakeItemForPickAll(ItemStack itemStack, Slot slot) {
        return slot.container != this.resultContainer && super.canTakeItemForPickAll(itemStack, slot);
    }

    @Override
    public Slot getResultSlot() {
        return (Slot)this.slots.get(0);
    }

    @Override
    public List<Slot> getInputGridSlots() {
        return this.slots.subList(1, 10);
    }

    @Override
    public CraftingContainer getCraftingContainer() {
        return this.craftingContainer;
    }

    @Override
    protected ResultContainer getResultContainer() {
        return this.resultContainer;
    }

    public void fillCraftSlotsStackedContents(StackedItemContents stackedItemContents) {
        this.craftingContainer.fillStackedContents(stackedItemContents);
    }
}

