/*
 * Decompiled with CFR 0.152.
 */
package net.bewis09.bewisclient.cosmetics;

import com.google.gson.Gson;
import com.mojang.authlib.GameProfile;
import java.io.Closeable;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.CloseableKt;
import kotlin.io.encoding.Base64;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import net.bewis09.bewisclient.cosmetics.AnimatedCosmetic;
import net.bewis09.bewisclient.cosmetics.Cosmetic;
import net.bewis09.bewisclient.cosmetics.CosmeticIdentifier;
import net.bewis09.bewisclient.cosmetics.CosmeticType;
import net.bewis09.bewisclient.cosmetics.StaticCosmetic;
import net.bewis09.bewisclient.settings.types.BooleanSetting;
import net.bewis09.bewisclient.settings.types.ObjectSetting;
import net.bewis09.bewisclient.settings.types.Setting;
import net.bewis09.bewisclient.settings.types.StringMapSetting;
import net.bewis09.bewisclient.util.EventEntrypoint;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_156;
import net.minecraft.class_1802;
import net.minecraft.class_310;
import net.minecraft.class_640;
import net.minecraft.class_742;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u0002:\u0004DEFGB\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0015\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\tJ%\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u0010\u0010\u0011J%\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u0013\u0010\u0011J'\u0010\u0017\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u0017\u0010\u0018J'\u0010\u001b\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000b\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u001d\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u000b\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u000f\u0010 \u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b \u0010\u0004J\u000f\u0010!\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b!\u0010\u0004J\u0017\u0010$\u001a\u0004\u0018\u00010#2\u0006\u0010\"\u001a\u00020\r\u00a2\u0006\u0004\b$\u0010%J\u001f\u0010(\u001a\u0004\u0018\u00010\u00162\u0006\u0010'\u001a\u00020&2\u0006\u0010\u001a\u001a\u00020\u0019\u00a2\u0006\u0004\b(\u0010)R\u001d\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00050*8\u0006\u00a2\u0006\f\n\u0004\b+\u0010,\u001a\u0004\b-\u0010.R\u001d\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00050*8\u0006\u00a2\u0006\f\n\u0004\b/\u0010,\u001a\u0004\b0\u0010.R#\u00102\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0007018\u0006\u00a2\u0006\f\n\u0004\b2\u00103\u001a\u0004\b\b\u00104R/\u00106\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\r05018\u0006\u00a2\u0006\f\n\u0004\b6\u00103\u001a\u0004\b7\u00104R#\u00108\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0016018F\u00a2\u0006\f\n\u0004\b8\u00103\u001a\u0004\b9\u00104R\u0017\u0010;\u001a\u00020:8\u0006\u00a2\u0006\f\n\u0004\b;\u0010<\u001a\u0004\b=\u0010>R\u0017\u0010@\u001a\u00020?8\u0006\u00a2\u0006\f\n\u0004\b@\u0010A\u001a\u0004\bB\u0010C\u00a8\u0006H"}, d2={"Lnet/bewis09/bewisclient/cosmetics/CosmeticLoader;", "Lnet/bewis09/bewisclient/settings/types/ObjectSetting;", "Lnet/bewis09/bewisclient/util/EventEntrypoint;", "<init>", "()V", "Lnet/bewis09/bewisclient/cosmetics/CosmeticIdentifier;", "identifier", "Lnet/bewis09/bewisclient/cosmetics/CosmeticLoader$DownloadStatus;", "getStatus", "(Lnet/bewis09/bewisclient/cosmetics/CosmeticIdentifier;)Lnet/bewis09/bewisclient/cosmetics/CosmeticLoader$DownloadStatus;", "cosmetic", "", "path", "", "frames", "", "downloadCosmetic", "(Lnet/bewis09/bewisclient/cosmetics/CosmeticIdentifier;Ljava/lang/String;I)V", "hash", "loadCosmetic", "", "data", "Lnet/bewis09/bewisclient/cosmetics/Cosmetic;", "loadCosmeticFromByteArray", "(Lnet/bewis09/bewisclient/cosmetics/CosmeticIdentifier;[BI)Lnet/bewis09/bewisclient/cosmetics/Cosmetic;", "Lnet/bewis09/bewisclient/cosmetics/CosmeticType;", "type", "checkCosmetic", "(Lnet/bewis09/bewisclient/cosmetics/CosmeticType;Ljava/lang/String;Ljava/lang/String;)[B", "", "checkHash", "([BLjava/lang/String;)Z", "onInitializeClient", "onMinecraftClientInitFinished", "hashCode", "Lnet/minecraft/class_640;", "getEntityBySkinTextures", "(I)Lnet/minecraft/class_640;", "Lcom/mojang/authlib/GameProfile;", "player", "getCosmeticForPlayer", "(Lcom/mojang/authlib/GameProfile;Lnet/bewis09/bewisclient/cosmetics/CosmeticType;)Lnet/bewis09/bewisclient/cosmetics/Cosmetic;", "", "allowedCosmetics", "Ljava/util/List;", "getAllowedCosmetics", "()Ljava/util/List;", "elytraCosmetics", "getElytraCosmetics", "", "status", "Ljava/util/Map;", "()Ljava/util/Map;", "Lkotlin/Pair;", "byteData", "getByteData", "cosmetics", "getCosmetics", "Lnet/bewis09/bewisclient/settings/types/StringMapSetting;", "selected", "Lnet/bewis09/bewisclient/settings/types/StringMapSetting;", "getSelected", "()Lnet/bewis09/bewisclient/settings/types/StringMapSetting;", "Lnet/bewis09/bewisclient/settings/types/BooleanSetting;", "elytra", "Lnet/bewis09/bewisclient/settings/types/BooleanSetting;", "getElytra", "()Lnet/bewis09/bewisclient/settings/types/BooleanSetting;", "CosmeticData", "SpecialEntry", "CosmeticEntry", "DownloadStatus", "bewisclient_client"})
@Environment(value=EnvType.CLIENT)
@SourceDebugExtension(value={"SMAP\nCosmeticLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CosmeticLoader.kt\nnet/bewis09/bewisclient/cosmetics/CosmeticLoader\n+ 2 Util.kt\nnet/bewis09/bewisclient/util/UtilKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,211:1\n8#2,5:212\n8#2,5:217\n8#2,5:222\n8#2,5:227\n8#2,2:238\n10#2,3:241\n216#3,2:232\n295#4,2:234\n295#4,2:236\n1#5:240\n13805#6:244\n12970#6,2:245\n13806#6:247\n13805#6,2:248\n*S KotlinDebug\n*F\n+ 1 CosmeticLoader.kt\nnet/bewis09/bewisclient/cosmetics/CosmeticLoader\n*L\n46#1:212,5\n73#1:217,5\n75#1:222,5\n85#1:227,5\n94#1:238,2\n94#1:241,3\n134#1:232,2\n174#1:234,2\n196#1:236,2\n114#1:244\n115#1:245,2\n114#1:247\n123#1:248,2\n*E\n"})
public final class CosmeticLoader
extends ObjectSetting
implements EventEntrypoint {
    @NotNull
    public static final CosmeticLoader INSTANCE = new CosmeticLoader();
    @NotNull
    private static final List<CosmeticIdentifier> allowedCosmetics = new ArrayList();
    @NotNull
    private static final List<CosmeticIdentifier> elytraCosmetics = new ArrayList();
    @NotNull
    private static final Map<CosmeticIdentifier, DownloadStatus> status = new LinkedHashMap();
    @NotNull
    private static final Map<CosmeticIdentifier, Pair<byte[], Integer>> byteData = new LinkedHashMap();
    @NotNull
    private static final Map<CosmeticIdentifier, Cosmetic> cosmetics = new LinkedHashMap();
    @NotNull
    private static final StringMapSetting selected = (StringMapSetting)INSTANCE.create("selected", (Setting)new StringMapSetting());
    @NotNull
    private static final BooleanSetting elytra = ObjectSetting.boolean$default(INSTANCE, "elytra", true, null, 4, null);

    private CosmeticLoader() {
    }

    @NotNull
    public final List<CosmeticIdentifier> getAllowedCosmetics() {
        return allowedCosmetics;
    }

    @NotNull
    public final List<CosmeticIdentifier> getElytraCosmetics() {
        return elytraCosmetics;
    }

    @NotNull
    public final Map<CosmeticIdentifier, DownloadStatus> getStatus() {
        return status;
    }

    @NotNull
    public final Map<CosmeticIdentifier, Pair<byte[], Integer>> getByteData() {
        return byteData;
    }

    @NotNull
    public final Map<CosmeticIdentifier, Cosmetic> getCosmetics() {
        for (CosmeticIdentifier id : cosmetics.keySet()) {
            Cosmetic cosmetic;
            Pair<byte[], Integer> data;
            if (status.get(id) != DownloadStatus.LOADED) continue;
            status.put(id, DownloadStatus.REGISTER_IN_PROGRESS);
            if (byteData.get(id) == null || this.loadCosmeticFromByteArray(id, (byte[])data.getFirst(), ((Number)data.getSecond()).intValue()) == null) continue;
            cosmetics.put(id, cosmetic);
            status.put(id, DownloadStatus.COMPLETED);
        }
        return cosmetics;
    }

    @NotNull
    public final StringMapSetting getSelected() {
        return selected;
    }

    @NotNull
    public final BooleanSetting getElytra() {
        return elytra;
    }

    @NotNull
    public final DownloadStatus getStatus(@NotNull CosmeticIdentifier identifier) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        return status.getOrDefault(identifier, DownloadStatus.NOT_STARTED);
    }

    public final void downloadCosmetic(@NotNull CosmeticIdentifier cosmetic, @NotNull String path, int frames) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)cosmetic, (String)"cosmetic");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        boolean $i$f$catch = false;
        try {
            boolean bl = false;
            INSTANCE.downloadFile("https://raw.githubusercontent.com/bewisclient-team/BewisclientWebsite/refs/heads/main/cosmetics/" + path, (Function1<byte[], Unit>)((Function1)arg_0 -> CosmeticLoader.downloadCosmetic$lambda$1$lambda$0(cosmetic, path, frames, arg_0)));
            unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            unit = null;
        }
        if (unit == null) {
            CosmeticLoader $this$downloadCosmetic_u24lambda_u242 = this;
            boolean bl = false;
            status.put(cosmetic, DownloadStatus.FAILED);
        }
    }

    public final void loadCosmetic(@NotNull CosmeticIdentifier cosmetic, @NotNull String hash, int frames) {
        Intrinsics.checkNotNullParameter((Object)cosmetic, (String)"cosmetic");
        Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
        if (this.getStatus(cosmetic) == DownloadStatus.NOT_STARTED) {
            status.put(cosmetic, DownloadStatus.IN_PROGRESS);
            byte[] byArray = this.checkCosmetic(cosmetic.getType(), cosmetic.getId() + (frames > 1 ? ".gif" : ".png"), hash);
            if (byArray == null) {
                CosmeticLoader $this$loadCosmetic_u24lambda_u243 = this;
                boolean bl = false;
                $this$loadCosmetic_u24lambda_u243.downloadCosmetic(cosmetic, cosmetic.getType() + "/" + cosmetic.getId() + (frames > 1 ? ".gif" : ".png"), frames);
                return;
            }
            byte[] data = byArray;
            byteData.put(cosmetic, (Pair<byte[], Integer>)TuplesKt.to((Object)data, (Object)frames));
            status.put(cosmetic, DownloadStatus.LOADED);
        }
    }

    @Nullable
    public final Cosmetic loadCosmeticFromByteArray(@NotNull CosmeticIdentifier identifier, @NotNull byte[] data, int frames) {
        Cosmetic cosmetic;
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (frames > 1) {
            AnimatedCosmetic animatedCosmetic;
            boolean $i$f$catch = false;
            try {
                boolean bl = false;
                animatedCosmetic = AnimatedCosmetic.Companion.create(identifier, data, frames);
            }
            catch (Throwable throwable) {
                animatedCosmetic = null;
            }
            cosmetic = animatedCosmetic;
        } else {
            StaticCosmetic staticCosmetic;
            boolean $i$f$catch = false;
            try {
                boolean bl = false;
                staticCosmetic = StaticCosmetic.Companion.create(identifier, data);
            }
            catch (Throwable throwable) {
                staticCosmetic = null;
            }
            cosmetic = staticCosmetic;
        }
        return cosmetic;
    }

    @Nullable
    public final byte[] checkCosmetic(@NotNull CosmeticType type, @NotNull String path, @NotNull String hash) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
        String[] stringArray = new String[]{"bewisclient", "server", type.getId() + "/" + path};
        byte[] byArray = this.readRelativeFileBytes(stringArray);
        if (byArray == null) {
            return null;
        }
        byte[] data = byArray;
        return (byte[])(this.checkHash(data, hash) ? data : null);
    }

    public final boolean checkHash(@NotNull byte[] data, @NotNull String hash) {
        Boolean bl;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
        boolean $i$f$catch = false;
        try {
            boolean bl2 = false;
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            Base64 base64 = (Base64)Base64.Default;
            byte[] byArray = digest.digest(data);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"digest(...)");
            String computedHash = Base64.encode$default((Base64)base64, (byte[])byArray, (int)0, (int)0, (int)6, null);
            bl = StringsKt.equals((String)computedHash, (String)hash, (boolean)true);
        }
        catch (Throwable throwable) {
            bl = null;
        }
        Boolean bl3 = bl;
        return bl3 != null ? bl3 : false;
    }

    @Override
    public void onInitializeClient() {
        class_156.method_27958().execute(CosmeticLoader::onInitializeClient$lambda$14);
    }

    @Override
    public void onMinecraftClientInitFinished() {
        Map<CosmeticIdentifier, Pair<byte[], Integer>> $this$forEach$iv = byteData;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<CosmeticIdentifier, Pair<byte[], Integer>>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Cosmetic cosmetic;
            Map.Entry<CosmeticIdentifier, Pair<byte[], Integer>> element$iv;
            Map.Entry<CosmeticIdentifier, Pair<byte[], Integer>> it = element$iv = iterator2.next();
            boolean bl = false;
            if (status.get(it.getKey()) != DownloadStatus.LOADED) continue;
            status.put(it.getKey(), DownloadStatus.REGISTER_IN_PROGRESS);
            if (INSTANCE.loadCosmeticFromByteArray(it.getKey(), (byte[])it.getValue().getFirst(), ((Number)it.getValue().getSecond()).intValue()) == null) continue;
            INSTANCE.getCosmetics().put(it.getKey(), cosmetic);
            status.put(it.getKey(), DownloadStatus.COMPLETED);
        }
    }

    @Nullable
    public final class_640 getEntityBySkinTextures(int hashCode) {
        Object v1;
        block2: {
            class_310 client = class_310.method_1551();
            Object object = client.method_1562();
            if (object == null || (object = object.method_2880()) == null) {
                return null;
            }
            Object playerList = object;
            Iterable $this$firstOrNull$iv = (Iterable)playerList;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                class_640 it = (class_640)element$iv;
                boolean bl = false;
                if (!(it.method_52810().hashCode() == hashCode)) continue;
                v1 = element$iv;
                break block2;
            }
            v1 = null;
        }
        return v1;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Nullable
    public final Cosmetic getCosmeticForPlayer(@NotNull GameProfile player, @NotNull CosmeticType type) {
        block6: {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            v0 /* !! */  = this.getClient().field_1687;
            if (v0 /* !! */  == null || (v0 /* !! */  = v0 /* !! */ .method_18456()) == null) ** GOTO lbl-1000
            $this$firstOrNull$iv = (Iterable)v0 /* !! */ ;
            $i$f$firstOrNull = false;
            for (T element$iv : $this$firstOrNull$iv) {
                it = (class_742)element$iv;
                $i$a$-firstOrNull-CosmeticLoader$getCosmeticForPlayer$elytraEquipped$1 = false;
                if (!Intrinsics.areEqual((Object)it.method_7334().getId(), (Object)player.getId())) continue;
                v1 = element$iv;
                break block6;
            }
            v1 = null;
        }
        if ((v0 /* !! */  = (class_742)v1) != null && (v0 /* !! */  = v0 /* !! */ .method_31548()) != null && (v0 /* !! */  = v0 /* !! */ .method_5438(38)) != null) {
            v2 = v0 /* !! */ .method_7909();
        } else lbl-1000:
        // 2 sources

        {
            v2 = null;
        }
        v3 = elytraEquipped = Intrinsics.areEqual(v2, (Object)class_1802.field_8833) != false && type == CosmeticType.CAPE;
        if (!Intrinsics.areEqual((Object)player.getId(), (Object)this.getClient().method_53462().getId()) || elytraEquipped && !((Boolean)CosmeticLoader.elytra.get()).booleanValue()) {
            return null;
        }
        v4 = (String)CosmeticLoader.selected.get(type.getId());
        if (v4 == null) {
            return null;
        }
        id = new CosmeticIdentifier(type, v4);
        if (!CosmeticLoader.allowedCosmetics.contains(id) || elytraEquipped && !CosmeticLoader.elytraCosmetics.contains(id)) {
            return null;
        }
        return this.getCosmetics().getOrDefault(id, null);
    }

    @Override
    public void onDatagen() {
        EventEntrypoint.super.onDatagen();
    }

    @Override
    public void onResourcesReloaded() {
        EventEntrypoint.super.onResourcesReloaded();
    }

    private static final Unit downloadCosmetic$lambda$1$lambda$0(CosmeticIdentifier $cosmetic, String $path, int $frames, byte[] it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        status.put($cosmetic, DownloadStatus.LOADED);
        String[] stringArray = new String[]{"bewisclient", "server", $path};
        INSTANCE.saveRelativeFile(it, stringArray);
        byteData.put($cosmetic, (Pair<byte[], Integer>)TuplesKt.to((Object)it, (Object)$frames));
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void onInitializeClient$lambda$14() {
        CosmeticEntry it;
        CosmeticEntry element$iv;
        int n;
        Object[] $i$a$-catch-CosmeticLoader$onInitializeClient$1$result$22;
        boolean $i$f$catch = false;
        try {
            boolean $i$a$-catch-CosmeticLoader$onInitializeClient$1$result$22 = false;
            Object object = new URI("https://bewisclient.deno.dev/api/on_launch").toURL().openConnection();
            HttpURLConnection httpURLConnection = object instanceof HttpURLConnection ? (HttpURLConnection)object : null;
            if (httpURLConnection == null) {
                return;
            }
            HttpURLConnection connection = httpURLConnection;
            connection.setRequestMethod("POST");
            connection.setDoOutput(true);
            byte[] byArray = ("{\"uuid\":\"" + class_310.method_1551().method_53462().getId() + "\"}").getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            byte[] out = byArray;
            connection.setFixedLengthStreamingMode(out.length);
            connection.connect();
            object = connection.getOutputStream();
            String[] stringArray = null;
            try {
                OutputStream it2 = (OutputStream)object;
                boolean bl = false;
                it2.write(out);
                it2 = Unit.INSTANCE;
            }
            catch (Throwable bl) {
                stringArray = bl;
                throw bl;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)stringArray);
            }
            byte[] res = connection.getInputStream().readAllBytes();
            Intrinsics.checkNotNull((Object)res);
            stringArray = new String[]{"bewisclient", "server", "data.json"};
            INSTANCE.saveRelativeFile(res, stringArray);
            $i$a$-catch-CosmeticLoader$onInitializeClient$1$result$22 = res;
        }
        catch (Throwable throwable) {
            $i$a$-catch-CosmeticLoader$onInitializeClient$1$result$22 = null;
        }
        Object[] objectArray = $i$a$-catch-CosmeticLoader$onInitializeClient$1$result$22;
        if ($i$a$-catch-CosmeticLoader$onInitializeClient$1$result$22 == null) {
            $i$a$-catch-CosmeticLoader$onInitializeClient$1$result$22 = new String[]{"bewisclient", "server", "data.json"};
            byte[] byArray = INSTANCE.readRelativeFileBytes((String[])$i$a$-catch-CosmeticLoader$onInitializeClient$1$result$22);
            objectArray = byArray;
            if (byArray == null) {
                return;
            }
        }
        String[] result = objectArray;
        CosmeticData data = (CosmeticData)new Gson().fromJson(StringsKt.decodeToString((byte[])result), CosmeticData.class);
        CosmeticEntry[] $this$forEach$iv = data.getCosmetics();
        boolean $i$f$forEach = false;
        int n2 = $this$forEach$iv.length;
        for (n = 0; n < n2; ++n) {
            CosmeticIdentifier element;
            block18: {
                block17: {
                    boolean bl;
                    block16: {
                        it = element$iv = $this$forEach$iv[n];
                        boolean bl2 = false;
                        if (it.getDefault()) break block17;
                        SpecialEntry[] $this$any$iv = data.getSpecials();
                        boolean $i$f$any = false;
                        int n3 = $this$any$iv.length;
                        for (int i = 0; i < n3; ++i) {
                            SpecialEntry element$iv2;
                            SpecialEntry a = element$iv2 = $this$any$iv[i];
                            boolean bl3 = false;
                            if (!(Intrinsics.areEqual((Object)a.getId(), (Object)it.getId()) && Intrinsics.areEqual((Object)a.getType(), (Object)it.getType()) && Intrinsics.areEqual((Object)a.getUuid(), (Object)INSTANCE.getClient().method_53462().getId().toString()))) continue;
                            bl = true;
                            break block16;
                        }
                        bl = false;
                    }
                    if (!bl) break block18;
                }
                if (it.getCosmetic() != null) {
                    CosmeticIdentifier element2;
                    boolean bl = false;
                    allowedCosmetics.add(element2);
                }
            }
            if (!it.getHas_elytra()) continue;
            if (it.getCosmetic() == null) continue;
            boolean bl = false;
            elytraCosmetics.add(element);
        }
        $this$forEach$iv = data.getCosmetics();
        $i$f$forEach = false;
        n2 = $this$forEach$iv.length;
        for (n = 0; n < n2; ++n) {
            it = element$iv = $this$forEach$iv[n];
            boolean bl = false;
            CosmeticIdentifier cosmeticIdentifier = it.getCosmetic();
            if (cosmeticIdentifier == null) continue;
            INSTANCE.loadCosmetic(cosmeticIdentifier, it.getHash(), it.getFrames());
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0012\b\u0086\b\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004\u00a2\u0006\u0004\b\t\u0010\nJ\u001a\u0010\r\u001a\u00020\f2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u0096\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0012\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\u0016\u0010\u0017J:\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004H\u00c6\u0001\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0010\u0010\u001a\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u001a\u0010\u0013R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001b\u001a\u0004\b\u001c\u0010\u0013R\u001d\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u001d\u001a\u0004\b\u001e\u0010\u0015R\u001d\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00048\u0006\u00a2\u0006\f\n\u0004\b\b\u0010\u001f\u001a\u0004\b \u0010\u0017\u00a8\u0006!"}, d2={"Lnet/bewis09/bewisclient/cosmetics/CosmeticLoader$CosmeticData;", "", "", "base_url", "", "Lnet/bewis09/bewisclient/cosmetics/CosmeticLoader$CosmeticEntry;", "cosmetics", "Lnet/bewis09/bewisclient/cosmetics/CosmeticLoader$SpecialEntry;", "specials", "<init>", "(Ljava/lang/String;[Lnet/bewis09/bewisclient/cosmetics/CosmeticLoader$CosmeticEntry;[Lnet/bewis09/bewisclient/cosmetics/CosmeticLoader$SpecialEntry;)V", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "component1", "()Ljava/lang/String;", "component2", "()[Lnet/bewis09/bewisclient/cosmetics/CosmeticLoader$CosmeticEntry;", "component3", "()[Lnet/bewis09/bewisclient/cosmetics/CosmeticLoader$SpecialEntry;", "copy", "(Ljava/lang/String;[Lnet/bewis09/bewisclient/cosmetics/CosmeticLoader$CosmeticEntry;[Lnet/bewis09/bewisclient/cosmetics/CosmeticLoader$SpecialEntry;)Lnet/bewis09/bewisclient/cosmetics/CosmeticLoader$CosmeticData;", "toString", "Ljava/lang/String;", "getBase_url", "[Lnet/bewis09/bewisclient/cosmetics/CosmeticLoader$CosmeticEntry;", "getCosmetics", "[Lnet/bewis09/bewisclient/cosmetics/CosmeticLoader$SpecialEntry;", "getSpecials", "bewisclient_client"})
    @Environment(value=EnvType.CLIENT)
    public static final class CosmeticData {
        @NotNull
        private final String base_url;
        @NotNull
        private final CosmeticEntry[] cosmetics;
        @NotNull
        private final SpecialEntry[] specials;

        public CosmeticData(@NotNull String base_url, @NotNull CosmeticEntry[] cosmetics, @NotNull SpecialEntry[] specials) {
            Intrinsics.checkNotNullParameter((Object)base_url, (String)"base_url");
            Intrinsics.checkNotNullParameter((Object)cosmetics, (String)"cosmetics");
            Intrinsics.checkNotNullParameter((Object)specials, (String)"specials");
            this.base_url = base_url;
            this.cosmetics = cosmetics;
            this.specials = specials;
        }

        @NotNull
        public final String getBase_url() {
            return this.base_url;
        }

        @NotNull
        public final CosmeticEntry[] getCosmetics() {
            return this.cosmetics;
        }

        @NotNull
        public final SpecialEntry[] getSpecials() {
            return this.specials;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            Object object = other;
            if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
                return false;
            }
            Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type net.bewis09.bewisclient.cosmetics.CosmeticLoader.CosmeticData");
            CosmeticData cfr_ignored_0 = (CosmeticData)other;
            if (!Intrinsics.areEqual((Object)this.base_url, (Object)((CosmeticData)other).base_url)) {
                return false;
            }
            if (!Arrays.equals(this.cosmetics, ((CosmeticData)other).cosmetics)) {
                return false;
            }
            return Arrays.equals(this.specials, ((CosmeticData)other).specials);
        }

        public int hashCode() {
            int result = this.base_url.hashCode();
            result = 31 * result + Arrays.hashCode(this.cosmetics);
            result = 31 * result + Arrays.hashCode(this.specials);
            return result;
        }

        @NotNull
        public final String component1() {
            return this.base_url;
        }

        @NotNull
        public final CosmeticEntry[] component2() {
            return this.cosmetics;
        }

        @NotNull
        public final SpecialEntry[] component3() {
            return this.specials;
        }

        @NotNull
        public final CosmeticData copy(@NotNull String base_url, @NotNull CosmeticEntry[] cosmetics, @NotNull SpecialEntry[] specials) {
            Intrinsics.checkNotNullParameter((Object)base_url, (String)"base_url");
            Intrinsics.checkNotNullParameter((Object)cosmetics, (String)"cosmetics");
            Intrinsics.checkNotNullParameter((Object)specials, (String)"specials");
            return new CosmeticData(base_url, cosmetics, specials);
        }

        public static /* synthetic */ CosmeticData copy$default(CosmeticData cosmeticData, String string, CosmeticEntry[] cosmeticEntryArray, SpecialEntry[] specialEntryArray, int n, Object object) {
            if ((n & 1) != 0) {
                string = cosmeticData.base_url;
            }
            if ((n & 2) != 0) {
                cosmeticEntryArray = cosmeticData.cosmetics;
            }
            if ((n & 4) != 0) {
                specialEntryArray = cosmeticData.specials;
            }
            return cosmeticData.copy(string, cosmeticEntryArray, specialEntryArray);
        }

        @NotNull
        public String toString() {
            return "CosmeticData(base_url=" + this.base_url + ", cosmetics=" + Arrays.toString(this.cosmetics) + ", specials=" + Arrays.toString(this.specials) + ")";
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u001c\b\u0086\b\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\u000e\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0010\u0010\u0010\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0012\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0012\u0010\u0011J\u0010\u0010\u0013\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0013\u0010\u0011J\u0010\u0010\u0014\u001a\u00020\u0006H\u00c6\u0003\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0010\u0010\u0016\u001a\u00020\bH\u00c6\u0003\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0010\u0010\u0018\u001a\u00020\bH\u00c6\u0003\u00a2\u0006\u0004\b\u0018\u0010\u0017JL\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00022\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\n\u001a\u00020\bH\u00c6\u0001\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u001a\u0010\u001c\u001a\u00020\b2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0010\u0010\u001e\u001a\u00020\u0006H\u00d6\u0001\u00a2\u0006\u0004\b\u001e\u0010\u0015J\u0010\u0010\u001f\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u001f\u0010\u0011R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010 \u001a\u0004\b!\u0010\u0011R\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010 \u001a\u0004\b\"\u0010\u0011R\u0017\u0010\u0005\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010 \u001a\u0004\b#\u0010\u0011R\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010$\u001a\u0004\b%\u0010\u0015R\u0017\u0010\t\u001a\u00020\b8\u0006\u00a2\u0006\f\n\u0004\b\t\u0010&\u001a\u0004\b'\u0010\u0017R\u0017\u0010\n\u001a\u00020\b8\u0006\u00a2\u0006\f\n\u0004\b\n\u0010&\u001a\u0004\b(\u0010\u0017\u00a8\u0006)"}, d2={"Lnet/bewis09/bewisclient/cosmetics/CosmeticLoader$CosmeticEntry;", "", "", "id", "type", "hash", "", "frames", "", "default", "has_elytra", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;IZZ)V", "Lnet/bewis09/bewisclient/cosmetics/CosmeticIdentifier;", "getCosmetic", "()Lnet/bewis09/bewisclient/cosmetics/CosmeticIdentifier;", "component1", "()Ljava/lang/String;", "component2", "component3", "component4", "()I", "component5", "()Z", "component6", "copy", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;IZZ)Lnet/bewis09/bewisclient/cosmetics/CosmeticLoader$CosmeticEntry;", "other", "equals", "(Ljava/lang/Object;)Z", "hashCode", "toString", "Ljava/lang/String;", "getId", "getType", "getHash", "I", "getFrames", "Z", "getDefault", "getHas_elytra", "bewisclient_client"})
    @Environment(value=EnvType.CLIENT)
    @SourceDebugExtension(value={"SMAP\nCosmeticLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CosmeticLoader.kt\nnet/bewis09/bewisclient/cosmetics/CosmeticLoader$CosmeticEntry\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,211:1\n1#2:212\n*E\n"})
    public static final class CosmeticEntry {
        @NotNull
        private final String id;
        @NotNull
        private final String type;
        @NotNull
        private final String hash;
        private final int frames;
        private final boolean default;
        private final boolean has_elytra;

        public CosmeticEntry(@NotNull String id, @NotNull String type, @NotNull String hash, int frames, boolean bl, boolean has_elytra) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
            this.id = id;
            this.type = type;
            this.hash = hash;
            this.frames = frames;
            this.default = bl;
            this.has_elytra = has_elytra;
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        @NotNull
        public final String getType() {
            return this.type;
        }

        @NotNull
        public final String getHash() {
            return this.hash;
        }

        public final int getFrames() {
            return this.frames;
        }

        public final boolean getDefault() {
            return this.default;
        }

        public final boolean getHas_elytra() {
            return this.has_elytra;
        }

        @Nullable
        public final CosmeticIdentifier getCosmetic() {
            CosmeticIdentifier cosmeticIdentifier;
            CosmeticType cosmeticType = CosmeticType.Companion.fromId(this.type);
            if (cosmeticType != null) {
                CosmeticType it = cosmeticType;
                boolean bl = false;
                cosmeticIdentifier = new CosmeticIdentifier(it, this.id);
            } else {
                cosmeticIdentifier = null;
            }
            return cosmeticIdentifier;
        }

        @NotNull
        public final String component1() {
            return this.id;
        }

        @NotNull
        public final String component2() {
            return this.type;
        }

        @NotNull
        public final String component3() {
            return this.hash;
        }

        public final int component4() {
            return this.frames;
        }

        public final boolean component5() {
            return this.default;
        }

        public final boolean component6() {
            return this.has_elytra;
        }

        @NotNull
        public final CosmeticEntry copy(@NotNull String id, @NotNull String type, @NotNull String hash, int frames, boolean bl, boolean has_elytra) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
            return new CosmeticEntry(id, type, hash, frames, bl, has_elytra);
        }

        public static /* synthetic */ CosmeticEntry copy$default(CosmeticEntry cosmeticEntry, String string, String string2, String string3, int n, boolean bl, boolean bl2, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = cosmeticEntry.id;
            }
            if ((n2 & 2) != 0) {
                string2 = cosmeticEntry.type;
            }
            if ((n2 & 4) != 0) {
                string3 = cosmeticEntry.hash;
            }
            if ((n2 & 8) != 0) {
                n = cosmeticEntry.frames;
            }
            if ((n2 & 0x10) != 0) {
                bl = cosmeticEntry.default;
            }
            if ((n2 & 0x20) != 0) {
                bl2 = cosmeticEntry.has_elytra;
            }
            return cosmeticEntry.copy(string, string2, string3, n, bl, bl2);
        }

        @NotNull
        public String toString() {
            return "CosmeticEntry(id=" + this.id + ", type=" + this.type + ", hash=" + this.hash + ", frames=" + this.frames + ", default=" + this.default + ", has_elytra=" + this.has_elytra + ")";
        }

        public int hashCode() {
            int result = this.id.hashCode();
            result = result * 31 + this.type.hashCode();
            result = result * 31 + this.hash.hashCode();
            result = result * 31 + Integer.hashCode(this.frames);
            result = result * 31 + Boolean.hashCode(this.default);
            result = result * 31 + Boolean.hashCode(this.has_elytra);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CosmeticEntry)) {
                return false;
            }
            CosmeticEntry cosmeticEntry = (CosmeticEntry)other;
            if (!Intrinsics.areEqual((Object)this.id, (Object)cosmeticEntry.id)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.type, (Object)cosmeticEntry.type)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.hash, (Object)cosmeticEntry.hash)) {
                return false;
            }
            if (this.frames != cosmeticEntry.frames) {
                return false;
            }
            if (this.default != cosmeticEntry.default) {
                return false;
            }
            return this.has_elytra == cosmeticEntry.has_elytra;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\t\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lnet/bewis09/bewisclient/cosmetics/CosmeticLoader$DownloadStatus;", "", "<init>", "(Ljava/lang/String;I)V", "NOT_STARTED", "IN_PROGRESS", "LOADED", "FAILED", "REGISTER_IN_PROGRESS", "COMPLETED", "bewisclient_client"})
    @Environment(value=EnvType.CLIENT)
    public static final class DownloadStatus
    extends Enum<DownloadStatus> {
        public static final /* enum */ DownloadStatus NOT_STARTED = new DownloadStatus();
        public static final /* enum */ DownloadStatus IN_PROGRESS = new DownloadStatus();
        public static final /* enum */ DownloadStatus LOADED = new DownloadStatus();
        public static final /* enum */ DownloadStatus FAILED = new DownloadStatus();
        public static final /* enum */ DownloadStatus REGISTER_IN_PROGRESS = new DownloadStatus();
        public static final /* enum */ DownloadStatus COMPLETED = new DownloadStatus();
        private static final /* synthetic */ DownloadStatus[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static DownloadStatus[] values() {
            return (DownloadStatus[])$VALUES.clone();
        }

        public static DownloadStatus valueOf(String value) {
            return Enum.valueOf(DownloadStatus.class, value);
        }

        @NotNull
        public static EnumEntries<DownloadStatus> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = downloadStatusArray = new DownloadStatus[]{DownloadStatus.NOT_STARTED, DownloadStatus.IN_PROGRESS, DownloadStatus.LOADED, DownloadStatus.FAILED, DownloadStatus.REGISTER_IN_PROGRESS, DownloadStatus.COMPLETED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\n\u0010\tJ\u0010\u0010\u000b\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u000b\u0010\tJ.\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\f\u0010\rJ\u001a\u0010\u0010\u001a\u00020\u000f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0013\u001a\u00020\u0012H\u00d6\u0001\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0010\u0010\u0015\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u0015\u0010\tR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0016\u001a\u0004\b\u0017\u0010\tR\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0016\u001a\u0004\b\u0018\u0010\tR\u0017\u0010\u0005\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0016\u001a\u0004\b\u0019\u0010\t\u00a8\u0006\u001a"}, d2={"Lnet/bewis09/bewisclient/cosmetics/CosmeticLoader$SpecialEntry;", "", "", "id", "type", "uuid", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "component1", "()Ljava/lang/String;", "component2", "component3", "copy", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Lnet/bewis09/bewisclient/cosmetics/CosmeticLoader$SpecialEntry;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "toString", "Ljava/lang/String;", "getId", "getType", "getUuid", "bewisclient_client"})
    @Environment(value=EnvType.CLIENT)
    public static final class SpecialEntry {
        @NotNull
        private final String id;
        @NotNull
        private final String type;
        @NotNull
        private final String uuid;

        public SpecialEntry(@NotNull String id, @NotNull String type, @NotNull String uuid) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
            this.id = id;
            this.type = type;
            this.uuid = uuid;
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        @NotNull
        public final String getType() {
            return this.type;
        }

        @NotNull
        public final String getUuid() {
            return this.uuid;
        }

        @NotNull
        public final String component1() {
            return this.id;
        }

        @NotNull
        public final String component2() {
            return this.type;
        }

        @NotNull
        public final String component3() {
            return this.uuid;
        }

        @NotNull
        public final SpecialEntry copy(@NotNull String id, @NotNull String type, @NotNull String uuid) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
            return new SpecialEntry(id, type, uuid);
        }

        public static /* synthetic */ SpecialEntry copy$default(SpecialEntry specialEntry, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = specialEntry.id;
            }
            if ((n & 2) != 0) {
                string2 = specialEntry.type;
            }
            if ((n & 4) != 0) {
                string3 = specialEntry.uuid;
            }
            return specialEntry.copy(string, string2, string3);
        }

        @NotNull
        public String toString() {
            return "SpecialEntry(id=" + this.id + ", type=" + this.type + ", uuid=" + this.uuid + ")";
        }

        public int hashCode() {
            int result = this.id.hashCode();
            result = result * 31 + this.type.hashCode();
            result = result * 31 + this.uuid.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SpecialEntry)) {
                return false;
            }
            SpecialEntry specialEntry = (SpecialEntry)other;
            if (!Intrinsics.areEqual((Object)this.id, (Object)specialEntry.id)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.type, (Object)specialEntry.type)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.uuid, (Object)specialEntry.uuid);
        }
    }
}

