/*
 * Decompiled with CFR 0.152.
 */
package net.bewis09.bewisclient.impl.widget;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.DataResult;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.bewis09.bewisclient.drawable.Renderable;
import net.bewis09.bewisclient.impl.widget.CustomWidget;
import net.bewis09.bewisclient.settings.types.BooleanSetting;
import net.bewis09.bewisclient.settings.types.ObjectSetting;
import net.bewis09.bewisclient.util.EventEntrypoint;
import net.bewis09.bewisclient.util.ExtensionUtilKt;
import net.bewis09.bewisclient.util.UtilKt;
import net.bewis09.bewisclient.widget.logic.SidedPosition;
import net.bewis09.bewisclient.widget.logic.WidgetPosition;
import net.bewis09.bewisclient.widget.types.LineWidget;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000f\u0010\u0006\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0004J\u000f\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0010\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u000fJ\u0015\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001d\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0016\u0010\u0017J\r\u0010\u0019\u001a\u00020\u0018\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u000f\u0010\u001c\u001a\u0004\u0018\u00010\u001b\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u001d\u0010!\u001a\u00020\u00052\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0016\u00a2\u0006\u0004\b!\u0010\"J\u000f\u0010#\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b#\u0010$J\r\u0010%\u001a\u00020\u0018\u00a2\u0006\u0004\b%\u0010\u001aJ\u0015\u0010(\u001a\b\u0012\u0004\u0012\u00020'0&H\u0016\u00a2\u0006\u0004\b(\u0010)R3\u0010,\u001a\u001e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u001b0*j\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u001b`+8\u0006\u00a2\u0006\f\n\u0004\b,\u0010-\u001a\u0004\b.\u0010/R\"\u00101\u001a\u0002008\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b1\u00102\u001a\u0004\b3\u00104\"\u0004\b5\u00106R\u001a\u00107\u001a\u00020\u001b8\u0014X\u0094D\u00a2\u0006\f\n\u0004\b7\u00108\u001a\u0004\b9\u0010\u001dR\u001a\u0010:\u001a\u00020\u001b8\u0014X\u0094D\u00a2\u0006\f\n\u0004\b:\u00108\u001a\u0004\b;\u0010\u001d\u00a8\u0006<"}, d2={"Lnet/bewis09/bewisclient/impl/widget/BiomeWidget;", "Lnet/bewis09/bewisclient/widget/types/LineWidget;", "Lnet/bewis09/bewisclient/util/EventEntrypoint;", "<init>", "()V", "", "onResourcesReloaded", "Lnet/minecraft/class_2561;", "getLine", "()Lnet/minecraft/class_2561;", "Lnet/bewis09/bewisclient/widget/logic/WidgetPosition;", "defaultPosition", "()Lnet/bewis09/bewisclient/widget/logic/WidgetPosition;", "", "getMinimumWidth", "()I", "getMaximumWidth", "", "colorCoded", "getText", "(Z)Lnet/minecraft/class_2561;", "text", "applyColor", "(Lnet/minecraft/class_2561;Z)Lnet/minecraft/class_2561;", "Lnet/minecraft/class_2960;", "getBiomeID", "()Lnet/minecraft/class_2960;", "", "getBiomeString", "()Ljava/lang/String;", "Ljava/util/ArrayList;", "Lnet/bewis09/bewisclient/drawable/Renderable;", "list", "appendSettingsRenderables", "(Ljava/util/ArrayList;)V", "isEnabledByDefault", "()Z", "getBiomeByMonth", "", "Lnet/bewis09/bewisclient/impl/widget/CustomWidget$WidgetStringData;", "getCustomWidgetDataPoints", "()Ljava/util/List;", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "biomeCodes", "Ljava/util/HashMap;", "getBiomeCodes", "()Ljava/util/HashMap;", "Lnet/bewis09/bewisclient/settings/types/BooleanSetting;", "colorCodeBiome", "Lnet/bewis09/bewisclient/settings/types/BooleanSetting;", "getColorCodeBiome", "()Lnet/bewis09/bewisclient/settings/types/BooleanSetting;", "setColorCodeBiome", "(Lnet/bewis09/bewisclient/settings/types/BooleanSetting;)V", "title", "Ljava/lang/String;", "getTitle", "description", "getDescription", "bewisclient_client"})
@Environment(value=EnvType.CLIENT)
@SourceDebugExtension(value={"SMAP\nBiomeWidget.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BiomeWidget.kt\nnet/bewis09/bewisclient/impl/widget/BiomeWidget\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Util.kt\nnet/bewis09/bewisclient/util/UtilKt\n*L\n1#1,112:1\n1869#2:113\n1869#2:114\n1869#2,2:117\n1870#2:122\n1870#2:123\n8#3,2:115\n10#3,3:119\n8#3,5:124\n*S KotlinDebug\n*F\n+ 1 BiomeWidget.kt\nnet/bewis09/bewisclient/impl/widget/BiomeWidget\n*L\n33#1:113\n34#1:114\n37#1:117,2\n34#1:122\n33#1:123\n35#1:115,2\n35#1:119,3\n51#1:124,5\n*E\n"})
public final class BiomeWidget
extends LineWidget
implements EventEntrypoint {
    @NotNull
    public static final BiomeWidget INSTANCE = new BiomeWidget();
    @NotNull
    private static final HashMap<class_2960, String> biomeCodes = new HashMap();
    @NotNull
    private static BooleanSetting colorCodeBiome = ObjectSetting.boolean$default(INSTANCE, "color_code_biome", true, null, 4, null);
    @NotNull
    private static final String title = "Biome Widget";
    @NotNull
    private static final String description = "Displays the current biome at your position.";

    private BiomeWidget() {
        super(UtilKt.createIdentifier("bewisclient", "biome_widget"));
    }

    @NotNull
    public final HashMap<class_2960, String> getBiomeCodes() {
        return biomeCodes;
    }

    @NotNull
    public final BooleanSetting getColorCodeBiome() {
        return colorCodeBiome;
    }

    public final void setColorCodeBiome(@NotNull BooleanSetting booleanSetting) {
        Intrinsics.checkNotNullParameter((Object)booleanSetting, (String)"<set-?>");
        colorCodeBiome = booleanSetting;
    }

    @Override
    @NotNull
    protected String getTitle() {
        return title;
    }

    @Override
    @NotNull
    protected String getDescription() {
        return description;
    }

    @Override
    public void onResourcesReloaded() {
        biomeCodes.clear();
        Map<class_2960, List<class_3298>> resources = this.getUtil().findAllResources("bewisclient/biome_codes", BiomeWidget::onResourcesReloaded$lambda$0);
        Iterable $this$forEach$iv = resources.entrySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry it = (Map.Entry)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = (Iterable)it.getValue();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Unit unit;
                class_3298 resource = (class_3298)element$iv2;
                boolean bl2 = false;
                boolean $i$f$catch = false;
                try {
                    Unit unit2;
                    boolean bl3 = false;
                    if (((JsonElement)new Gson().fromJson((Reader)resource.method_43039(), JsonElement.class)).getAsJsonObject() != null) {
                        JsonObject jsonObject;
                        boolean bl4 = false;
                        Set set = jsonObject.keySet();
                        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"keySet(...)");
                        Iterable $this$forEach$iv3 = set;
                        boolean $i$f$forEach3 = false;
                        for (Object element$iv3 : $this$forEach$iv3) {
                            String key = (String)element$iv3;
                            boolean bl5 = false;
                            JsonElement biomeCode = jsonObject.get(key);
                            if (biomeCode.isJsonPrimitive()) {
                                Map map = biomeCodes;
                                Intrinsics.checkNotNull((Object)key);
                                map.put(UtilKt.createIdentifier(key), biomeCode.getAsString());
                                continue;
                            }
                            Object[] objectArray = new Object[]{"Invalid biome code format for " + key + " in " + it.getKey()};
                            INSTANCE.warn(objectArray);
                        }
                        unit2 = Unit.INSTANCE;
                    } else {
                        unit2 = null;
                    }
                    unit = unit2;
                }
                catch (Throwable throwable) {
                    unit = null;
                }
                if (unit != null) continue;
                Object[] objectArray = new Object[]{"Invalid biome code JSON format in " + it.getKey()};
                INSTANCE.warn(objectArray);
            }
        }
    }

    @Override
    @NotNull
    public class_2561 getLine() {
        class_2561 class_25612;
        boolean $i$f$catch = false;
        try {
            boolean bl = false;
            class_25612 = INSTANCE.getText((Boolean)colorCodeBiome.get());
        }
        catch (Throwable throwable) {
            class_25612 = null;
        }
        class_2561 class_25613 = class_25612;
        class_2561 class_25614 = class_25613;
        if (class_25613 == null) {
            class_25614 = (class_2561)ExtensionUtilKt.toText("Error");
        }
        return class_25614;
    }

    @Override
    @NotNull
    public WidgetPosition defaultPosition() {
        return new SidedPosition(5, 5, SidedPosition.Companion.getSTART(), SidedPosition.Companion.getEND());
    }

    @Override
    public int getMinimumWidth() {
        return 140;
    }

    @Override
    public int getMaximumWidth() {
        return 200;
    }

    @NotNull
    public final class_2561 getText(boolean colorCoded) {
        class_5250 class_52502 = class_2561.method_43471((String)this.getBiomeID().method_42093("biome"));
        Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"translatable(...)");
        return this.applyColor((class_2561)class_52502, colorCoded);
    }

    @NotNull
    public final class_2561 applyColor(@NotNull class_2561 text, boolean colorCoded) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (!colorCoded) {
            return text;
        }
        class_2960 biome = this.getBiomeID();
        String string = biomeCodes.get(biome);
        if (string == null) {
            return text;
        }
        DataResult color = class_5251.method_27719((String)string);
        if (color.isSuccess()) {
            return (class_2561)ExtensionUtilKt.setColor(text, ((class_5251)color.getOrThrow()).method_27716());
        }
        return text;
    }

    @NotNull
    public final class_2960 getBiomeID() {
        class_2960 class_29602;
        if (this.getUtil().isInWorld()) {
            String string = this.getBiomeString();
            if (string == null) {
                string = "minecraft:plains";
            }
            class_29602 = UtilKt.createIdentifier(string);
        } else {
            class_29602 = this.getBiomeByMonth();
        }
        return class_29602;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final String getBiomeString() {
        class_6880 class_68802;
        class_638 class_6382 = class_310.method_1551().field_1687;
        if (class_6382 == null) return null;
        class_1297 class_12972 = class_310.method_1551().field_1719;
        if (class_12972 == null || (class_12972 = class_12972.method_24515()) == null) {
            class_12972 = new class_2338(0, 0, 0);
        }
        if ((class_68802 = class_6382.method_23753((class_2338)class_12972)) == null) return null;
        Either either = class_68802.method_40229();
        if (either == null) return null;
        String string = (String)either.map(arg_0 -> BiomeWidget.getBiomeString$lambda$8(BiomeWidget::getBiomeString$lambda$7, arg_0), null);
        return string;
    }

    @Override
    public void appendSettingsRenderables(@NotNull ArrayList<Renderable> list) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        list.add(BooleanSetting.createRenderable$default(colorCodeBiome, "widget.color_code_biome", "Color Code Biome", null, 4, null));
        super.appendSettingsRenderables(list);
    }

    @Override
    public boolean isEnabledByDefault() {
        return false;
    }

    @NotNull
    public final class_2960 getBiomeByMonth() {
        return switch (Calendar.getInstance().get(2)) {
            case 0 -> UtilKt.createIdentifier("minecraft:snowy_plains");
            case 1 -> UtilKt.createIdentifier("minecraft:ice_spikes");
            case 2 -> UtilKt.createIdentifier("minecraft:swamp");
            case 3 -> UtilKt.createIdentifier("minecraft:flower_forest");
            case 4 -> UtilKt.createIdentifier("minecraft:forest");
            case 5 -> UtilKt.createIdentifier("minecraft:plains");
            case 6 -> UtilKt.createIdentifier("minecraft:sunflower_plains");
            case 7 -> UtilKt.createIdentifier("minecraft:beach");
            case 8 -> UtilKt.createIdentifier("minecraft:wooded_badlands");
            case 9 -> UtilKt.createIdentifier("minecraft:dark_forest");
            case 10 -> UtilKt.createIdentifier("minecraft:old_growth_spruce_taiga");
            case 11 -> UtilKt.createIdentifier("minecraft:taiga");
            default -> UtilKt.createIdentifier("minecraft:plains");
        };
    }

    @Override
    @NotNull
    public List<CustomWidget.WidgetStringData> getCustomWidgetDataPoints() {
        Object[] objectArray = new CustomWidget.WidgetStringData[]{new CustomWidget.WidgetStringData("biome_name", "Biome Name", "The name of the biome you are currently in", (Function1<? super String, ? extends class_2561>)((Function1)BiomeWidget::getCustomWidgetDataPoints$lambda$9), "\"colored\" to color code the biome name"), new CustomWidget.WidgetStringData("biome_id", "Biome ID", "The ID of the biome you are currently in", (Function1<? super String, ? extends class_2561>)((Function1)BiomeWidget::getCustomWidgetDataPoints$lambda$10), "\"colored\" to color code the biome name")};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    public void onInitializeClient() {
        EventEntrypoint.super.onInitializeClient();
    }

    @Override
    public void onMinecraftClientInitFinished() {
        EventEntrypoint.super.onMinecraftClientInitFinished();
    }

    @Override
    public void onDatagen() {
        EventEntrypoint.super.onDatagen();
    }

    private static final boolean onResourcesReloaded$lambda$0(class_2960 it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.method_12832();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        return StringsKt.endsWith$default((String)string, (String)".json", (boolean)false, (int)2, null);
    }

    private static final String getBiomeString$lambda$7(class_5321 biomeKey) {
        Intrinsics.checkNotNullParameter((Object)biomeKey, (String)"biomeKey");
        return biomeKey.method_29177().toString();
    }

    private static final String getBiomeString$lambda$8(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final class_2561 getCustomWidgetDataPoints$lambda$9(String color) {
        return INSTANCE.getText(Intrinsics.areEqual((Object)color, (Object)"colored"));
    }

    private static final class_2561 getCustomWidgetDataPoints$lambda$10(String color) {
        String string = INSTANCE.getBiomeID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return INSTANCE.applyColor((class_2561)ExtensionUtilKt.toText(string), Intrinsics.areEqual((Object)color, (Object)"colored"));
    }
}

