/*
 * Decompiled with CFR 0.152.
 */
package net.bewis09.bewisclient.drawable;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 02\u00020\u0001:\u00010Bf\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012#\b\u0002\u0010\n\u001a\u001d\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\u00060\u0005\u0012*\u0010\u000e\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00060\f0\u000b\"\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00060\f\u00a2\u0006\u0004\b\u000f\u0010\u0010Bb\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012#\b\u0002\u0010\n\u001a\u001d\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\u00060\u0005\u0012*\u0010\u000e\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00060\f0\u000b\"\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00060\f\u00a2\u0006\u0004\b\u000f\u0010\u0011J\r\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0015\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\r\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0018\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\rH\u0086\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0017J \u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u0006H\u0086\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ2\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\r2\u0018\u0010\u0019\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00020\fH\u0086\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001cJ+\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u00062\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00120\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001eR\u001d\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u001f\u001a\u0004\b \u0010!R2\u0010\n\u001a\u001d\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\u00060\u00058\u0006\u00a2\u0006\f\n\u0004\b\n\u0010\"\u001a\u0004\b#\u0010$R0\u0010'\u001a\u001e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00060%j\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u0006`&8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b'\u0010(R0\u0010)\u001a\u001e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00030%j\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u0003`&8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b)\u0010(R0\u0010*\u001a\u001e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00060%j\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u0006`&8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b*\u0010(R<\u0010+\u001a*\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00020%j\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u0002`&8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b+\u0010(R&\u0010.\u001a\u0012\u0012\u0004\u0012\u00020\r0,j\b\u0012\u0004\u0012\u00020\r`-8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b.\u0010/\u00a8\u00061"}, d2={"Lnet/bewis09/bewisclient/drawable/Animator;", "", "Lkotlin/Function0;", "", "duration", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "delta", "interpolationType", "", "Lkotlin/Pair;", "", "initial", "<init>", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;[Lkotlin/Pair;)V", "(JLkotlin/jvm/functions/Function1;[Lkotlin/Pair;)V", "", "pauseForOnce", "()V", "key", "getWithoutInterpolation", "(Ljava/lang/String;)F", "get", "value", "set", "(Ljava/lang/String;F)V", "(Ljava/lang/String;Lkotlin/Pair;)V", "onFinish", "(Ljava/lang/String;FLkotlin/jvm/functions/Function0;)V", "Lkotlin/jvm/functions/Function0;", "getDuration", "()Lkotlin/jvm/functions/Function0;", "Lkotlin/jvm/functions/Function1;", "getInterpolationType", "()Lkotlin/jvm/functions/Function1;", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "map", "Ljava/util/HashMap;", "animationStartMap", "beforeAnimationMap", "finishMap", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "pauseAnimation", "Ljava/util/ArrayList;", "Companion", "bewisclient_client"})
@Environment(value=EnvType.CLIENT)
@SourceDebugExtension(value={"SMAP\nAnimator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Animator.kt\nnet/bewis09/bewisclient/drawable/Animator\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,122:1\n13805#2,2:123\n37#3,2:125\n*S KotlinDebug\n*F\n+ 1 Animator.kt\nnet/bewis09/bewisclient/drawable/Animator\n*L\n24#1:123,2\n41#1:125,2\n*E\n"})
public final class Animator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function0<Long> duration;
    @NotNull
    private final Function1<Float, Float> interpolationType;
    @NotNull
    private final HashMap<String, Float> map;
    @NotNull
    private final HashMap<String, Long> animationStartMap;
    @NotNull
    private final HashMap<String, Float> beforeAnimationMap;
    @NotNull
    private final HashMap<String, Function0<Unit>> finishMap;
    @NotNull
    private ArrayList<String> pauseAnimation;
    @NotNull
    private static final Function1<Float, Float> LINEAR = Animator::LINEAR$lambda$2;
    @NotNull
    private static final Function1<Float, Float> EASE_IN = Animator::EASE_IN$lambda$3;
    @NotNull
    private static final Function1<Float, Float> EASE_OUT = Animator::EASE_OUT$lambda$4;
    @NotNull
    private static final Function1<Float, Float> EASE_IN_OUT = Animator::EASE_IN_OUT$lambda$5;

    public Animator(@NotNull Function0<Long> duration, @NotNull Function1<? super Float, Float> interpolationType, Pair<String, Float> ... initial) {
        Intrinsics.checkNotNullParameter(duration, (String)"duration");
        Intrinsics.checkNotNullParameter(interpolationType, (String)"interpolationType");
        Intrinsics.checkNotNullParameter(initial, (String)"initial");
        this.duration = duration;
        this.interpolationType = interpolationType;
        this.map = new HashMap();
        this.animationStartMap = new HashMap();
        this.beforeAnimationMap = new HashMap();
        this.finishMap = new HashMap();
        this.pauseAnimation = new ArrayList();
        Pair<String, Float>[] $this$forEach$iv = initial;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            Pair<String, Float> element$iv;
            Pair<String, Float> pair = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            String key = (String)pair.component1();
            float value = ((Number)pair.component2()).floatValue();
            ((Map)this.map).put(key, Float.valueOf(value));
        }
    }

    public /* synthetic */ Animator(Function0 function0, Function1 function1, Pair[] pairArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            function1 = LINEAR;
        }
        this((Function0<Long>)function0, function1, pairArray);
    }

    @NotNull
    public final Function0<Long> getDuration() {
        return this.duration;
    }

    @NotNull
    public final Function1<Float, Float> getInterpolationType() {
        return this.interpolationType;
    }

    public Animator(long duration, @NotNull Function1<? super Float, Float> interpolationType, Pair<String, Float> ... initial) {
        Intrinsics.checkNotNullParameter(interpolationType, (String)"interpolationType");
        Intrinsics.checkNotNullParameter(initial, (String)"initial");
        this((Function0<Long>)((Function0)() -> Animator._init_$lambda$0(duration)), interpolationType, Arrays.copyOf(initial, initial.length));
    }

    public /* synthetic */ Animator(long l, Function1 function1, Pair[] pairArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            function1 = LINEAR;
        }
        this(l, function1, pairArray);
    }

    public final void pauseForOnce() {
        Set<String> set = this.map.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
        Collection $this$toTypedArray$iv = set;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        this.pauseAnimation = CollectionsKt.arrayListOf((Object[])Arrays.copyOf(stringArray, stringArray.length));
    }

    public final float getWithoutInterpolation(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Float f = this.map.get(key);
        if (f == null) {
            throw new IllegalStateException("Animation for key '" + key + "' has not been initialized");
        }
        return f.floatValue();
    }

    public final float get(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (this.pauseAnimation.contains(key)) {
            this.pauseAnimation.remove(key);
        }
        Long l = this.animationStartMap.get(key);
        float delta = (float)(System.currentTimeMillis() - (l != null ? l : 0L)) / (float)((Number)this.duration.invoke()).longValue();
        Float f = this.map.get(key);
        if (f == null) {
            throw new IllegalStateException("Animation for key '" + key + "' has not been initialized");
        }
        float value = f.floatValue();
        if (delta >= 1.0f) {
            Function0<Unit> finishAction = this.finishMap.get(key);
            this.finishMap.remove(key);
            Function0<Unit> function0 = finishAction;
            if (function0 != null) {
                function0.invoke();
            }
            return value;
        }
        Float f2 = this.beforeAnimationMap.get(key);
        if (f2 == null) {
            return value;
        }
        float beforeValue = f2.floatValue();
        if (delta <= 0.0f) {
            return beforeValue;
        }
        return beforeValue + (value - beforeValue) * ((Number)this.interpolationType.invoke((Object)Float.valueOf(delta))).floatValue();
    }

    public final void set(@NotNull String key, float value) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            boolean paused = this.pauseAnimation.contains(key);
            if (paused) {
                this.pauseAnimation.remove(key);
            }
            if (Intrinsics.areEqual((Float)this.map.get(key), (float)value)) {
                return;
            }
            float old = this.map.get(key) != null ? this.get(key) : value;
            ((Map)this.map).put(key, Float.valueOf(value));
            ((Map)this.animationStartMap).put(key, paused ? 0L : System.currentTimeMillis());
            ((Map)this.beforeAnimationMap).put(key, Float.valueOf(old));
            Function0<Unit> finishAction = this.finishMap.get(key);
            this.finishMap.remove(key);
            Function0<Unit> function0 = finishAction;
            if (function0 == null) break block2;
            function0.invoke();
        }
    }

    public final void set(@NotNull String key, @NotNull Pair<Float, ? extends Function0<Unit>> value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.set(key, ((Number)value.getFirst()).floatValue(), (Function0<Unit>)((Function0)value.getSecond()));
    }

    public final void set(@NotNull String key, float value, @NotNull Function0<Unit> onFinish) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(onFinish, (String)"onFinish");
        this.set(key, value);
        ((Map)this.finishMap).put(key, onFinish);
    }

    private static final long _init_$lambda$0(long $duration) {
        return $duration;
    }

    private static final float LINEAR$lambda$2(float delta) {
        return delta;
    }

    private static final float EASE_IN$lambda$3(float delta) {
        return delta * delta;
    }

    private static final float EASE_OUT$lambda$4(float delta) {
        return delta * ((float)2 - delta);
    }

    private static final float EASE_IN_OUT$lambda$5(float delta) {
        return delta < 0.5f ? (float)2 * delta * delta : (float)-1 + ((float)4 - (float)2 * delta) * delta;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u000b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R#\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0007\u001a\u0004\b\b\u0010\tR#\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00048\u0006\u00a2\u0006\f\n\u0004\b\n\u0010\u0007\u001a\u0004\b\u000b\u0010\tR#\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00048\u0006\u00a2\u0006\f\n\u0004\b\f\u0010\u0007\u001a\u0004\b\r\u0010\tR#\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00048\u0006\u00a2\u0006\f\n\u0004\b\u000e\u0010\u0007\u001a\u0004\b\u000f\u0010\t\u00a8\u0006\u0010"}, d2={"Lnet/bewis09/bewisclient/drawable/Animator$Companion;", "", "<init>", "()V", "Lkotlin/Function1;", "", "LINEAR", "Lkotlin/jvm/functions/Function1;", "getLINEAR", "()Lkotlin/jvm/functions/Function1;", "EASE_IN", "getEASE_IN", "EASE_OUT", "getEASE_OUT", "EASE_IN_OUT", "getEASE_IN_OUT", "bewisclient_client"})
    @Environment(value=EnvType.CLIENT)
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Function1<Float, Float> getLINEAR() {
            return LINEAR;
        }

        @NotNull
        public final Function1<Float, Float> getEASE_IN() {
            return EASE_IN;
        }

        @NotNull
        public final Function1<Float, Float> getEASE_OUT() {
            return EASE_OUT;
        }

        @NotNull
        public final Function1<Float, Float> getEASE_IN_OUT() {
            return EASE_IN_OUT;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

