/*
 * Decompiled with CFR 0.152.
 */
package net.bewis09.bewisclient.impl.widget;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import net.bewis09.bewisclient.drawable.Renderable;
import net.bewis09.bewisclient.game.Translation;
import net.bewis09.bewisclient.impl.widget.CustomWidget;
import net.bewis09.bewisclient.settings.types.BooleanSetting;
import net.bewis09.bewisclient.settings.types.Setting;
import net.bewis09.bewisclient.util.UtilKt;
import net.bewis09.bewisclient.widget.logic.RelativePosition;
import net.bewis09.bewisclient.widget.logic.WidgetPosition;
import net.bewis09.bewisclient.widget.types.LineWidget;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001b\u0010\u0010\u001a\u00020\n2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\u0004\b\u0010\u0010\u0011J'\u0010\u0016\u001a\u00020\u00152\u0016\u0010\u000f\u001a\u0012\u0012\u0004\u0012\u00020\u00130\u0012j\b\u0012\u0004\u0012\u00020\u0013`\u0014H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0015\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bR\u0017\u0010\u001d\u001a\u00020\u001c8\u0006\u00a2\u0006\f\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001f\u0010 R\u0017\u0010!\u001a\u00020\u001c8\u0006\u00a2\u0006\f\n\u0004\b!\u0010\u001e\u001a\u0004\b\"\u0010 R\u0017\u0010$\u001a\u00020#8\u0006\u00a2\u0006\f\n\u0004\b$\u0010%\u001a\u0004\b&\u0010'R\u0017\u0010(\u001a\u00020#8\u0006\u00a2\u0006\f\n\u0004\b(\u0010%\u001a\u0004\b)\u0010'R\u001d\u0010*\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8\u0006\u00a2\u0006\f\n\u0004\b*\u0010+\u001a\u0004\b,\u0010\u001bR\u001d\u0010-\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8\u0006\u00a2\u0006\f\n\u0004\b-\u0010+\u001a\u0004\b.\u0010\u001bR\u001a\u00100\u001a\u00020/8\u0014X\u0094D\u00a2\u0006\f\n\u0004\b0\u00101\u001a\u0004\b2\u00103R\u001a\u00104\u001a\u00020/8\u0014X\u0094D\u00a2\u0006\f\n\u0004\b4\u00101\u001a\u0004\b5\u00103\u00a8\u00066"}, d2={"Lnet/bewis09/bewisclient/impl/widget/CPSWidget;", "Lnet/bewis09/bewisclient/widget/types/LineWidget;", "<init>", "()V", "Lnet/minecraft/class_2561;", "getLine", "()Lnet/minecraft/class_2561;", "Lnet/bewis09/bewisclient/widget/logic/WidgetPosition;", "defaultPosition", "()Lnet/bewis09/bewisclient/widget/logic/WidgetPosition;", "", "getMinimumWidth", "()I", "", "", "list", "getCPSCount", "(Ljava/util/List;)I", "Ljava/util/ArrayList;", "Lnet/bewis09/bewisclient/drawable/Renderable;", "Lkotlin/collections/ArrayList;", "", "appendSettingsRenderables", "(Ljava/util/ArrayList;)V", "", "Lnet/bewis09/bewisclient/impl/widget/CustomWidget$WidgetStringData;", "getCustomWidgetDataPoints", "()Ljava/util/List;", "Lnet/bewis09/bewisclient/game/Translation;", "singleCPSText", "Lnet/bewis09/bewisclient/game/Translation;", "getSingleCPSText", "()Lnet/bewis09/bewisclient/game/Translation;", "multiCPSText", "getMultiCPSText", "Lnet/bewis09/bewisclient/settings/types/BooleanSetting;", "leftEnabled", "Lnet/bewis09/bewisclient/settings/types/BooleanSetting;", "getLeftEnabled", "()Lnet/bewis09/bewisclient/settings/types/BooleanSetting;", "rightEnabled", "getRightEnabled", "leftMouseList", "Ljava/util/List;", "getLeftMouseList", "rightMouseList", "getRightMouseList", "", "title", "Ljava/lang/String;", "getTitle", "()Ljava/lang/String;", "description", "getDescription", "bewisclient_client"})
@Environment(value=EnvType.CLIENT)
public final class CPSWidget
extends LineWidget {
    @NotNull
    public static final CPSWidget INSTANCE = new CPSWidget();
    @NotNull
    private static final Translation singleCPSText = INSTANCE.createTranslation("singular_cps", "%s CPS");
    @NotNull
    private static final Translation multiCPSText = INSTANCE.createTranslation("multiple_cps", "%s | %s CPS");
    @NotNull
    private static final BooleanSetting leftEnabled = INSTANCE.boolean("left_enabled", true, (Function3<? super Setting<Boolean>, ? super Boolean, ? super Boolean, Unit>)((Function3)CPSWidget::leftEnabled$lambda$0));
    @NotNull
    private static final BooleanSetting rightEnabled = INSTANCE.boolean("right_enabled", true, (Function3<? super Setting<Boolean>, ? super Boolean, ? super Boolean, Unit>)((Function3)CPSWidget::rightEnabled$lambda$1));
    @NotNull
    private static final List<Long> leftMouseList = new ArrayList();
    @NotNull
    private static final List<Long> rightMouseList = new ArrayList();
    @NotNull
    private static final String title = "CPS Widget";
    @NotNull
    private static final String description = "Displays your current clicks per second (CPS).";

    private CPSWidget() {
        super(UtilKt.createIdentifier("bewisclient", "cps_widget"));
    }

    @NotNull
    public final Translation getSingleCPSText() {
        return singleCPSText;
    }

    @NotNull
    public final Translation getMultiCPSText() {
        return multiCPSText;
    }

    @NotNull
    public final BooleanSetting getLeftEnabled() {
        return leftEnabled;
    }

    @NotNull
    public final BooleanSetting getRightEnabled() {
        return rightEnabled;
    }

    @NotNull
    public final List<Long> getLeftMouseList() {
        return leftMouseList;
    }

    @NotNull
    public final List<Long> getRightMouseList() {
        return rightMouseList;
    }

    @Override
    @NotNull
    protected String getTitle() {
        return title;
    }

    @Override
    @NotNull
    protected String getDescription() {
        return description;
    }

    @Override
    @NotNull
    public class_2561 getLine() {
        if (!((Boolean)rightEnabled.get()).booleanValue()) {
            Object[] objectArray = new Object[]{this.getCPSCount(leftMouseList)};
            return (class_2561)singleCPSText.invoke(objectArray);
        }
        if (!((Boolean)leftEnabled.get()).booleanValue()) {
            Object[] objectArray = new Object[]{this.getCPSCount(rightMouseList)};
            return (class_2561)singleCPSText.invoke(objectArray);
        }
        Object[] objectArray = new Object[]{this.getCPSCount(leftMouseList), this.getCPSCount(rightMouseList)};
        return (class_2561)multiCPSText.invoke(objectArray);
    }

    @Override
    @NotNull
    public WidgetPosition defaultPosition() {
        return new RelativePosition("bewisclient:day_widget", "bottom");
    }

    @Override
    public int getMinimumWidth() {
        return 80;
    }

    public final int getCPSCount(@NotNull List<Long> list) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        long currentTime = System.currentTimeMillis();
        list.removeIf(arg_0 -> CPSWidget.getCPSCount$lambda$3(arg_0 -> CPSWidget.getCPSCount$lambda$2(currentTime, arg_0), arg_0));
        return list.size();
    }

    @Override
    public void appendSettingsRenderables(@NotNull ArrayList<Renderable> list) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        list.add(BooleanSetting.createRenderable$default(leftEnabled, "widget.cps_widget.left_enabled", "Left Mouse Button CPS Shown", null, 4, null));
        list.add(BooleanSetting.createRenderable$default(rightEnabled, "widget.cps_widget.right_enabled", "Right Mouse Button CPS Shown", null, 4, null));
        super.appendSettingsRenderables(list);
    }

    @Override
    @NotNull
    public List<CustomWidget.WidgetStringData> getCustomWidgetDataPoints() {
        Object[] objectArray = new CustomWidget.WidgetStringData[]{new CustomWidget.WidgetStringData("cps_left", "Left CPS", "Your current left clicks per second", CPSWidget::getCustomWidgetDataPoints$lambda$4, null, 16, null), new CustomWidget.WidgetStringData("cps_right", "Right CPS", "Your current right clicks per second", CPSWidget::getCustomWidgetDataPoints$lambda$5, null, 16, null), new CustomWidget.WidgetStringData("cps_total", "Total CPS", "Your current total clicks per second", CPSWidget::getCustomWidgetDataPoints$lambda$6, null, 16, null)};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private static final Unit leftEnabled$lambda$0(Setting $this$boolean, Boolean bl, Boolean bl2) {
        Intrinsics.checkNotNullParameter((Object)$this$boolean, (String)"$this$boolean");
        if (Intrinsics.areEqual((Object)bl2, (Object)false)) {
            rightEnabled.set(true);
        }
        return Unit.INSTANCE;
    }

    private static final Unit rightEnabled$lambda$1(Setting $this$boolean, Boolean bl, Boolean bl2) {
        Intrinsics.checkNotNullParameter((Object)$this$boolean, (String)"$this$boolean");
        if (Intrinsics.areEqual((Object)bl2, (Object)false)) {
            leftEnabled.set(true);
        }
        return Unit.INSTANCE;
    }

    private static final boolean getCPSCount$lambda$2(long $currentTime, Long it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it < $currentTime - (long)1000;
    }

    private static final boolean getCPSCount$lambda$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final class_2561 getCustomWidgetDataPoints$lambda$4(String it) {
        return UtilKt.toText(INSTANCE.getCPSCount(leftMouseList));
    }

    private static final class_2561 getCustomWidgetDataPoints$lambda$5(String it) {
        return UtilKt.toText(INSTANCE.getCPSCount(rightMouseList));
    }

    private static final class_2561 getCustomWidgetDataPoints$lambda$6(String it) {
        return UtilKt.toText(INSTANCE.getCPSCount(leftMouseList) + INSTANCE.getCPSCount(rightMouseList));
    }
}

