/*
 * Decompiled with CFR 0.152.
 */
package net.bewis09.bewisclient.impl.widget;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.bewis09.bewisclient.drawable.Renderable;
import net.bewis09.bewisclient.impl.widget.CustomWidget;
import net.bewis09.bewisclient.settings.types.BooleanSetting;
import net.bewis09.bewisclient.settings.types.ObjectSetting;
import net.bewis09.bewisclient.util.ExtensionUtilKt;
import net.bewis09.bewisclient.util.UtilKt;
import net.bewis09.bewisclient.widget.logic.RelativePosition;
import net.bewis09.bewisclient.widget.logic.WidgetPosition;
import net.bewis09.bewisclient.widget.types.LineWidget;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_638;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0015\u0010\t\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000f\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0011\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001d\u0010\u0017\u001a\u00020\u00162\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0015\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cR\"\u0010\b\u001a\u00020\u001d8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\b\u0010\u001e\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u001a\u0010$\u001a\u00020#8\u0014X\u0094D\u00a2\u0006\f\n\u0004\b$\u0010%\u001a\u0004\b&\u0010'R\u001a\u0010(\u001a\u00020#8\u0014X\u0094D\u00a2\u0006\f\n\u0004\b(\u0010%\u001a\u0004\b)\u0010'\u00a8\u0006*"}, d2={"Lnet/bewis09/bewisclient/impl/widget/DaytimeWidget;", "Lnet/bewis09/bewisclient/widget/types/LineWidget;", "<init>", "()V", "Lnet/minecraft/class_2561;", "getLine", "()Lnet/minecraft/class_2561;", "", "format12Hours", "getText", "(Z)Lnet/minecraft/class_2561;", "Lnet/bewis09/bewisclient/widget/logic/WidgetPosition;", "defaultPosition", "()Lnet/bewis09/bewisclient/widget/logic/WidgetPosition;", "", "getMinimumWidth", "()I", "isSystem12HourFormat", "()Z", "Ljava/util/ArrayList;", "Lnet/bewis09/bewisclient/drawable/Renderable;", "list", "", "appendSettingsRenderables", "(Ljava/util/ArrayList;)V", "", "Lnet/bewis09/bewisclient/impl/widget/CustomWidget$WidgetStringData;", "getCustomWidgetDataPoints", "()Ljava/util/List;", "Lnet/bewis09/bewisclient/settings/types/BooleanSetting;", "Lnet/bewis09/bewisclient/settings/types/BooleanSetting;", "getFormat12Hours", "()Lnet/bewis09/bewisclient/settings/types/BooleanSetting;", "setFormat12Hours", "(Lnet/bewis09/bewisclient/settings/types/BooleanSetting;)V", "", "title", "Ljava/lang/String;", "getTitle", "()Ljava/lang/String;", "description", "getDescription", "bewisclient_client"})
@Environment(value=EnvType.CLIENT)
public final class DaytimeWidget
extends LineWidget {
    @NotNull
    public static final DaytimeWidget INSTANCE = new DaytimeWidget();
    @NotNull
    private static BooleanSetting format12Hours = ObjectSetting.boolean$default(INSTANCE, "format_12_hours", INSTANCE.isSystem12HourFormat(), null, 4, null);
    @NotNull
    private static final String title = "Daytime Widget";
    @NotNull
    private static final String description = "Displays the current in-game time in hours and minutes.";

    private DaytimeWidget() {
        super(UtilKt.createIdentifier("bewisclient", "daytime_widget"));
    }

    @NotNull
    public final BooleanSetting getFormat12Hours() {
        return format12Hours;
    }

    public final void setFormat12Hours(@NotNull BooleanSetting booleanSetting) {
        Intrinsics.checkNotNullParameter((Object)booleanSetting, (String)"<set-?>");
        format12Hours = booleanSetting;
    }

    @Override
    @NotNull
    protected String getTitle() {
        return title;
    }

    @Override
    @NotNull
    protected String getDescription() {
        return description;
    }

    @Override
    @NotNull
    public class_2561 getLine() {
        return this.getText((Boolean)format12Hours.get());
    }

    @NotNull
    public final class_2561 getText(boolean format12Hours) {
        class_638 class_6382 = this.getClient().field_1687;
        long daytime = class_6382 != null ? class_6382.method_8532() : 15684L;
        long hours = (daytime / 1000L + (long)6) % (long)24;
        int minutes = (int)((float)(daytime % 1000L) / 1000.0f * (float)60L);
        if (format12Hours) {
            String period = hours < 12L ? "AM" : "PM";
            long adjustedHours = hours == 0L || hours == 12L ? 12L : hours % (long)12;
            String string = "%02d:%02d %s";
            Object[] objectArray = new Object[]{adjustedHours, minutes, period};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            return (class_2561)ExtensionUtilKt.toText(string2);
        }
        String string = "%02d:%02d";
        Object[] objectArray = new Object[]{hours, minutes};
        String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        return (class_2561)ExtensionUtilKt.toText(string3);
    }

    @Override
    @NotNull
    public WidgetPosition defaultPosition() {
        return new RelativePosition("bewisclient:cps_widget", "bottom");
    }

    @Override
    public int getMinimumWidth() {
        return 80;
    }

    private final boolean isSystem12HourFormat() {
        DateFormat df = DateFormat.getTimeInstance(3, Locale.getDefault());
        Object object = df instanceof SimpleDateFormat ? (SimpleDateFormat)df : null;
        if (object == null || (object = ((SimpleDateFormat)object).toPattern()) == null) {
            return false;
        }
        Object pattern = object;
        return StringsKt.indexOf$default((CharSequence)((CharSequence)pattern), (char)'h', (int)0, (boolean)false, (int)6, null) >= 0 || StringsKt.indexOf$default((CharSequence)((CharSequence)pattern), (char)'K', (int)0, (boolean)false, (int)6, null) >= 0 || StringsKt.indexOf$default((CharSequence)((CharSequence)pattern), (char)'a', (int)0, (boolean)false, (int)6, null) >= 0;
    }

    @Override
    public void appendSettingsRenderables(@NotNull ArrayList<Renderable> list) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        list.add(BooleanSetting.createRenderable$default(format12Hours, "widget.daytime_widget.format_12_hours", "Use 12-Hour Format", null, 4, null));
        super.appendSettingsRenderables(list);
    }

    @Override
    @NotNull
    public List<CustomWidget.WidgetStringData> getCustomWidgetDataPoints() {
        Object[] objectArray = new CustomWidget.WidgetStringData[]{new CustomWidget.WidgetStringData("daytime", "In-Game Time", "The current in-game time in hours and minutes", (Function1<? super String, ? extends class_2561>)((Function1)DaytimeWidget::getCustomWidgetDataPoints$lambda$0), "\"true\" or \"false\" to override the 12-hour format setting"), new CustomWidget.WidgetStringData("real_time", "Real-Life Time", "The current real-life time in hours and minutes", (Function1<? super String, ? extends class_2561>)((Function1)DaytimeWidget::getCustomWidgetDataPoints$lambda$1), "\"seconds\" to include seconds in the time")};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final class_2561 getCustomWidgetDataPoints$lambda$0(String it) {
        boolean bl;
        block5: {
            block4: {
                if (Intrinsics.areEqual((Object)it, (Object)"true")) break block4;
                if (!((Boolean)format12Hours.get()).booleanValue()) break block5;
            }
            if (!Intrinsics.areEqual((Object)it, (Object)"false")) {
                bl = true;
                return INSTANCE.getText(bl);
            }
        }
        bl = false;
        return INSTANCE.getText(bl);
    }

    private static final class_2561 getCustomWidgetDataPoints$lambda$1(String it) {
        String string = DateFormat.getTimeInstance(Intrinsics.areEqual((Object)it, (Object)"seconds") ? 2 : 3).format(Date.from(Instant.now()));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return (class_2561)ExtensionUtilKt.toText(string);
    }
}

