/*
 * Decompiled with CFR 0.152.
 */
package net.bewis09.bewisclient.widget.logic;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.bewis09.bewisclient.impl.settings.DefaultWidgetSettings;
import net.bewis09.bewisclient.widget.Widget;
import net.bewis09.bewisclient.widget.WidgetLoader;
import net.bewis09.bewisclient.widget.logic.WidgetPosition;
import net.bewis09.bewisclient.widget.logic.WidgetPositionFactory;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u00002\u00020\u0001:\u0001\u001dB\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\f\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\f\u0010\u000bJ\u0015\u0010\u000e\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0013\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0015\u001a\u0004\b\u0016\u0010\u0014R\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0015\u001a\u0004\b\u0017\u0010\u0014R\u001d\u0010\u001c\u001a\u0004\u0018\u00010\u00078FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001e"}, d2={"Lnet/bewis09/bewisclient/widget/logic/RelativePosition;", "Lnet/bewis09/bewisclient/widget/logic/WidgetPosition;", "", "parent", "side", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "Lnet/bewis09/bewisclient/widget/Widget;", "widget", "", "getX", "(Lnet/bewis09/bewisclient/widget/Widget;)F", "getY", "", "isInDependencyStack", "(Lnet/bewis09/bewisclient/widget/Widget;)Z", "Lcom/google/gson/JsonElement;", "saveToJson", "()Lcom/google/gson/JsonElement;", "getType", "()Ljava/lang/String;", "Ljava/lang/String;", "getParent", "getSide", "parentWidget$delegate", "Lkotlin/Lazy;", "getParentWidget", "()Lnet/bewis09/bewisclient/widget/Widget;", "parentWidget", "Factory", "bewisclient_client"})
@Environment(value=EnvType.CLIENT)
@SourceDebugExtension(value={"SMAP\nRelativePosition.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RelativePosition.kt\nnet/bewis09/bewisclient/widget/logic/RelativePosition\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,82:1\n1#2:83\n*E\n"})
public final class RelativePosition
implements WidgetPosition {
    @NotNull
    private final String parent;
    @NotNull
    private final String side;
    @NotNull
    private final Lazy parentWidget$delegate;

    public RelativePosition(@NotNull String parent, @NotNull String side) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        this.parent = parent;
        this.side = side;
        this.parentWidget$delegate = LazyKt.lazy(() -> RelativePosition.parentWidget_delegate$lambda$1(this));
    }

    @NotNull
    public final String getParent() {
        return this.parent;
    }

    @NotNull
    public final String getSide() {
        return this.side;
    }

    @Nullable
    public final Widget getParentWidget() {
        Lazy lazy = this.parentWidget$delegate;
        return (Widget)lazy.getValue();
    }

    @Override
    public float getX(@NotNull Widget widget) {
        Intrinsics.checkNotNullParameter((Object)widget, (String)"widget");
        Widget widget2 = this.getParentWidget();
        if (widget2 == null) {
            return 0.0f;
        }
        Widget parent = widget2;
        if (this.isInDependencyStack(widget)) {
            return 0.0f;
        }
        if (!parent.isShowing()) {
            return ((WidgetPosition)parent.getPosition().get()).getX(widget);
        }
        int gap = ((Number)DefaultWidgetSettings.INSTANCE.getGap().get()).intValue();
        return switch (this.side) {
            case "left" -> parent.getX() - widget.getScaledWidth() - (float)gap;
            case "right" -> parent.getX() + parent.getScaledWidth() + (float)gap;
            case "top" -> ((WidgetPosition)parent.getPosition().get()).getX(widget);
            case "bottom" -> ((WidgetPosition)parent.getPosition().get()).getX(widget);
            default -> 0.0f;
        };
    }

    @Override
    public float getY(@NotNull Widget widget) {
        Intrinsics.checkNotNullParameter((Object)widget, (String)"widget");
        Widget widget2 = this.getParentWidget();
        if (widget2 == null) {
            return 0.0f;
        }
        Widget parent = widget2;
        if (this.isInDependencyStack(widget)) {
            return 0.0f;
        }
        if (!parent.isShowing()) {
            return ((WidgetPosition)parent.getPosition().get()).getY(widget);
        }
        int gap = ((Number)DefaultWidgetSettings.INSTANCE.getGap().get()).intValue();
        return switch (this.side) {
            case "left" -> ((WidgetPosition)parent.getPosition().get()).getY(widget);
            case "right" -> ((WidgetPosition)parent.getPosition().get()).getY(widget);
            case "top" -> parent.getY() - widget.getScaledHeight() - (float)gap;
            case "bottom" -> parent.getY() + parent.getScaledHeight() + (float)gap;
            default -> 0.0f;
        };
    }

    public final boolean isInDependencyStack(@NotNull Widget widget) {
        Intrinsics.checkNotNullParameter((Object)widget, (String)"widget");
        Widget latest = this.getParentWidget();
        while (latest != null && !Intrinsics.areEqual((Object)latest, (Object)widget)) {
            Object t = latest.getPosition().get();
            RelativePosition relativePosition = t instanceof RelativePosition ? (RelativePosition)t : null;
            latest = relativePosition != null ? relativePosition.getParentWidget() : null;
        }
        return Intrinsics.areEqual((Object)latest, (Object)widget);
    }

    @Override
    @NotNull
    public JsonElement saveToJson() {
        JsonObject jsonObject;
        JsonObject it = jsonObject = new JsonObject();
        boolean bl = false;
        it.addProperty("side", this.side);
        it.addProperty("parent", this.parent);
        return (JsonElement)jsonObject;
    }

    @Override
    @NotNull
    public String getType() {
        return "relative";
    }

    private static final Widget parentWidget_delegate$lambda$1(RelativePosition this$0) {
        Object v0;
        block1: {
            Iterable iterable = WidgetLoader.INSTANCE.getWidgets();
            for (Object t : iterable) {
                Widget it = (Widget)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getId().toString(), (Object)this$0.parent)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0019\u0010\u0007\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0006\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lnet/bewis09/bewisclient/widget/logic/RelativePosition$Factory;", "Lnet/bewis09/bewisclient/widget/logic/WidgetPositionFactory;", "Lnet/bewis09/bewisclient/widget/logic/RelativePosition;", "<init>", "()V", "Lcom/google/gson/JsonElement;", "jsonElement", "createFromJson", "(Lcom/google/gson/JsonElement;)Lnet/bewis09/bewisclient/widget/logic/RelativePosition;", "", "getType", "()Ljava/lang/String;", "bewisclient_client"})
    @Environment(value=EnvType.CLIENT)
    public static final class Factory
    implements WidgetPositionFactory<RelativePosition> {
        @NotNull
        public static final Factory INSTANCE = new Factory();

        private Factory() {
        }

        @Override
        @Nullable
        public RelativePosition createFromJson(@NotNull JsonElement jsonElement) {
            Intrinsics.checkNotNullParameter((Object)jsonElement, (String)"jsonElement");
            if (!jsonElement.isJsonObject()) {
                return null;
            }
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            Object object = jsonObject.get("parent");
            if (object == null || (object = object.getAsString()) == null) {
                return null;
            }
            Object parent = object;
            Object object2 = jsonObject.get("side");
            if (object2 == null || (object2 = object2.getAsString()) == null) {
                return null;
            }
            Object side = object2;
            return new RelativePosition((String)parent, (String)side);
        }

        @Override
        @NotNull
        public String getType() {
            return "relative";
        }
    }
}

