/*
 * Decompiled with CFR 0.152.
 */
package net.bewis09.bewisclient.logic.number;

import kotlin.Metadata;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.text.StringsKt;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\b\n\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\u000b\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0015\u0010\u0010\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0015\u0010\u0012\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0012\u0010\fJ\r\u0010\u0013\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0015\u0010\u0015\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0015\u0010\fJ\u0015\u0010\u0016\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0016\u0010\fJ\u0015\u0010\u0017\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0017\u0010\fJ\u0015\u0010\u0018\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0018\u0010\fJ\u0010\u0010\u0019\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0010\u0010\u001b\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u001b\u0010\u001aJ\u0010\u0010\u001c\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u001c\u0010\u001aJ\u0010\u0010\u001d\u001a\u00020\u0006H\u00c6\u0003\u00a2\u0006\u0004\b\u001d\u0010\u0014J8\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00022\b\b\u0002\u0010\u0007\u001a\u00020\u0006H\u00c6\u0001\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u001a\u0010\"\u001a\u00020!2\b\u0010 \u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\"\u0010#J\u0010\u0010$\u001a\u00020\u0006H\u00d6\u0001\u00a2\u0006\u0004\b$\u0010\u0014R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010%\u001a\u0004\b&\u0010\u001aR\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010%\u001a\u0004\b'\u0010\u001aR\u0017\u0010\u0005\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010%\u001a\u0004\b(\u0010\u001aR\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010)\u001a\u0004\b*\u0010\u0014\u00a8\u0006+"}, d2={"Lnet/bewis09/bewisclient/logic/number/Precision;", "", "", "min", "max", "step", "", "precision", "<init>", "(FFFI)V", "value", "round", "(F)F", "", "toString", "()Ljava/lang/String;", "roundToString", "(F)Ljava/lang/String;", "coerce", "getStepCount", "()I", "getNearestStep", "normalize", "denormalize", "parse", "component1", "()F", "component2", "component3", "component4", "copy", "(FFFI)Lnet/bewis09/bewisclient/logic/number/Precision;", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "F", "getMin", "getMax", "getStep", "I", "getPrecision", "bewisclient_client"})
@Environment(value=EnvType.CLIENT)
@SourceDebugExtension(value={"SMAP\nPrecision.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Precision.kt\nnet/bewis09/bewisclient/logic/number/Precision\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,60:1\n1#2:61\n*E\n"})
public final class Precision {
    private final float min;
    private final float max;
    private final float step;
    private final int precision;

    public Precision(float min, float max, float step, int precision) {
        this.min = min;
        this.max = max;
        this.step = step;
        this.precision = precision;
        if (!(this.min < this.max)) {
            boolean bl = false;
            String string = "Minimum value must be less than maximum value.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public final float getMin() {
        return this.min;
    }

    public final float getMax() {
        return this.max;
    }

    public final float getStep() {
        return this.step;
    }

    public final int getPrecision() {
        return this.precision;
    }

    public final float round(float value) {
        double scale = Math.pow(10.0, this.precision);
        return (float)MathKt.roundToInt((double)((double)value * scale)) / (float)scale;
    }

    @NotNull
    public String toString() {
        return "FaderPrecision(min=" + this.min + ", max=" + this.max + ", step=" + this.step + ", precision=" + this.precision + ")";
    }

    @NotNull
    public final String roundToString(float value) {
        String[] stringArray = new String[]{"."};
        return StringsKt.padEnd((String)String.valueOf(this.round(value)), (int)(this.precision + ((String)StringsKt.split$default((CharSequence)String.valueOf(this.round(value)), (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(0)).length() + 1), (char)'0');
    }

    public final float coerce(float value) {
        return value < this.min ? this.min : (value > this.max ? this.max : this.round(value));
    }

    public final int getStepCount() {
        return (int)((this.max - this.min) / this.step) + 1;
    }

    public final float getNearestStep(float value) {
        int steps = MathKt.roundToInt((float)((value - this.min) / this.step));
        return this.round(this.min + (float)steps * this.step);
    }

    public final float normalize(float value) {
        return (value - this.min) / (this.max - this.min);
    }

    public final float denormalize(float value) {
        return this.min + value * (this.max - this.min);
    }

    public final float parse(float value) {
        return this.getNearestStep(this.coerce(value));
    }

    public final float component1() {
        return this.min;
    }

    public final float component2() {
        return this.max;
    }

    public final float component3() {
        return this.step;
    }

    public final int component4() {
        return this.precision;
    }

    @NotNull
    public final Precision copy(float min, float max, float step, int precision) {
        return new Precision(min, max, step, precision);
    }

    public static /* synthetic */ Precision copy$default(Precision precision, float f, float f2, float f3, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            f = precision.min;
        }
        if ((n2 & 2) != 0) {
            f2 = precision.max;
        }
        if ((n2 & 4) != 0) {
            f3 = precision.step;
        }
        if ((n2 & 8) != 0) {
            n = precision.precision;
        }
        return precision.copy(f, f2, f3, n);
    }

    public int hashCode() {
        int result = Float.hashCode(this.min);
        result = result * 31 + Float.hashCode(this.max);
        result = result * 31 + Float.hashCode(this.step);
        result = result * 31 + Integer.hashCode(this.precision);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Precision)) {
            return false;
        }
        Precision precision = (Precision)other;
        if (Float.compare(this.min, precision.min) != 0) {
            return false;
        }
        if (Float.compare(this.max, precision.max) != 0) {
            return false;
        }
        if (Float.compare(this.step, precision.step) != 0) {
            return false;
        }
        return this.precision == precision.precision;
    }
}

