/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostradar;

import com.mojang.brigadier.CommandDispatcher;
import mcjty.lostradar.commands.ModCommands;
import mcjty.lostradar.data.PaletteCache;
import mcjty.lostradar.data.PlayerMapKnowledge;
import mcjty.lostradar.data.PlayerMapKnowledgeDispatcher;
import mcjty.lostradar.data.ServerMapData;
import mcjty.lostradar.setup.ModSetup;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class EventHandlers {
    private int tickCounter = 10;

    @SubscribeEvent
    public void commandRegister(RegisterCommandsEvent event) {
        ModCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        PlayerMapKnowledge.register(event);
    }

    @SubscribeEvent
    public void onPlayerTickEvent(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START && !event.player.m_20193_().f_46443_) {
            --this.tickCounter;
            if (this.tickCounter > 0) {
                return;
            }
            PlayerMapKnowledgeDispatcher.getPlayerMapKnowledge(event.player).ifPresent(handler -> handler.tick((ServerPlayer)event.player));
        }
    }

    @SubscribeEvent
    public void onEntityConstructing(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player) {
            if (!event.getCapabilities().containsKey(ModSetup.PLAYER_KNOWLEDGE) && !((Entity)event.getObject()).getCapability(ModSetup.PLAYER_KNOWLEDGE).isPresent()) {
                event.addCapability(ModSetup.PLAYER_KNOWLEDGE_KEY, (ICapabilityProvider)new PlayerMapKnowledgeDispatcher());
            } else {
                throw new IllegalStateException(((Entity)event.getObject()).toString());
            }
        }
    }

    @SubscribeEvent
    public void onPlayerCloned(PlayerEvent.Clone event) {
        if (event.isWasDeath()) {
            event.getOriginal().getCapability(ModSetup.PLAYER_KNOWLEDGE).ifPresent(oldStore -> event.getEntity().getCapability(ModSetup.PLAYER_KNOWLEDGE).ifPresent(newStore -> newStore.copyFrom((PlayerMapKnowledge)oldStore)));
        }
    }

    @SubscribeEvent
    public void onServerStopping(ServerStoppingEvent event) {
        PaletteCache.cleanup();
        ServerMapData.getData((Level)event.getServer().m_129783_()).cleanup();
    }

    @SubscribeEvent
    public void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        PaletteCache.cleanup();
        ServerMapData.getData(event.getEntity().m_9236_()).cleanup();
    }

    @SubscribeEvent
    public void onLevelTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            ServerLevel overworld = event.getServer().m_129783_();
            ServerMapData.getData((Level)overworld).tickSearch((Level)overworld);
        }
    }
}

