/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostradar.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import mcjty.lib.varia.codec.StreamCodec;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;

public record EntryPos(ResourceKey<Level> level, int chunkX, int chunkZ) {
    public static final Codec<EntryPos> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceKey.m_195966_((ResourceKey)Registries.f_256858_).fieldOf("level").forGetter(EntryPos::level), (App)Codec.INT.fieldOf("chunkX").forGetter(EntryPos::chunkX), (App)Codec.INT.fieldOf("chunkZ").forGetter(EntryPos::chunkZ)).apply((Applicative)instance, EntryPos::new));
    public static final StreamCodec<FriendlyByteBuf, EntryPos> STREAM_CODEC = StreamCodec.of((buf, entry) -> {
        buf.m_130085_(entry.level().m_135782_());
        buf.writeInt(entry.chunkX());
        buf.writeInt(entry.chunkZ());
    }, buf -> {
        ResourceKey level = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)buf.m_130281_());
        int chunkX = buf.readInt();
        int chunkZ = buf.readInt();
        return new EntryPos((ResourceKey<Level>)level, chunkX, chunkZ);
    });

    public static EntryPos fromChunkPos(ResourceKey<Level> level, ChunkPos pos) {
        int topLeftX = pos.f_45578_ - (pos.f_45578_ & 7);
        int topLeftZ = pos.f_45579_ - (pos.f_45579_ & 7);
        return new EntryPos(level, topLeftX, topLeftZ);
    }

    public EntryPos offset(int x, int z) {
        return new EntryPos(this.level, this.chunkX + x * 8, this.chunkZ + z * 8);
    }
}

