/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostradar.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.List;
import mcjty.lib.varia.codec.StandardCodecs;
import mcjty.lib.varia.codec.StreamCodec;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.ChunkPos;

public record MapChunk(int chunkX, int chunkZ, short[] data, int[] biomeColors) {
    public static final int MAPCHUNK_SIZE = 8;
    public static final int MAPCHUNK_MASK = 7;
    public static final short CITY = Short.MAX_VALUE;
    public static final short HIGHWAY = 32766;
    public static final StreamCodec<FriendlyByteBuf, MapChunk> STREAM_CODEC = StreamCodec.composite((StreamCodec)StandardCodecs.INT, MapChunk::chunkX, (StreamCodec)StandardCodecs.INT, MapChunk::chunkZ, (StreamCodec)StandardCodecs.SHORT_ARRAY, MapChunk::data, (StreamCodec)StandardCodecs.INT_ARRAY, MapChunk::biomeColors, MapChunk::new);
    public static final Codec<MapChunk> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("chunkX").forGetter(MapChunk::chunkX), (App)Codec.INT.fieldOf("chunkZ").forGetter(MapChunk::chunkZ), (App)Codec.list((Codec)Codec.SHORT).fieldOf("data").forGetter(d -> MapChunk.convertToList(d.data)), (App)Codec.list((Codec)Codec.INT).fieldOf("biomeColors").forGetter(d -> Arrays.stream(d.biomeColors).boxed().toList())).apply((Applicative)instance, (chunkX, chunkZ, shorts, biomeColors) -> {
        short[] data = new short[shorts.size()];
        for (int i = 0; i < shorts.size(); ++i) {
            data[i] = (Short)shorts.get(i);
        }
        int[] bc = new int[biomeColors.size()];
        for (int i = 0; i < biomeColors.size(); ++i) {
            bc[i] = (Integer)biomeColors.get(i);
        }
        return new MapChunk((int)chunkX, (int)chunkZ, data, bc);
    }));

    private static List<Short> convertToList(short[] shorts) {
        Short[] boxed = new Short[shorts.length];
        for (int i = 0; i < shorts.length; ++i) {
            boxed[i] = shorts[i];
        }
        return Arrays.asList(boxed);
    }

    public int getDataAt(ChunkPos pos) {
        int x = pos.f_45578_ & 7;
        int z = pos.f_45579_ & 7;
        int index = x + z * 8;
        return this.data[index];
    }

    public int getBiomeColorAt(ChunkPos pos) {
        int x = pos.f_45578_ & 7;
        int z = pos.f_45579_ & 7;
        int index = x + z * 8;
        return this.biomeColors[index];
    }
}

