/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostradar.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mcjty.lostradar.data.CustomRegistries;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public record MapPalette(List<PaletteEntry> palette) {
    public static final PaletteEntry CITY = new PaletteEntry("city", 0xAAAAAA, "lostradar.city", 0, Collections.emptyList(), -1, -1, Set.of());
    public static final PaletteEntry HIGHWAY = new PaletteEntry("highway", 0, "lostradar.highway", 0, Collections.emptyList(), -1, -1, Set.of());
    private static final Codec<PaletteEntry> PALETTE_ENTRY_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(PaletteEntry::name), (App)Codec.INT.fieldOf("color").forGetter(PaletteEntry::color), (App)Codec.STRING.fieldOf("translatableKey").forGetter(PaletteEntry::translatableKey), (App)Codec.INT.fieldOf("usage").forGetter(PaletteEntry::usage), (App)Codec.list((Codec)Codec.STRING).fieldOf("commands").forGetter(PaletteEntry::commands), (App)Codec.INT.fieldOf("u").forGetter(PaletteEntry::iconU), (App)Codec.INT.fieldOf("v").forGetter(PaletteEntry::iconV), (App)Codec.list((Codec)ResourceLocation.f_135803_).fieldOf("buildings").forGetter(p -> new ArrayList<ResourceLocation>(p.buildings))).apply((Applicative)instance, (name, color, translatableKey, usage, commands, u, v, b) -> {
        HashSet<ResourceLocation> buildings = new HashSet<ResourceLocation>();
        if (b != null) {
            for (ResourceLocation location : b) {
                buildings.add(location);
            }
        }
        return new PaletteEntry((String)name, (int)color, (String)translatableKey, (int)usage, (List<String>)commands, (int)u, (int)v, (Set<ResourceLocation>)buildings);
    }));
    public static final Codec<MapPalette> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)PALETTE_ENTRY_CODEC.listOf().fieldOf("palette").forGetter(i -> i.palette)).apply((Applicative)instance, MapPalette::new));

    public static MapPalette getDefaultPalette(Level level) {
        Registry registry = level.m_9598_().m_175515_(CustomRegistries.PALETTE_REGISTRY_KEY);
        return (MapPalette)registry.m_7745_(new ResourceLocation("lostradar", "default"));
    }

    public record PaletteEntry(String name, int color, String translatableKey, int usage, List<String> commands, int iconU, int iconV, Set<ResourceLocation> buildings) {
    }
}

