/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostradar.data;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import mcjty.lostradar.data.MapPalette;
import net.minecraft.resources.ResourceLocation;

public class PaletteCache {
    private final MapPalette palette;
    private final Map<ResourceLocation, MapPalette.PaletteEntry> entryForBuilding;
    private final Map<ResourceLocation, Integer> indexForBuilding;
    private final Map<String, MapPalette.PaletteEntry> entryByCategory;
    private int defaultEntry = -1;
    private static PaletteCache paletteCache = null;

    public static PaletteCache getOrCreatePaletteCache(MapPalette palette) {
        if (paletteCache == null) {
            paletteCache = new PaletteCache(palette);
        }
        return paletteCache;
    }

    public static void cleanup() {
        paletteCache = null;
    }

    public PaletteCache(MapPalette palette) {
        this.palette = palette;
        this.entryForBuilding = palette.palette().stream().flatMap(entry -> entry.buildings().stream().map(building -> Map.entry(building, entry))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        this.entryByCategory = new HashMap<String, MapPalette.PaletteEntry>();
        this.indexForBuilding = new HashMap<ResourceLocation, Integer>();
        for (int i = 0; i < palette.palette().size(); ++i) {
            MapPalette.PaletteEntry entry2 = palette.palette().get(i);
            if (entry2.buildings().isEmpty()) {
                this.defaultEntry = i;
            } else {
                for (ResourceLocation building : entry2.buildings()) {
                    this.indexForBuilding.put(building, i);
                }
            }
            if (entry2.name() == null) continue;
            this.entryByCategory.put(entry2.name(), entry2);
        }
    }

    public int getDefaultEntry() {
        return this.defaultEntry;
    }

    public MapPalette getPalette() {
        return this.palette;
    }

    public MapPalette.PaletteEntry getEntryForIndex(int index) {
        if (index < 0 || index >= this.palette.palette().size()) {
            return null;
        }
        return this.palette.palette().get(index);
    }

    @Nullable
    public MapPalette.PaletteEntry getEntryForBuilding(ResourceLocation building) {
        return this.entryForBuilding.get(building);
    }

    @Nullable
    public MapPalette.PaletteEntry getEntryByCategory(String category) {
        return this.entryByCategory.get(category);
    }

    public int getIndexForBuilding(ResourceLocation building) {
        return this.indexForBuilding.getOrDefault(building, -1);
    }
}

