/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostradar.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mcjty.lib.worlddata.AbstractWorldData;
import mcjty.lostcities.api.ILostChunkInfo;
import mcjty.lostcities.api.ILostCityInformation;
import mcjty.lostradar.compat.LostCitiesCompat;
import mcjty.lostradar.data.EntryPos;
import mcjty.lostradar.data.MapChunk;
import mcjty.lostradar.data.MapPalette;
import mcjty.lostradar.data.PaletteCache;
import mcjty.lostradar.network.Messages;
import mcjty.lostradar.network.PacketPauseStateToClient;
import mcjty.lostradar.network.PacketReturnMapChunkToClient;
import mcjty.lostradar.network.PacketReturnSearchResultsToClient;
import mcjty.lostradar.setup.Config;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.WorldWorkerManager;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.commons.lang3.tuple.Pair;

public class ServerMapData
extends AbstractWorldData<ServerMapData>
implements WorldWorkerManager.IWorker {
    private final Map<EntryPos, MapChunk> mapChunks = Collections.synchronizedMap(new HashMap());
    private static final String RADAR_CACHE = "RadarCache";
    private final Set<EntryPos> todo = Collections.synchronizedSet(new HashSet());
    private static final Codec<Pair<EntryPos, MapChunk>> PAIR_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntryPos.CODEC.fieldOf("entryPos").forGetter(Pair::getLeft), (App)MapChunk.CODEC.fieldOf("mapChunk").forGetter(Pair::getRight)).apply((Applicative)instance, Pair::of));
    private static final Codec<Map<EntryPos, MapChunk>> MAP_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)PAIR_CODEC.listOf().fieldOf("mapChunks").forGetter(m -> m.entrySet().stream().map(entry -> Pair.of((Object)((EntryPos)entry.getKey()), (Object)((MapChunk)entry.getValue()))).toList())).apply((Applicative)instance, chunks -> {
        HashMap<EntryPos, MapChunk> map = new HashMap<EntryPos, MapChunk>();
        for (Pair entry : chunks) {
            map.put((EntryPos)entry.getLeft(), (MapChunk)entry.getRight());
        }
        return map;
    }));
    private Map<UUID, PlayerSearch> searches = new HashMap<UUID, PlayerSearch>();

    public static ServerMapData getData(Level world) {
        return (ServerMapData)ServerMapData.getData((Level)world, ServerMapData::new, ServerMapData::new, (String)RADAR_CACHE);
    }

    public void cleanup() {
        this.mapChunks.clear();
        this.todo.clear();
        this.searches.clear();
    }

    private ServerMapData() {
        WorldWorkerManager.addWorker((WorldWorkerManager.IWorker)this);
    }

    private ServerMapData(CompoundTag tag) {
        DataResult result = MAP_CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)tag.m_128423_("chunks"));
        if (result.result().isPresent()) {
            this.mapChunks.putAll((Map)result.result().get());
        }
        WorldWorkerManager.addWorker((WorldWorkerManager.IWorker)this);
    }

    public boolean hasWork() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doWork() {
        Set<EntryPos> set = this.todo;
        synchronized (set) {
            if (!this.todo.isEmpty()) {
                Iterator<EntryPos> iterator = this.todo.iterator();
                EntryPos entry = iterator.next();
                iterator.remove();
                MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
                ServerLevel level = server.m_129880_(entry.level());
                this.calculateMapChunk((Level)level, entry);
            }
        }
        return false;
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        DataResult result = MAP_CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, this.mapChunks);
        if (result.result().isPresent()) {
            tag.m_128365_("chunks", (Tag)result.result().get());
        }
        return tag;
    }

    public void requestMapChunk(Level level, EntryPos pos) {
        if (level.f_46443_) {
            throw new RuntimeException("Don't access this client-side!");
        }
        MapChunk mapChunk = this.mapChunks.get(pos);
        if (mapChunk == null) {
            this.todo.remove(pos);
            mapChunk = this.calculateMapChunk(level, pos);
        }
        if (mapChunk != null) {
            PacketReturnMapChunkToClient packet = new PacketReturnMapChunkToClient((ResourceKey<Level>)level.m_46472_(), mapChunk);
            Messages.sendToAllPlayers((ResourceKey<Level>)level.m_46472_(), packet);
        }
    }

    private MapChunk getMapChunk(Level level, EntryPos pos) {
        MapChunk mapChunk = this.mapChunks.get(pos);
        if (mapChunk == null) {
            this.todo.add(pos);
        }
        return mapChunk;
    }

    public void pauseSearch(Player player) {
        PlayerSearch search = this.searches.get(player.m_20148_());
        if (search != null) {
            this.searches.put(player.m_20148_(), new PlayerSearch(search.level(), search.searchString(), search.searchTodo(), search.totalEntries, true));
            Messages.sendToPlayer(new PacketPauseStateToClient(true), player);
        }
    }

    public void unpauseSearch(Player player) {
        PlayerSearch search = this.searches.get(player.m_20148_());
        if (search != null) {
            this.searches.put(player.m_20148_(), new PlayerSearch(search.level(), search.searchString(), search.searchTodo(), search.totalEntries, false));
            Messages.sendToPlayer(new PacketPauseStateToClient(false), player);
        }
    }

    public boolean isPaused(Player player) {
        PlayerSearch search = this.searches.get(player.m_20148_());
        return search != null && search.paused();
    }

    public boolean isSearching(Player player) {
        return this.searches.containsKey(player.m_20148_());
    }

    public void stopSearch(Player player) {
        this.searches.remove(player.m_20148_());
    }

    public void startSearch(Player player, String category) {
        if (category.isEmpty()) {
            this.searches.remove(player.m_20148_());
            return;
        }
        Level level = player.m_9236_();
        EntryPos pos = EntryPos.fromChunkPos((ResourceKey<Level>)level.m_46472_(), new ChunkPos(player.m_20183_()));
        PlayerSearch search = new PlayerSearch((ResourceKey<Level>)level.m_46472_(), category, new LinkedHashSet<EntryPos>(), ((Integer)Config.SEARCH_RADIUS.get() * 2 + 1) * ((Integer)Config.SEARCH_RADIUS.get() * 2 + 1), false);
        for (int radius = 0; radius <= (Integer)Config.SEARCH_RADIUS.get(); ++radius) {
            EntryPos entryPos;
            if (radius == 0) {
                search.searchTodo().add(pos);
                continue;
            }
            for (int x = -radius; x <= radius; ++x) {
                entryPos = pos.offset(x, radius);
                search.searchTodo().add(entryPos);
                entryPos = pos.offset(x, -radius);
                search.searchTodo().add(entryPos);
            }
            for (int z = -radius + 1; z <= radius - 1; ++z) {
                entryPos = pos.offset(radius, z);
                search.searchTodo().add(entryPos);
                entryPos = pos.offset(-radius, z);
                search.searchTodo().add(entryPos);
            }
        }
        this.searches.put(player.m_20148_(), search);
    }

    public void tickSearch(Level overworld) {
        HashSet<UUID> searchesToRemove = new HashSet<UUID>();
        for (Map.Entry<UUID, PlayerSearch> entry : this.searches.entrySet()) {
            PlayerSearch search = entry.getValue();
            if (search.paused()) continue;
            if (!search.searchTodo().isEmpty()) {
                ServerLevel level = overworld.m_7654_().m_129880_(search.level());
                HashSet<ChunkPos> result = new HashSet<ChunkPos>();
                EntryPos pos = search.searchTodo.iterator().next();
                MapChunk mapChunk = this.getMapChunk(overworld, pos);
                if (mapChunk == null) continue;
                search.searchTodo.remove(pos);
                this.findCategory((Level)level, mapChunk, search.searchString(), result);
                ServerPlayer player = level.m_7654_().m_6846_().m_11259_(entry.getKey());
                int progressPercentage = 100 - search.searchTodo().size() * 100 / search.totalEntries;
                Messages.sendToPlayer(new PacketReturnSearchResultsToClient(result, Set.of(pos), progressPercentage), (Player)player);
                continue;
            }
            searchesToRemove.add(entry.getKey());
        }
        for (UUID uuid : searchesToRemove) {
            this.searches.remove(uuid);
        }
    }

    private void findCategory(Level level, MapChunk mapChunk, String category, Set<ChunkPos> result) {
        PaletteCache palette = PaletteCache.getOrCreatePaletteCache(MapPalette.getDefaultPalette(level));
        for (int x = 0; x < 8; ++x) {
            for (int z = 0; z < 8; ++z) {
                MapPalette.PaletteEntry entry;
                int dataAt = mapChunk.getDataAt(new ChunkPos(mapChunk.chunkX() + x, mapChunk.chunkZ() + z));
                if (dataAt == -1 || (entry = palette.getEntryForIndex(dataAt)) == null || !category.equals(entry.name())) continue;
                result.add(new ChunkPos(mapChunk.chunkX() + x, mapChunk.chunkZ() + z));
            }
        }
    }

    private MapChunk calculateMapChunk(Level level, EntryPos pos) {
        ILostCityInformation info = LostCitiesCompat.lostCities.getLostInfo(level);
        if (info != null) {
            PaletteCache cache = PaletteCache.getOrCreatePaletteCache(MapPalette.getDefaultPalette(level));
            int defaultEntry = cache.getDefaultEntry();
            short[] data = new short[64];
            int[] biomeColors = new int[64];
            for (int x = 0; x < 8; ++x) {
                for (int z = 0; z < 8; ++z) {
                    int biomeColor;
                    int dataAt = -1;
                    ILostChunkInfo chunk = info.getChunkInfo(pos.chunkX() + x, pos.chunkZ() + z);
                    if (chunk != null) {
                        ResourceLocation buildingId = chunk.getBuildingId();
                        if (buildingId != null) {
                            int index = cache.getIndexForBuilding(buildingId);
                            dataAt = index != -1 ? (int)((short)index) : (int)((short)defaultEntry);
                        } else if (chunk.getMaxHighwayLevel() != -1) {
                            dataAt = 32766;
                        } else if (chunk.isCity()) {
                            dataAt = Short.MAX_VALUE;
                        }
                    }
                    data[x + z * 8] = (short)dataAt;
                    biomeColors[x + z * 8] = biomeColor = ServerMapData.getBiomeColor(level, pos, x, 8, z, 8);
                }
            }
            MapChunk mapChunk = new MapChunk(pos.chunkX(), pos.chunkZ(), data, biomeColors);
            this.mapChunks.put(pos, mapChunk);
            this.m_77762_();
            return mapChunk;
        }
        return null;
    }

    private static int getAverageBiomeColor(Level level, EntryPos pos, int x, int z) {
        int[] color = new int[]{ServerMapData.getBiomeColor(level, pos, x, 4, z, 4), ServerMapData.getBiomeColor(level, pos, x, 4, z, 12), ServerMapData.getBiomeColor(level, pos, x, 12, z, 4), ServerMapData.getBiomeColor(level, pos, x, 12, z, 12)};
        int[] count = new int[4];
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                if (color[i] != color[j]) continue;
                int n = i;
                count[n] = count[n] + 1;
            }
        }
        int max = 0;
        int maxIndex = 0;
        for (int i = 0; i < 4; ++i) {
            if (count[i] <= max) continue;
            max = count[i];
            maxIndex = i;
        }
        return color[maxIndex];
    }

    private static int getBiomeColor(Level level, EntryPos pos, int x, int offsetX, int z, int offsetZ) {
        Holder biome = level.m_204166_(new BlockPos((pos.chunkX() + x << 4) + offsetX, 65, (pos.chunkZ() + z << 4) + offsetZ));
        int biomeColor = 65280;
        if (biome.containsTag(BiomeTags.f_207603_) || biome.containsTag(BiomeTags.f_207605_) || biome.containsTag(BiomeTags.f_207604_)) {
            biomeColor = 255;
        } else if (biome.containsTag(BiomeTags.f_207606_)) {
            biomeColor = 9127187;
        } else if (biome.containsTag(Tags.Biomes.IS_DESERT) || biome.containsTag(BiomeTags.f_207607_)) {
            biomeColor = 0xFFFF00;
        } else if (biome.containsTag(BiomeTags.f_207611_)) {
            biomeColor = 25600;
        } else if (biome.containsTag(Tags.Biomes.IS_PLAINS)) {
            biomeColor = 65280;
        }
        return biomeColor;
    }

    private record PlayerSearch(ResourceKey<Level> level, String searchString, Set<EntryPos> searchTodo, int totalEntries, boolean paused) {
    }
}

