/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostradar.network;

import mcjty.lib.network.CustomPacketPayload;
import mcjty.lib.network.PlayPayloadContext;
import mcjty.lib.varia.ComponentFactory;
import mcjty.lostradar.data.ServerMapData;
import mcjty.lostradar.radar.RadarItem;
import mcjty.lostradar.setup.Registration;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public record PacketStartSearch(String category, int usage) implements CustomPacketPayload
{
    public static ResourceLocation ID = new ResourceLocation("lostradar", "startsearch");

    public static PacketStartSearch create(FriendlyByteBuf buf) {
        String category = buf.m_130136_(Short.MAX_VALUE);
        int usage = buf.readInt();
        return new PacketStartSearch(category, usage);
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130070_(this.category);
        buf.writeInt(this.usage);
    }

    public ResourceLocation id() {
        return ID;
    }

    public void handle(PlayPayloadContext ctx) {
        ctx.workHandler().submitAsync(() -> ctx.player().ifPresent(player -> {
            ServerMapData mapData = ServerMapData.getData(player.m_9236_());
            if (this.category.isEmpty()) {
                mapData.stopSearch((Player)player);
            } else if (mapData.isSearching((Player)player)) {
                if (mapData.isPaused((Player)player)) {
                    mapData.unpauseSearch((Player)player);
                } else {
                    mapData.pauseSearch((Player)player);
                }
            } else {
                int extracted;
                if (this.usage > 0 && (extracted = ((RadarItem)Registration.RADAR.get()).extractEnergyNoMax(player.m_21205_(), this.usage, false)) < this.usage) {
                    player.m_213846_((Component)ComponentFactory.translatable((String)"lostradar.notenoughenergy", (Object[])new Object[]{this.usage}));
                    return;
                }
                mapData.startSearch((Player)player, this.category);
            }
        }));
    }
}

