/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostradar.radar;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import mcjty.lib.client.BatchQuadGuiRenderer;
import mcjty.lib.client.GuiTools;
import mcjty.lib.client.RenderHelper;
import mcjty.lib.gui.GuiItemScreen;
import mcjty.lib.gui.IKeyReceiver;
import mcjty.lib.gui.ManualEntry;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.WindowManager;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.Button;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.gui.widgets.WidgetList;
import mcjty.lib.gui.widgets.Widgets;
import mcjty.lib.varia.ComponentFactory;
import mcjty.lostradar.data.ClientMapData;
import mcjty.lostradar.data.EntryPos;
import mcjty.lostradar.data.MapPalette;
import mcjty.lostradar.data.PaletteCache;
import mcjty.lostradar.data.PlayerMapKnowledgeDispatcher;
import mcjty.lostradar.network.Messages;
import mcjty.lostradar.network.PacketStartSearch;
import mcjty.lostradar.radar.RadarItem;
import mcjty.lostradar.setup.Config;
import mcjty.lostradar.setup.Registration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.tuple.Pair;

public class GuiRadar
extends GuiItemScreen
implements IKeyReceiver {
    private static final int xSize = 380;
    private static final int ySize = 236;
    private static final int MAPCELL_SIZE = 10;
    private static final int MAP_DIM = 10;
    private static final ResourceLocation ICONS = new ResourceLocation("lostradar", "textures/gui/icons.png");
    private static final ResourceLocation MAP_ICONS_LOCATION = new ResourceLocation("textures/map/map_icons.png");
    private WidgetList categoryList;
    private Button scanButton;
    private final List<String> categories = new ArrayList<String>();
    private final List<Pair<Rect2i, ChunkPos>> borderCoordinates = new ArrayList<Pair<Rect2i, ChunkPos>>();

    public GuiRadar() {
        super(380, 236, ManualEntry.EMPTY);
    }

    public Window getWindow() {
        return this.window;
    }

    public void m_7856_() {
        super.m_7856_();
        int k = (this.f_96543_ - 380) / 2;
        int l = (this.f_96544_ - 236) / 2;
        Panel toplevel = (Panel)Widgets.positional().filledRectThickness(2);
        this.categoryList = Widgets.list((int)238, (int)12, (int)133, (int)183);
        this.scanButton = Widgets.button((int)238, (int)196, (int)133, (int)15, (String)ComponentFactory.translatable((String)"button.lostradar.scan").getString()).event(() -> {
            int selected = this.categoryList.getSelected();
            if (selected >= 0) {
                int extracted;
                String category;
                PaletteCache palette = PaletteCache.getOrCreatePaletteCache(MapPalette.getDefaultPalette((Level)Minecraft.m_91087_().f_91073_));
                MapPalette.PaletteEntry entry = palette.getEntryByCategory(category = this.categories.get(selected));
                if (entry.usage() > 0 && (extracted = ((RadarItem)Registration.RADAR.get()).extractEnergyNoMax(Minecraft.m_91087_().f_91074_.m_21205_(), entry.usage(), true)) < entry.usage()) {
                    Minecraft.m_91087_().f_91074_.m_213846_((Component)ComponentFactory.translatable((String)"lostradar.notenoughenergy", (Object[])new Object[]{entry.usage()}));
                    return;
                }
                if (!category.isEmpty()) {
                    Messages.sendToServer(new PacketStartSearch(category, entry.usage()));
                }
                ClientMapData.getData().setSearchString(category);
            }
        });
        Button clearButton = Widgets.button((int)238, (int)214, (int)133, (int)15, (String)ComponentFactory.translatable((String)"button.lostradar.clear").getString()).event(() -> {
            ClientMapData.getData().clearSearchResults();
            ClientMapData.getData().setSearchString("");
            Messages.sendToServer(new PacketStartSearch("", 0));
            this.categoryList.selected(-1);
        });
        toplevel.children(new Widget[]{this.categoryList, this.scanButton, clearButton});
        toplevel.bounds(k, l, 380, 236);
        this.populateCategoryList();
        this.window = new Window((Screen)this, (AbstractContainerWidget)toplevel);
    }

    private void renderMap(GuiGraphics graphics) {
        BatchQuadGuiRenderer batch = new BatchQuadGuiRenderer();
        ClientMapData data = ClientMapData.getData();
        ChunkPos p = new ChunkPos(Minecraft.m_91087_().f_91074_.m_20183_());
        int borderLeft = this.guiLeft + 12;
        int borderTop = this.guiTop + 12;
        HashSet<ChunkPos> searchResults = new HashSet<ChunkPos>(data.getSearchResults());
        List<Icon> icons = this.renderCityGrid(batch, searchResults, p, data, borderLeft, borderTop);
        this.renderDistantSearchResults(batch, searchResults, p, borderLeft, borderTop);
        batch.render(graphics);
        float angle = Minecraft.m_91087_().f_91074_.m_146908_() + 180.0f;
        RenderSystem.setShader(GameRenderer::m_172817_);
        int startX = borderLeft + 100;
        int startZ = borderTop + 100;
        RenderHelper.drawRotatedIcon((GuiGraphics)graphics, (int)(startX + 2), (int)(startZ + 2), (int)16, (double)angle, (ResourceLocation)MAP_ICONS_LOCATION, (int)0, (int)0, (int)16, (int)16);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (Icon icon : icons) {
            graphics.m_280411_(ICONS, icon.x(), icon.y(), icon.w(), icon.h(), (float)icon.u(), (float)icon.v(), icon.pw(), icon.ph(), 256, 256);
        }
    }

    private List<Icon> renderCityGrid(BatchQuadGuiRenderer batch, Set<ChunkPos> searchResults, ChunkPos p, ClientMapData data, int borderLeft, int borderTop) {
        Set<EntryPos> searchedChunks = data.getSearchedChunks();
        float time = (float)(System.currentTimeMillis() % 4000L) / 2000.0f;
        if (time > 1.0f) {
            time = 2.0f - time;
        }
        int r = (int)((float)((Integer)Config.HILIGHT_R1.get()).intValue() + (float)((Integer)Config.HILIGHT_R2.get() - (Integer)Config.HILIGHT_R1.get()) * time);
        int g = (int)((float)((Integer)Config.HILIGHT_G1.get()).intValue() + (float)((Integer)Config.HILIGHT_G2.get() - (Integer)Config.HILIGHT_G1.get()) * time);
        int b = (int)((float)((Integer)Config.HILIGHT_B1.get()).intValue() + (float)((Integer)Config.HILIGHT_B2.get() - (Integer)Config.HILIGHT_B1.get()) * time);
        int highlightColor = 0xFF000000 | r << 16 | g << 8 | b;
        int energyStored = ((RadarItem)Registration.RADAR.get()).getEnergyStored(Minecraft.m_91087_().f_91074_.m_21205_());
        boolean hasEnergy = energyStored >= (Integer)Config.RADAR_MINENERGY_FOR_MAP.get();
        ArrayList<Icon> icons = new ArrayList<Icon>();
        for (int x = -10; x <= 10; ++x) {
            for (int z = -10; z <= 10; ++z) {
                ChunkPos pos = new ChunkPos(p.f_45578_ + x, p.f_45579_ + z);
                int biomeColor = data.getBiomeColor((Level)Minecraft.m_91087_().f_91073_, pos);
                if (biomeColor != -1) {
                    if (!hasEnergy) {
                        biomeColor = -8947849;
                    }
                    RenderHelper.drawBeveledBox((BatchQuadGuiRenderer)batch, (int)(borderLeft + (x + 10) * 10), (int)(borderTop + (z + 10) * 10), (int)(borderLeft + (x + 10 + 1) * 10), (int)(borderTop + (z + 10 + 1) * 10), (int)(-16777216 + biomeColor), (int)(-16777216 + biomeColor), (int)(-16777216 + biomeColor));
                }
                int startX = borderLeft + (x + 10) * 10;
                int startZ = borderTop + (z + 10) * 10;
                MapPalette.PaletteEntry entry = data.getPaletteEntry((Level)Minecraft.m_91087_().f_91073_, pos);
                if (entry != null) {
                    int color = entry.color();
                    if (!hasEnergy) {
                        color = 0x444444;
                    }
                    int fullColor = 0xFF000000 | color & 0xFFFFFF;
                    int borderColor = -13421773;
                    if (searchResults.contains(pos)) {
                        borderColor = highlightColor;
                        searchResults.remove(pos);
                    }
                    if (entry == MapPalette.CITY) {
                        RenderHelper.drawBeveledBox((BatchQuadGuiRenderer)batch, (int)startX, (int)startZ, (int)(startX + 10), (int)(startZ + 10), (int)fullColor, (int)fullColor, (int)fullColor);
                        int patternOffsetX = x % 2;
                        int patternOffsetZ = z % 2;
                        int step = 2;
                        for (int i = 0; i < 5; ++i) {
                            for (int j = 0; j < 5; ++j) {
                                if ((i + j + patternOffsetX + patternOffsetZ) % 2 != 0) continue;
                                int x0 = startX + i * step;
                                int z0 = startZ + j * step;
                                int x1 = startX + (i + 1) * step;
                                int z1 = startZ + (j + 1) * step;
                                RenderHelper.drawBeveledBox((BatchQuadGuiRenderer)batch, (int)x0, (int)z0, (int)x1, (int)z1, (int)-16777216, (int)-16777216, (int)-16777216);
                            }
                        }
                    } else {
                        RenderHelper.drawBeveledBox((BatchQuadGuiRenderer)batch, (int)(borderLeft + (x + 10) * 10), (int)(borderTop + (z + 10) * 10), (int)(borderLeft + (x + 10 + 1) * 10), (int)(borderTop + (z + 10 + 1) * 10), (int)borderColor, (int)borderColor, (int)(-16777216 + color));
                    }
                    if (entry.iconU() >= 0) {
                        icons.add(new Icon(startX + 2, startZ + 2, 6, 6, entry.iconU(), entry.iconV(), 32, 32));
                    }
                }
                if (searchedChunks.isEmpty() || searchedChunks.contains(EntryPos.fromChunkPos((ResourceKey<Level>)Minecraft.m_91087_().f_91073_.m_46472_(), pos))) continue;
                RenderHelper.drawBeveledBox((BatchQuadGuiRenderer)batch, (int)(borderLeft + (x + 10) * 10), (int)(borderTop + (z + 10) * 10), (int)(borderLeft + (x + 10 + 1) * 10), (int)(borderTop + (z + 10 + 1) * 10), (int)Integer.MIN_VALUE, (int)Integer.MIN_VALUE, (int)Integer.MIN_VALUE);
            }
        }
        return icons;
    }

    private void renderDistantSearchResults(BatchQuadGuiRenderer batch, Set<ChunkPos> searchResults, ChunkPos p, int borderLeft, int borderTop) {
        this.borderCoordinates.clear();
        for (ChunkPos pos : searchResults) {
            int bz;
            int bx;
            int adz;
            int dx = pos.f_45578_ - p.f_45578_;
            int dz = pos.f_45579_ - p.f_45579_;
            if (dx == 0 && dz == 0) continue;
            int adx = Math.abs(dx);
            if (adx * 10 >= (adz = Math.abs(dz)) * 10) {
                bx = Integer.signum(dx) * 11;
                bz = (int)Math.round((double)dz / (double)adx * 11.0);
            } else {
                bz = Integer.signum(dz) * 11;
                bx = (int)Math.round((double)dx / (double)adz * 11.0);
            }
            int distance = Math.max(Math.abs(dx), Math.abs(dz));
            int minDistance = 11;
            int maxDistance = 80;
            int clamped = Math.max(0, Math.min(255, (int)(255.0 * (1.0 - (double)(distance - minDistance) / (double)(maxDistance - minDistance)))));
            int color = 0xFF000000 | clamped << 16 | clamped << 8 | clamped;
            int x1 = borderLeft + (bx + 10) * 10 + 3;
            int y1 = borderTop + (bz + 10) * 10 + 3;
            RenderHelper.drawBeveledBox((BatchQuadGuiRenderer)batch, (int)x1, (int)y1, (int)(borderLeft + (bx + 10 + 1) * 10 - 3), (int)(borderTop + (bz + 10 + 1) * 10 - 3), (int)color, (int)color, (int)color);
            this.borderCoordinates.add((Pair<Rect2i, ChunkPos>)Pair.of((Object)new Rect2i(x1, y1, 4, 4), (Object)pos));
        }
    }

    public static void refresh() {
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen instanceof GuiRadar) {
            GuiRadar radar = (GuiRadar)screen;
            radar.populateCategoryList();
        }
    }

    private void populateCategoryList() {
        ClientMapData data = ClientMapData.getData();
        String searchString = data.getSearchString();
        AtomicInteger selected = new AtomicInteger(this.categoryList.getSelected());
        this.categoryList.removeChildren();
        this.categories.clear();
        PaletteCache palette = PaletteCache.getOrCreatePaletteCache(MapPalette.getDefaultPalette((Level)Minecraft.m_91087_().f_91073_));
        PlayerMapKnowledgeDispatcher.getPlayerMapKnowledge((Player)Minecraft.m_91087_().f_91074_).ifPresent(handler -> {
            for (MapPalette.PaletteEntry category : palette.getPalette().palette()) {
                if (!handler.getKnownCategories().contains(category.name())) continue;
                this.categoryList.children(new Widget[]{this.makeLine(category)});
                this.categories.add(category.name());
                if (searchString.isEmpty() || !category.name().equals(searchString)) continue;
                selected.set(this.categoryList.getChildren().size() - 1);
            }
        });
        this.categoryList.selected(selected.get());
    }

    private Widget<Label> makeLine(MapPalette.PaletteEntry category) {
        return Widgets.label((String)ComponentFactory.translatable((String)category.translatableKey()).getString());
    }

    protected void renderInternal(@Nonnull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        boolean hasEnergy;
        ClientMapData data = ClientMapData.getData();
        boolean scanEnabled = this.categoryList.getSelected() >= 0;
        this.scanButton.enabled(scanEnabled);
        int progress = data.getSearchProgress();
        if (progress >= 100) {
            this.scanButton.text(ComponentFactory.translatable((String)"button.lostradar.scan").getString());
        } else if (data.isPaused()) {
            this.scanButton.text(ComponentFactory.translatable((String)"lostradar.paused_scan", (Object[])new Object[]{progress}).getString());
        } else {
            this.scanButton.text(progress + "%");
        }
        this.drawWindow(graphics);
        this.renderMap(graphics);
        this.renderTooltip(graphics, mouseX, mouseY);
        int energyStored = ((RadarItem)Registration.RADAR.get()).getEnergyStored(Minecraft.m_91087_().f_91074_.m_21205_());
        boolean bl = hasEnergy = energyStored >= (Integer)Config.RADAR_MINENERGY_FOR_MAP.get();
        if (!hasEnergy) {
            graphics.m_280430_(Minecraft.m_91087_().f_91062_, (Component)ComponentFactory.translatable((String)"lostradar.energylow"), this.guiLeft + 12, this.guiTop + 12, -65536);
        }
    }

    private void renderTooltip(@Nonnull GuiGraphics graphics, int xxmouseX, int yymouseY) {
        int mouseX = GuiTools.getRelativeX((Screen)this);
        int mouseY = GuiTools.getRelativeY((Screen)this);
        int borderLeft = this.guiLeft + 12;
        int borderTop = this.guiTop + 12;
        ClientMapData data = ClientMapData.getData();
        ChunkPos p = new ChunkPos(Minecraft.m_91087_().f_91074_.m_20183_());
        int tooltipX = mouseX - 20;
        int tooltipY = mouseY - 3;
        if (tooltipY < 14) {
            tooltipY = mouseY + 20;
        }
        if (mouseX < borderLeft || mouseX > borderLeft + 210 || mouseY < borderTop || mouseY > borderTop + 210) {
            for (Pair<Rect2i, ChunkPos> pair : this.borderCoordinates) {
                Rect2i rect = (Rect2i)pair.getKey();
                ChunkPos pos = (ChunkPos)pair.getValue();
                if (!rect.m_110087_(mouseX, mouseY)) continue;
                String posString = String.format("%d, %d", pos.m_151390_(), pos.m_151393_());
                String distanceString = String.format("%d", Math.max(Math.abs(pos.f_45578_ - p.f_45578_), Math.abs(pos.f_45579_ - p.f_45579_)) * 16);
                List<MutableComponent> components = List.of(ComponentFactory.translatable((String)"lostradar.chunk.pos", (Object[])new Object[]{posString}), ComponentFactory.translatable((String)"lostradar.chunk.dist", (Object[])new Object[]{distanceString}));
                graphics.m_280677_(Minecraft.m_91087_().f_91062_, components, Optional.empty(), tooltipX, tooltipY);
                break;
            }
        } else {
            ChunkPos pos = new ChunkPos(p.f_45578_ + (mouseX - borderLeft) / 10 - 10, p.f_45579_ + (mouseY - borderTop) / 10 - 10);
            MapPalette.PaletteEntry entry = data.getPaletteEntry((Level)Minecraft.m_91087_().f_91073_, pos);
            if (entry != null) {
                graphics.m_280557_(Minecraft.m_91087_().f_91062_, (Component)ComponentFactory.translatable((String)entry.translatableKey()), tooltipX, tooltipY);
            }
        }
    }

    public void keyTypedFromEvent(int keyCode, int scanCode) {
        if (this.window != null && this.window.keyTyped(keyCode, scanCode)) {
            super.m_7933_(keyCode, scanCode, 0);
        }
    }

    public void charTypedFromEvent(char codePoint) {
        if (this.window != null && this.window.charTyped(codePoint)) {
            super.m_5534_(codePoint, 0);
        }
    }

    public boolean mouseClickedFromEvent(double x, double y, int button) {
        WindowManager manager = this.getWindow().getWindowManager();
        manager.mouseClicked(x, y, button);
        return true;
    }

    public boolean mouseReleasedFromEvent(double x, double y, int button) {
        WindowManager manager = this.getWindow().getWindowManager();
        manager.mouseReleased(x, y, button);
        return true;
    }

    public boolean mouseScrolledFromEvent(double x, double y, double amount) {
        WindowManager manager = this.getWindow().getWindowManager();
        manager.mouseScrolled(x, y, amount);
        return true;
    }

    public static void open() {
        Minecraft.m_91087_().m_91152_((Screen)new GuiRadar());
    }

    private record Icon(int x, int y, int w, int h, int u, int v, int pw, int ph) {
    }
}

