/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostradar.radar;

import javax.annotation.Nonnull;
import mcjty.lib.varia.EnergyTools;
import mcjty.lib.varia.IEnergyItem;
import mcjty.lib.varia.ItemCapabilityProvider;
import mcjty.lostradar.LostRadar;
import mcjty.lostradar.data.PlayerMapKnowledgeDispatcher;
import mcjty.lostradar.network.Messages;
import mcjty.lostradar.network.PacketKnowledgeToPlayer;
import mcjty.lostradar.radar.GuiRadar;
import mcjty.lostradar.setup.Config;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class RadarItem
extends Item
implements IEnergyItem {
    public RadarItem() {
        super(LostRadar.setup.defaultProperties().m_41487_(1).m_41499_(1));
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(@Nonnull Level world, @Nonnull Player player, @Nonnull InteractionHand hand) {
        if (world.f_46443_) {
            GuiRadar.open();
        } else {
            PlayerMapKnowledgeDispatcher.getPlayerMapKnowledge(player).ifPresent(handler -> Messages.sendToPlayer(new PacketKnowledgeToPlayer(handler.getKnownCategories()), player));
        }
        return super.m_7203_(world, player, hand);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        if (oldStack.m_41619_() != newStack.m_41619_()) {
            return true;
        }
        return oldStack.m_41720_() != newStack.m_41720_();
    }

    public boolean m_142522_(ItemStack stack) {
        return stack.m_41783_() != null && stack.m_41783_().m_128441_("Energy");
    }

    public boolean m_41465_() {
        return true;
    }

    public int getMaxDamage(ItemStack stack) {
        return (Integer)Config.RADAR_MAXENERGY.get();
    }

    public int getDamage(ItemStack stack) {
        if (stack.m_41783_() == null || !stack.m_41783_().m_128441_("Energy")) {
            return 0;
        }
        return (Integer)Config.RADAR_MAXENERGY.get() - stack.m_41783_().m_128451_("Energy");
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag nbt) {
        return new ItemCapabilityProvider(stack, (IEnergyItem)this);
    }

    public long receiveEnergyL(ItemStack container, long maxReceive, boolean simulate) {
        if (container.m_41783_() == null) {
            container.m_41751_(new CompoundTag());
        }
        int energy = container.m_41783_().m_128451_("Energy");
        int energyReceived = Math.min((Integer)Config.RADAR_MAXENERGY.get() - energy, Math.min((Integer)Config.RADAR_RECEIVEPERTICK.get(), EnergyTools.unsignedClampToInt((long)maxReceive)));
        if (!simulate) {
            container.m_41783_().m_128405_("Energy", energy += energyReceived);
        }
        return energyReceived;
    }

    public long extractEnergyL(ItemStack container, long maxExtract, boolean simulate) {
        if (container.m_41783_() == null || !container.m_41783_().m_128441_("Energy")) {
            return 0L;
        }
        int energy = container.m_41783_().m_128451_("Energy");
        int energyExtracted = 0;
        if (!simulate) {
            container.m_41783_().m_128405_("Energy", energy -= energyExtracted);
        }
        return energyExtracted;
    }

    public long getEnergyStoredL(ItemStack container) {
        if (container.m_41783_() == null || !container.m_41783_().m_128441_("Energy")) {
            return 0L;
        }
        return container.m_41783_().m_128451_("Energy");
    }

    public long getMaxEnergyStoredL(ItemStack container) {
        return ((Integer)Config.RADAR_MAXENERGY.get()).intValue();
    }

    public int extractEnergyNoMax(ItemStack container, int maxExtract, boolean simulate) {
        if (container.m_41783_() == null || !container.m_41783_().m_128441_("Energy")) {
            return 0;
        }
        int energy = container.m_41783_().m_128451_("Energy");
        int energyExtracted = Math.min(energy, maxExtract);
        if (!simulate) {
            container.m_41783_().m_128405_("Energy", energy -= energyExtracted);
        }
        return energyExtracted;
    }
}

