/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.simplerpc.api.utils;

import com.hypherionmc.craterlib.nojang.client.BridgedMinecraft;
import com.hypherionmc.craterlib.nojang.resources.ResourceIdentifier;
import com.hypherionmc.simplerpc.api.variables.PlaceholderEngine;
import com.hypherionmc.simplerpc.config.objects.DimensionSection;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.text.WordUtils;
import org.jetbrains.annotations.ApiStatus;

public class APIUtils {
    public static String CUR_DIR = System.getProperty("user.dir");

    public static String worldNameToReadable(String name) {
        if (name.split(":").length > 1) {
            name = name.split(":")[1];
        }
        name = name.replace("_", " ");
        return WordUtils.capitalizeFully((String)name);
    }

    @ApiStatus.Internal
    public static Optional<DimensionSection.Dimension> findDimension(List<DimensionSection.Dimension> list) {
        String dimensionName = APIUtils.getWorld();
        String biome = APIUtils.getBiome();
        if (dimensionName.toLowerCase().contains("minecraft:")) {
            dimensionName = dimensionName.replace("minecraft:", "");
        }
        if (biome.toLowerCase().contains("minecraft:")) {
            biome = biome.replace("minecraft:", "");
        }
        dimensionName = dimensionName.toLowerCase();
        biome = biome.toLowerCase();
        String finalDimensionName = dimensionName;
        String finalBiomeName = "biome:" + biome;
        if (list.stream().anyMatch(c -> c.name.equalsIgnoreCase(finalDimensionName))) {
            return list.stream().filter(c -> c.name.equalsIgnoreCase(finalDimensionName)).findFirst();
        }
        if (list.stream().anyMatch(c -> c.name.equalsIgnoreCase(finalBiomeName))) {
            return list.stream().filter(c -> c.name.equalsIgnoreCase(finalBiomeName)).findFirst();
        }
        String joined = finalDimensionName + "|" + finalBiomeName.replace("biome:", "");
        return list.stream().filter(c -> c.name.equalsIgnoreCase(joined)).findFirst();
    }

    public static String parseAndLimit(String input, int limit) {
        String ret = PlaceholderEngine.INSTANCE.resolvePlaceholders(input);
        return ret.substring(0, Math.min(ret.length(), limit));
    }

    private static String getWorld() {
        if (BridgedMinecraft.getInstance().getLevel() != null && BridgedMinecraft.getInstance().getLevel().getDimensionKey() != null) {
            return BridgedMinecraft.getInstance().getLevel().getDimensionKey().getString();
        }
        return "unknown";
    }

    private static String getBiome() {
        if (BridgedMinecraft.getInstance().getLevel() != null && BridgedMinecraft.getInstance().getPlayer() != null) {
            ResourceIdentifier identifier = BridgedMinecraft.getInstance().getLevel().getBiomeIdentifier(BridgedMinecraft.getInstance().getPlayer().getOnPos());
            return identifier != null ? identifier.getString() : "unknown";
        }
        return "unknown";
    }
}

