/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.simplerpc.discord;

import com.hypherionmc.craterlib.core.event.CraterEvent;
import com.hypherionmc.craterlib.core.event.CraterEventBus;
import com.hypherionmc.simplerpc.RPCConstants;
import com.hypherionmc.simplerpc.api.events.RPCEvents;
import com.hypherionmc.simplerpc.config.impl.ClientConfig;
import com.hypherionmc.simplerpc.config.impl.ReplayModConfig;
import com.hypherionmc.simplerpc.config.impl.ServerEntriesConfig;
import com.hypherionmc.simplerpc.discord.RichPresenceEvents;
import com.hypherionmc.simplerpc.discord.SimpleRpcDiscordEventHandler;
import com.hypherionmc.simplerpc.integrations.launchers.LauncherDetector;
import com.hypherionmc.simplerpc.rpcsdk.DiscordRpc;
import com.hypherionmc.simplerpc.rpcsdk.exceptions.PipeAccessDenied;
import com.hypherionmc.simplerpc.rpcsdk.models.DiscordRichPresence;
import com.hypherionmc.simplerpc.util.CompatUtils;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public final class SimpleRPCCore {
    static final ScheduledExecutorService taskManager = Executors.newScheduledThreadPool(Runtime.getRuntime().availableProcessors());
    public static final SimpleRPCCore INSTANCE = new SimpleRPCCore();
    private DiscordController discordController;
    private RichPresenceEvents events;
    private String langCode;
    private String lastDiscordID = "0";
    private ClientConfig clientConfig;
    private ServerEntriesConfig serverEntriesConfig;
    public static ReplayModConfig replayModConfig;

    public void init() {
        this.langCode = "en_us";
        this.clientConfig = new ClientConfig(this);
        this.serverEntriesConfig = new ServerEntriesConfig(this);
        if (this.clientConfig != null) {
            this.discordController = new DiscordController(this.clientConfig);
            this.events = new RichPresenceEvents(this);
            this.lastDiscordID = this.clientConfig.general.discordid;
            if (this.clientConfig.general.launcherIntegration) {
                LauncherDetector.INSTANCE.loadLaunchers();
            }
            taskManager.scheduleAtFixedRate(() -> {
                if (this.events != null) {
                    this.events.updateRPC();
                }
            }, 1L, 2L, TimeUnit.SECONDS);
        }
        if (CompatUtils.hasReplay) {
            replayModConfig = new ReplayModConfig(this);
        }
    }

    private void reInit() {
        this.discordController.shutdownRichPresence();
        this.discordController = new DiscordController(this.clientConfig);
        this.lastDiscordID = this.clientConfig.general.discordid;
        this.events.updateRPC();
    }

    public void setLangCode(String code) {
        if (code != null && !code.equalsIgnoreCase(this.langCode)) {
            CraterEventBus.INSTANCE.postEvent((CraterEvent)RPCEvents.LanguageChanged.of(code));
            try {
                this.langCode = code;
                this.clientConfig = new ClientConfig(this);
                this.reInit();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @ApiStatus.Internal
    public void setClientConfig(ClientConfig clientConfig) {
        this.clientConfig = clientConfig;
        if (this.discordController != null && !this.lastDiscordID.equals(clientConfig.general.discordid)) {
            this.reInit();
        }
        if (this.discordController != null) {
            this.getEvents().updateRPC();
        }
    }

    @ApiStatus.Internal
    public void setServerEntriesConfig(ServerEntriesConfig serverEntriesConfig) {
        this.serverEntriesConfig = serverEntriesConfig;
        if (this.discordController != null) {
            this.getEvents().updateRPC();
        }
    }

    public void setReplayModConfig(ReplayModConfig replayModConfig) {
        SimpleRPCCore.replayModConfig = replayModConfig;
    }

    @Generated
    private SimpleRPCCore() {
    }

    @Generated
    public DiscordController getDiscordController() {
        return this.discordController;
    }

    @Generated
    public RichPresenceEvents getEvents() {
        return this.events;
    }

    @Generated
    public String getLangCode() {
        return this.langCode;
    }

    @Generated
    public String getLastDiscordID() {
        return this.lastDiscordID;
    }

    @Generated
    public ClientConfig getClientConfig() {
        return this.clientConfig;
    }

    @Generated
    public ServerEntriesConfig getServerEntriesConfig() {
        return this.serverEntriesConfig;
    }

    static class DiscordController {
        private final DiscordRpc discordRPC;
        private final ClientConfig clientConfig;

        DiscordController(ClientConfig clientConfig) {
            block3: {
                this.clientConfig = clientConfig;
                this.discordRPC = new DiscordRpc();
                try {
                    this.discordRPC.init(clientConfig.general.discordid, new SimpleRpcDiscordEventHandler(), false);
                    taskManager.scheduleAtFixedRate(this.discordRPC::runCallbacks, 0L, 500L, TimeUnit.MILLISECONDS);
                }
                catch (PipeAccessDenied ee) {
                    RPCConstants.logger.error("Failed to connect to Discord API because of a permission error. Check that your Discord/Game is NOT running in Administrator mode!");
                }
                catch (Exception e) {
                    if (clientConfig == null || !clientConfig.general.debugging) break block3;
                    RPCConstants.logger.error("Failed to connect to discord", (Throwable)e);
                }
            }
        }

        void updateRichPresence(@Nullable DiscordRichPresence presence) {
            block4: {
                RPCEvents.RichPresenceUpdated updated = RPCEvents.RichPresenceUpdated.of(presence);
                if (updated.wasCancelled()) {
                    presence = updated.getPresence();
                }
                try {
                    if (this.discordRPC != null) {
                        this.discordRPC.updatePresence(presence);
                    }
                }
                catch (Exception e) {
                    if (this.clientConfig == null || !this.clientConfig.general.debugging) break block4;
                    RPCConstants.logger.error("Failed to update Rich Presence", (Throwable)e);
                }
            }
        }

        void shutdownRichPresence() {
            CraterEventBus.INSTANCE.postEvent((CraterEvent)RPCEvents.RichPresenceShutDown.of());
            if (this.discordRPC != null) {
                this.discordRPC.updatePresence(null);
                this.discordRPC.shutdown();
            }
        }
    }
}

