/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.simplerpc.jodd.http;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;

public class HttpMultiMap<V>
implements Iterable<Map.Entry<String, V>> {
    private static final int BUCKET_SIZE = 31;
    private final boolean caseSensitive;
    private final MapEntry<V>[] entries = new MapEntry[32];
    private final MapEntry<V> head = new MapEntry(-1, null, null);

    public static <T> HttpMultiMap<T> newCaseInsensitiveMap() {
        return new HttpMultiMap(false);
    }

    public static <T> HttpMultiMap<T> newCaseSensitiveMap() {
        return new HttpMultiMap(true);
    }

    protected HttpMultiMap(boolean caseSensitive) {
        this.head.after = this.head;
        this.head.before = this.head.after;
        this.caseSensitive = caseSensitive;
    }

    private int hash(String name) {
        int h = 0;
        for (int i = name.length() - 1; i >= 0; --i) {
            char c = name.charAt(i);
            if (!this.caseSensitive && c >= 'A' && c <= 'Z') {
                c = (char)(c + 32);
            }
            h = 31 * h + c;
        }
        if (h > 0) {
            return h;
        }
        if (h == Integer.MIN_VALUE) {
            return Integer.MAX_VALUE;
        }
        return -h;
    }

    private static int index(int hash) {
        return hash & 0x1F;
    }

    private boolean eq(String name1, String name2) {
        int nameLen = name1.length();
        if (nameLen != name2.length()) {
            return false;
        }
        for (int i = nameLen - 1; i >= 0; --i) {
            char c2;
            char c1 = name1.charAt(i);
            if (c1 == (c2 = name2.charAt(i))) continue;
            if (this.caseSensitive) {
                return false;
            }
            if (c1 >= 'A' && c1 <= 'Z') {
                c1 = (char)(c1 + 32);
            }
            if (c2 >= 'A' && c2 <= 'Z') {
                c2 = (char)(c2 + 32);
            }
            if (c1 == c2) continue;
            return false;
        }
        return true;
    }

    public int size() {
        return this.names().size();
    }

    public HttpMultiMap<V> clear() {
        for (int i = 0; i < this.entries.length; ++i) {
            this.entries[i] = null;
        }
        this.head.after = this.head;
        this.head.before = this.head.after;
        return this;
    }

    public boolean contains(String name) {
        return this.getEntry(name) != null;
    }

    public boolean isEmpty() {
        return this.head == this.head.after;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, V> entry : this) {
            sb.append(entry).append('\n');
        }
        return sb.toString();
    }

    private HttpMultiMap<V> _set(Iterable<Map.Entry<String, V>> map) {
        this.clear();
        for (Map.Entry<String, V> entry : map) {
            this.add(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public HttpMultiMap<V> setAll(HttpMultiMap<V> multiMap) {
        return this._set(multiMap);
    }

    public HttpMultiMap<V> setAll(Map<String, V> map) {
        return this._set(map.entrySet());
    }

    public HttpMultiMap<V> set(String name, V value) {
        int h = this.hash(name);
        int i = HttpMultiMap.index(h);
        this._remove(h, i, name);
        this._add(h, i, name, value);
        return this;
    }

    public HttpMultiMap<V> setAll(String name, Iterable<V> values) {
        int h = this.hash(name);
        int i = HttpMultiMap.index(h);
        this._remove(h, i, name);
        for (V v : values) {
            this._add(h, i, name, v);
        }
        return this;
    }

    public HttpMultiMap<V> add(String name, V value) {
        int h = this.hash(name);
        int i = HttpMultiMap.index(h);
        this._add(h, i, name, value);
        return this;
    }

    public HttpMultiMap<V> addAll(String name, Iterable<V> values) {
        int h = this.hash(name);
        int i = HttpMultiMap.index(h);
        for (V value : values) {
            this._add(h, i, name, value);
        }
        return this;
    }

    public HttpMultiMap<V> addAll(HttpMultiMap<V> map) {
        for (Map.Entry<String, V> entry : map.entries()) {
            this.add(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public HttpMultiMap<V> addAll(Map<String, V> map) {
        for (Map.Entry<String, V> entry : map.entrySet()) {
            this.add(entry.getKey(), entry.getValue());
        }
        return this;
    }

    private void _add(int hash, int index, String name, V value) {
        MapEntry<V> e = this.entries[index];
        MapEntry<V> newEntry = new MapEntry<V>(hash, name, value);
        this.entries[index] = newEntry;
        newEntry.next = e;
        newEntry.addBefore(this.head);
    }

    public HttpMultiMap<V> remove(String name) {
        int h = this.hash(name);
        int i = HttpMultiMap.index(h);
        this._remove(h, i, name);
        return this;
    }

    private void _remove(int hash, int index, String name) {
        MapEntry next;
        MapEntry<V> e = this.entries[index];
        if (e == null) {
            return;
        }
        while (e.hash == hash && this.eq(name, e.key)) {
            e.remove();
            next = e.next;
            if (next != null) {
                this.entries[index] = next;
                e = next;
                continue;
            }
            this.entries[index] = null;
            return;
        }
        while ((next = e.next) != null) {
            if (next.hash == hash && this.eq(name, next.key)) {
                e.next = next.next;
                next.remove();
                continue;
            }
            e = next;
        }
    }

    public V get(String name) {
        Map.Entry<String, V> entry = this.getEntry(name);
        if (entry == null) {
            return null;
        }
        return entry.getValue();
    }

    public Map.Entry<String, V> getEntry(String name) {
        int h = this.hash(name);
        int i = HttpMultiMap.index(h);
        MapEntry<V> e = this.entries[i];
        while (e != null) {
            if (e.hash == h && this.eq(name, e.key)) {
                return e;
            }
            e = e.next;
        }
        return null;
    }

    public List<V> getAll(String name) {
        LinkedList<V> values = new LinkedList<V>();
        int h = this.hash(name);
        int i = HttpMultiMap.index(h);
        MapEntry<V> e = this.entries[i];
        while (e != null) {
            if (e.hash == h && this.eq(name, e.key)) {
                values.addFirst(e.getValue());
            }
            e = e.next;
        }
        return values;
    }

    @Override
    public Iterator<Map.Entry<String, V>> iterator() {
        final MapEntry[] e = new MapEntry[]{this.head.after};
        return new Iterator<Map.Entry<String, V>>(){

            @Override
            public boolean hasNext() {
                return e[0] != HttpMultiMap.this.head;
            }

            @Override
            public Map.Entry<String, V> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("No next() entry in the iteration");
                }
                MapEntry next = e[0];
                e[0] = e[0].after;
                return next;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Set<String> names() {
        TreeSet<String> names = new TreeSet<String>(this.caseSensitive ? null : String.CASE_INSENSITIVE_ORDER);
        MapEntry e = this.head.after;
        while (e != this.head) {
            names.add(e.getKey());
            e = e.after;
        }
        return names;
    }

    public List<Map.Entry<String, V>> entries() {
        LinkedList<Map.Entry<String, V>> all = new LinkedList<Map.Entry<String, V>>();
        MapEntry e = this.head.after;
        while (e != this.head) {
            all.add(e);
            e = e.after;
        }
        return all;
    }

    private static final class MapEntry<V>
    implements Map.Entry<String, V> {
        final int hash;
        final String key;
        V value;
        MapEntry<V> next;
        MapEntry<V> before;
        MapEntry<V> after;

        private MapEntry(int hash, String key, V value) {
            this.hash = hash;
            this.key = key;
            this.value = value;
        }

        void remove() {
            this.before.after = this.after;
            this.after.before = this.before;
        }

        void addBefore(MapEntry<V> e) {
            this.after = e;
            this.before = e.before;
            this.before.after = this;
            this.after.before = this;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            V oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        public String toString() {
            return this.getKey() + ": " + this.getValue();
        }
    }
}

