/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.simplerpc.jodd.typeconverter.impl;

import com.hypherionmc.simplerpc.jodd.time.JulianDate;
import com.hypherionmc.simplerpc.jodd.time.TimeUtil;
import com.hypherionmc.simplerpc.jodd.typeconverter.TypeConversionException;
import com.hypherionmc.simplerpc.jodd.typeconverter.TypeConverter;
import com.hypherionmc.simplerpc.jodd.util.StringUtil;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Calendar;
import java.util.Date;

public class CalendarConverter
implements TypeConverter<Calendar> {
    @Override
    public Calendar convert(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Calendar) {
            return (Calendar)value;
        }
        if (value instanceof Date) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime((Date)value);
            return calendar;
        }
        if (value instanceof JulianDate) {
            return TimeUtil.toCalendar(((JulianDate)value).toLocalDateTime());
        }
        if (value instanceof LocalDateTime) {
            return TimeUtil.toCalendar((LocalDateTime)value);
        }
        if (value instanceof LocalDate) {
            return TimeUtil.toCalendar((LocalDate)value);
        }
        if (value instanceof Number) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(((Number)value).longValue());
            return calendar;
        }
        String stringValue = value.toString().trim();
        if (!StringUtil.containsOnlyDigits(stringValue)) {
            return TimeUtil.toCalendar(LocalDateTime.parse(stringValue));
        }
        try {
            long milliseconds = Long.parseLong(stringValue);
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(milliseconds);
            return calendar;
        }
        catch (NumberFormatException nfex) {
            throw new TypeConversionException(value, (Throwable)nfex);
        }
    }
}

