/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.simplerpc.jodd.typeconverter.impl;

import com.hypherionmc.simplerpc.jodd.io.FileUtil;
import com.hypherionmc.simplerpc.jodd.typeconverter.TypeConversionException;
import com.hypherionmc.simplerpc.jodd.typeconverter.TypeConverter;
import java.io.File;
import java.io.IOException;

public class FileConverter
implements TypeConverter<File> {
    @Override
    public File convert(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof File) {
            return (File)value;
        }
        Class<?> type = value.getClass();
        if (type == byte[].class) {
            try {
                File tempFile = FileUtil.createTempFile();
                FileUtil.writeBytes(tempFile, (byte[])value);
                return tempFile;
            }
            catch (IOException ioex) {
                throw new TypeConversionException(ioex);
            }
        }
        if (type == String.class) {
            try {
                File tempFile = FileUtil.createTempFile();
                FileUtil.writeString(tempFile, value.toString());
                return tempFile;
            }
            catch (IOException ioex) {
                throw new TypeConversionException(ioex);
            }
        }
        throw new TypeConversionException(value);
    }
}

