/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.simplerpc.jodd.util;

import com.hypherionmc.simplerpc.jodd.util.CharUtil;
import com.hypherionmc.simplerpc.jodd.util.StringUtil;
import java.io.Serializable;
import java.util.Comparator;

public class NaturalOrderComparator<T>
implements Comparator<T>,
Serializable {
    private static final char[] ACCENT_CHARS = new char[]{'\u00c0', 'A', '\u00c1', 'A', '\u00c2', 'A', '\u00c3', 'A', '\u00c4', 'A', '\u00c5', 'A', '\u00e0', 'a', '\u00e1', 'a', '\u00e2', 'a', '\u00e3', 'a', '\u00e4', 'a', '\u00e5', 'a', '\u00c7', 'C', '\u00e7', 'c', '\u00c8', 'E', '\u00c9', 'E', '\u00ca', 'E', '\u00cb', 'E', '\u00e8', 'e', '\u00e9', 'e', '\u00ea', 'e', '\u00eb', 'e', '\u00cc', 'I', '\u00cd', 'I', '\u00ce', 'I', '\u00cf', 'I', '\u00ec', 'i', '\u00ed', 'i', '\u00ee', 'i', '\u00ef', 'i', '\u00d2', 'O', '\u00d3', 'O', '\u00d4', 'O', '\u00d5', 'O', '\u00d6', 'O', '\u00d8', 'O', '\u00f2', 'o', '\u00f3', 'o', '\u00f4', 'o', '\u00f5', 'o', '\u00f6', 'o', '\u00f8', 'o', '\u00d1', 'N', '\u00f1', 'n', '\u00d9', 'U', '\u00da', 'U', '\u00db', 'U', '\u00dc', 'U', '\u00f9', 'u', '\u00fa', 'u', '\u00fb', 'u', '\u00fc', 'u', '\u00dd', 'Y', '\u00ff', 'y', '\u00fd', 'y'};
    protected final boolean ignoreCase;
    protected final boolean ignoreAccents;
    protected final boolean skipSpaces;

    public NaturalOrderComparator() {
        this(false, true, true);
    }

    public NaturalOrderComparator(boolean ignoreCase, boolean ignoreAccents, boolean skipSpaces) {
        this.ignoreCase = ignoreCase;
        this.ignoreAccents = ignoreAccents;
        this.skipSpaces = skipSpaces;
    }

    protected int[] compareDigits(String str1, int ndx1, String str2, int ndx2) {
        char char2;
        boolean isDigitChar2;
        char char1;
        boolean isDigitChar1;
        int zeroCount1 = 0;
        while (NaturalOrderComparator.charAt(str1, ndx1) == '0') {
            ++zeroCount1;
            ++ndx1;
        }
        int len1 = 0;
        while (isDigitChar1 = CharUtil.isDigit(char1 = NaturalOrderComparator.charAt(str1, ndx1))) {
            ++len1;
            ++ndx1;
        }
        int zeroCount2 = 0;
        while (NaturalOrderComparator.charAt(str2, ndx2) == '0') {
            ++zeroCount2;
            ++ndx2;
        }
        int len2 = 0;
        int ndx1_new = ndx1 - len1;
        int equalNumbers = 0;
        while (isDigitChar2 = CharUtil.isDigit(char2 = NaturalOrderComparator.charAt(str2, ndx2))) {
            if (equalNumbers == 0 && ndx1_new < ndx1) {
                equalNumbers = NaturalOrderComparator.charAt(str1, ndx1_new++) - char2;
            }
            ++len2;
            ++ndx2;
        }
        if (len1 != len2) {
            return new int[]{len1 - len2};
        }
        if (equalNumbers != 0) {
            return new int[]{equalNumbers};
        }
        return new int[]{0, zeroCount1 - zeroCount2, ndx1, ndx2};
    }

    @Override
    public int compare(T o1, T o2) {
        String str1 = o1.toString();
        String str2 = o2.toString();
        if (this.ignoreAccents) {
            str1 = StringUtil.replace(str1, "\u00df", "ss");
            str2 = StringUtil.replace(str2, "\u00df", "ss");
            str1 = StringUtil.replace(str1, "\u00e6", "ae");
            str2 = StringUtil.replace(str2, "\u00e6", "ae");
            str1 = StringUtil.replace(str1, "\u00c6", "AE");
            str2 = StringUtil.replace(str2, "\u00c6", "AE");
        }
        int ndx1 = 0;
        int ndx2 = 0;
        int lastZeroDifference = 0;
        while (true) {
            char char1 = NaturalOrderComparator.charAt(str1, ndx1);
            char char2 = NaturalOrderComparator.charAt(str2, ndx2);
            if (this.skipSpaces) {
                while (Character.isSpaceChar(char1)) {
                    char1 = NaturalOrderComparator.charAt(str1, ++ndx1);
                }
                while (Character.isSpaceChar(char2)) {
                    char2 = NaturalOrderComparator.charAt(str2, ++ndx2);
                }
            }
            boolean isDigitChar1 = CharUtil.isDigit(char1);
            boolean isDigitChar2 = CharUtil.isDigit(char2);
            if (isDigitChar1 && isDigitChar2) {
                int[] result = this.compareDigits(str1, ndx1, str2, ndx2);
                if (result[0] != 0) {
                    return result[0];
                }
                if (lastZeroDifference == 0) {
                    lastZeroDifference = result[1];
                }
                ndx1 = result[2];
                ndx2 = result[3];
                continue;
            }
            if (char1 == '\u0000' && char2 == '\u0000') {
                return lastZeroDifference;
            }
            if (this.ignoreCase) {
                char1 = Character.toLowerCase(char1);
                char2 = Character.toLowerCase(char2);
            }
            if (this.ignoreAccents) {
                char1 = this.fixAccent(char1);
                char2 = this.fixAccent(char2);
            }
            if (char1 < char2) {
                return -1;
            }
            if (char1 > char2) {
                return 1;
            }
            ++ndx1;
            ++ndx2;
        }
    }

    private char fixAccent(char c) {
        for (int i = 0; i < ACCENT_CHARS.length; i += 2) {
            char accentChar = ACCENT_CHARS[i];
            if (accentChar != c) continue;
            return ACCENT_CHARS[i + 1];
        }
        return c;
    }

    private static char charAt(String string, int ndx) {
        if (ndx >= string.length()) {
            return '\u0000';
        }
        return string.charAt(ndx);
    }
}

